/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print.plaf.basic;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.busylabel.JXBusyLabel;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.listtext.lta.base.LTAComponentFactory;
import com.agfa.pacs.listtext.lta.print.IImageBoxInfo;
import com.agfa.pacs.listtext.lta.print.IPreview;
import com.agfa.pacs.listtext.lta.print.Messages;
import com.agfa.pacs.listtext.lta.print.PrintManager;
import com.agfa.pacs.listtext.lta.print.plaf.basic.DragnDropHandler;
import com.agfa.pacs.listtext.print.IPrintContext;
import com.agfa.pacs.listtext.print.IPrintContextListener;
import com.agfa.pacs.listtext.print.mapper.MapperFilmBox;
import com.agfa.pacs.listtext.print.preview.PreviewPrintContext;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.listtext.swingx.icon.PIconFactory;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.logging.ALogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class BasicPreviewPanel
extends JPanel
implements IPreview,
IPrintContextListener {
    private static final long serialVersionUID = 7654776918269517217L;
    private static final String ICON_PATH = "/com/agfa/pacs/listtext/lta/print/plaf/basic/icons/";
    private static final PIconFactory ICON_FACTORY = new PIconFactory((IComponentFactory)LTAComponentFactory.instance, 24);
    private static final PIcon NEXT_PAGE_ICON = ICON_FACTORY.loadIcon(BasicPreviewPanel.class, "/com/agfa/pacs/listtext/lta/print/plaf/basic/icons/NextSingleArrow.svg");
    private static final PIcon PREVIOUS_PAGE_ICON = ICON_FACTORY.loadIcon(BasicPreviewPanel.class, "/com/agfa/pacs/listtext/lta/print/plaf/basic/icons/PreviousSingleArrow.svg");
    private static final PIcon FIRST_PAGE_ICON = ICON_FACTORY.loadIcon(BasicPreviewPanel.class, "/com/agfa/pacs/listtext/lta/print/plaf/basic/icons/PreviousDoubleArrow.svg");
    private static final PIcon LAST_PAGE_ICON = ICON_FACTORY.loadIcon(BasicPreviewPanel.class, "/com/agfa/pacs/listtext/lta/print/plaf/basic/icons/NextDoubleArrow.svg");
    private static final PIcon DELETE_ALL_PAGES_ICON = ICON_FACTORY.loadIcon(BasicPreviewPanel.class, "/com/agfa/pacs/listtext/lta/print/plaf/basic/icons/DeleteAllPages.svg");
    private static final PIcon DELETE_PAGE_ICON = ICON_FACTORY.loadIcon(BasicPreviewPanel.class, "/com/agfa/pacs/listtext/lta/print/plaf/basic/icons/DeletePage.svg");
    private static final PIcon ADD_PAGE_ICON = ICON_FACTORY.loadIcon(BasicPreviewPanel.class, "/com/agfa/pacs/listtext/lta/print/plaf/basic/icons/AddPage.svg");
    protected PrintManager manager = null;
    private JLabel pageInfo = null;
    private static ALogger log = ALogger.getLogger(BasicPreviewPanel.class);
    private JPanel previewMain;
    private int actualPage;
    private JLabel previewLbl;
    private JPanel preview;
    private JPanel noPreview;
    private JXBusyLabel previewLoading;
    private JLabel noPreviewLbl;
    private JButton firstBtn;
    private JButton addBtn;
    private JButton previousBtn;
    private JButton nextBtn;
    private JButton deleteBtn;
    private JButton deleteAllBtn;
    private JButton lastBtn;
    private DragnDropHandler handler;
    private IPrintContext previewContext = null;

    public BasicPreviewPanel(PrintManager printManager) {
        this.manager = printManager;
        this.initUI();
        printManager.setPreviewManager(this);
    }

    public synchronized void uninstall() {
        this.manager = null;
        this.noPreview.removeAll();
        this.preview.removeAll();
        this.previewMain.removeAll();
        this.previewContext = null;
        this.removeAll();
    }

    private void initUI() {
        this.createComponents();
        this.installLayout();
    }

    private void createComponents() {
        this.pageInfo = new JLabel("");
        this.pageInfo.setHorizontalTextPosition(0);
        this.pageInfo.setFont(this.pageInfo.getFont().deriveFont(1));
        Dimension dimension = GUI.getScaledDimension((Dimension)new Dimension(50, 36));
        this.firstBtn = SwingUtilities2.createButton((Action)new FirstPage());
        this.firstBtn.setPreferredSize(dimension);
        this.previousBtn = SwingUtilities2.createButton((Action)new PreviousPage());
        this.previousBtn.setPreferredSize(dimension);
        this.nextBtn = SwingUtilities2.createButton((Action)new NextPage());
        this.nextBtn.setPreferredSize(dimension);
        this.lastBtn = SwingUtilities2.createButton((Action)new LastPage());
        this.lastBtn.setPreferredSize(dimension);
        this.deleteBtn = SwingUtilities2.createButton((Action)new DeletePage());
        this.deleteBtn.setPreferredSize(dimension);
        this.deleteAllBtn = SwingUtilities2.createButton((Action)new DeleteAllPages());
        this.deleteAllBtn.setPreferredSize(dimension);
        this.addBtn = SwingUtilities2.createButton((Action)new AddPage());
        this.addBtn.setPreferredSize(dimension);
        this.previewMain = new JPanel(new FlowLayout(1));
        this.previewLbl = new JLabel("");
        Border border = BorderFactory.createLineBorder(new Color(70, 70, 70), 10);
        this.previewLbl.setBorder(border);
        this.handler = new DragnDropHandler(this.previewLbl, this.manager, this);
        this.preview = new JPanel(new FlowLayout(1));
        this.preview.add(this.previewLbl);
        this.preview.setVisible(false);
        this.previewMain.add(this.preview);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.noPreview = new JPanel(gridBagLayout);
        this.previewLoading = new JXBusyLabel(GUI.getScaledDimension((int)32, (int)32));
        this.noPreviewLbl = new JLabel(Messages.getString("BasicPreviewPanel.CreatingPreview"));
        gridBagLayout.addLayoutComponent(this.noPreviewLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(190, 5, 5, 5), 0, 0));
        gridBagLayout.addLayoutComponent((Component)this.previewLoading, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.noPreview.add((Component)this.previewLoading);
        this.noPreview.add(this.noPreviewLbl);
        this.noPreview.setVisible(false);
        this.previewMain.add(this.noPreview);
    }

    private void installLayout() {
        this.setLayout(new BorderLayout(5, 5));
        super.add((Component)this.previewMain, "Center");
        this.resetPreview();
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.firstBtn);
        jPanel.add(this.previousBtn);
        jPanel.add(this.pageInfo);
        jPanel.add(this.nextBtn);
        jPanel.add(this.lastBtn);
        jPanel.add(this.deleteBtn);
        jPanel.add(this.deleteAllBtn);
        jPanel.add(this.addBtn);
        super.add((Component)jPanel, "South");
    }

    private int getPageCount() {
        return this.manager.getSelectedFormat().getPageCount();
    }

    @Override
    public synchronized void drawPreview() {
        this.resetPreview();
        this.previewLoading.setBusy(true);
        log.debug("Creating new preview");
        if (this.manager.getSelectedFormat().getPageCount() == 0) {
            this.manager.getSelectedFormat().createEmptyPage();
        }
        if (this.actualPage >= this.manager.getSelectedFormat().getPageCount()) {
            this.actualPage = this.manager.getSelectedFormat().getPageCount() - 1;
        }
        this.previewContext = this.manager.getSelectedPrinter().createPagePreview(this.manager.getSelectedFormat(), this.manager.getGeneralSetting(), this.actualPage, this);
    }

    @Override
    public synchronized void resetPreview() {
        if (this.previewContext != null) {
            this.previewContext.cancel();
            this.previewContext = null;
        }
        this.noPreview.setVisible(true);
        this.preview.setVisible(false);
        this.previewMain.revalidate();
        this.previewMain.repaint();
        this.previewLoading.setBusy(false);
    }

    private void updatePage() {
        this.drawPreview();
    }

    @Override
    public void sendPreview(int n, BufferedImage bufferedImage) {
        log.debug("Preview for page:" + n + " arrived");
        this.previewLoading.setBusy(false);
        this.preview.setVisible(true);
        this.noPreview.setVisible(false);
        this.previewLbl.setIcon(null);
        if (bufferedImage != null) {
            Image image = bufferedImage;
            if (GUI.getScaleFactor() > 1.0) {
                image = bufferedImage.getScaledInstance(GUI.getScaledInt((int)bufferedImage.getWidth()), GUI.getScaledInt((int)bufferedImage.getHeight()), 4);
            }
            this.previewLbl.setIcon(new ImageIcon(image));
        }
        if (this.getPageCount() == 0) {
            this.pageInfo.setText("0");
        } else {
            this.pageInfo.setText(String.valueOf(this.actualPage + 1) + "/" + this.getPageCount());
        }
        this.previewMain.revalidate();
        this.previewMain.repaint();
    }

    @Override
    public int getActualPage() {
        return this.actualPage;
    }

    @Override
    public void resetPageCount() {
        this.actualPage = 0;
    }

    public synchronized void printFinished(IPrintContext iPrintContext, IPrintContext.Status status) {
        if (this.previewContext != null) {
            this.sendPreview(this.actualPage, null);
        }
    }

    public synchronized void printProgressed(IPrintContext iPrintContext, IPrintContext.Status status, MapperFilmBox mapperFilmBox) {
        this.previewContext = null;
        BufferedImage bufferedImage = ((PreviewPrintContext)iPrintContext).getPreviewImage(mapperFilmBox);
        this.sendPreview(this.actualPage, bufferedImage);
        log.info("Preview finished");
    }

    @Override
    public boolean isPreviewComponent(Object object) {
        return object == this.previewLbl;
    }

    private class AddPage
    extends AbstractAction {
        private static final long serialVersionUID = 5237407841788782784L;

        public AddPage() {
            super.putValue("ShortDescription", Messages.getString("BasicPreviewPanel.NewPageTT"));
            super.putValue("SmallIcon", ADD_PAGE_ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicPreviewPanel.this.manager.getSelectedFormat().createEmptyPage();
            BasicPreviewPanel.this.actualPage = BasicPreviewPanel.this.manager.getSelectedFormat().getPageCount() - 1;
            BasicPreviewPanel.this.updatePage();
        }
    }

    private class DeleteAllPages
    extends AbstractAction {
        private static final long serialVersionUID = -6018799842555593341L;

        public DeleteAllPages() {
            super.putValue("ShortDescription", Messages.getString("BasicPreviewPanel.DeleteAllTT"));
            super.putValue("SmallIcon", DELETE_ALL_PAGES_ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = BasicPreviewPanel.this.manager.getSelectedFormat().getPageCount() - 1;
            while (n >= 0) {
                List<IImageBoxInfo> list = BasicPreviewPanel.this.manager.getSelectedFormat().getDataOnPage(n);
                ArrayList<IImageBoxInfo> arrayList = new ArrayList<IImageBoxInfo>();
                for (IImageBoxInfo iImageBoxInfo : list) {
                    if (iImageBoxInfo == null) continue;
                    arrayList.add(iImageBoxInfo);
                }
                BasicPreviewPanel.this.manager.deselectData(arrayList);
                BasicPreviewPanel.this.manager.getSelectedFormat().deletePage(n);
                --n;
            }
            BasicPreviewPanel.this.manager.getSelectedFormat().createEmptyPage();
            BasicPreviewPanel.this.actualPage = 0;
            BasicPreviewPanel.this.updatePage();
        }
    }

    private class DeletePage
    extends AbstractAction {
        private static final long serialVersionUID = -6018799842555593341L;

        public DeletePage() {
            super.putValue("ShortDescription", Messages.getString("BasicPreviewPanel.DeletePageTT"));
            super.putValue("SmallIcon", DELETE_PAGE_ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<IImageBoxInfo> list = BasicPreviewPanel.this.manager.getSelectedFormat().getDataOnPage(BasicPreviewPanel.this.actualPage);
            ArrayList<IImageBoxInfo> arrayList = new ArrayList<IImageBoxInfo>();
            for (IImageBoxInfo iImageBoxInfo : list) {
                if (iImageBoxInfo == null) continue;
                arrayList.add(iImageBoxInfo);
            }
            BasicPreviewPanel.this.manager.deselectData(arrayList);
            BasicPreviewPanel.this.manager.getSelectedFormat().deletePage(BasicPreviewPanel.this.actualPage);
            if (BasicPreviewPanel.this.actualPage >= BasicPreviewPanel.this.manager.getSelectedFormat().getPageCount()) {
                BasicPreviewPanel.this.actualPage = BasicPreviewPanel.this.manager.getSelectedFormat().getPageCount() - 1;
            }
            if (BasicPreviewPanel.this.actualPage < 0) {
                BasicPreviewPanel.this.actualPage = 0;
            }
            BasicPreviewPanel.this.updatePage();
        }
    }

    private class FirstPage
    extends AbstractAction {
        private static final long serialVersionUID = 0L;

        public FirstPage() {
            super.putValue("ShortDescription", Messages.getString("BasicPreviewPanel.FirstPageTT"));
            super.putValue("SmallIcon", FIRST_PAGE_ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicPreviewPanel.this.actualPage = 0;
            BasicPreviewPanel.this.updatePage();
        }
    }

    private class LastPage
    extends AbstractAction {
        private static final long serialVersionUID = 0L;

        public LastPage() {
            super.putValue("ShortDescription", Messages.getString("BasicPreviewPanel.LastPageTT"));
            super.putValue("SmallIcon", LAST_PAGE_ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasicPreviewPanel.this.actualPage = BasicPreviewPanel.this.getPageCount() - 1;
            BasicPreviewPanel.this.updatePage();
        }
    }

    private class NextPage
    extends AbstractAction {
        private static final long serialVersionUID = 0L;

        public NextPage() {
            super.putValue("ShortDescription", Messages.getString("BasicPreviewPanel.NextPageTT"));
            super.putValue("SmallIcon", NEXT_PAGE_ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicPreviewPanel.this.actualPage < BasicPreviewPanel.this.getPageCount() - 1) {
                BasicPreviewPanel basicPreviewPanel = BasicPreviewPanel.this;
                basicPreviewPanel.actualPage = basicPreviewPanel.actualPage + 1;
                BasicPreviewPanel.this.updatePage();
            }
        }
    }

    private class PreviousPage
    extends AbstractAction {
        private static final long serialVersionUID = 0L;

        public PreviousPage() {
            super.putValue("ShortDescription", Messages.getString("BasicPreviewPanel.PreviousPageTT"));
            super.putValue("SmallIcon", PREVIOUS_PAGE_ICON);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicPreviewPanel.this.actualPage > 0) {
                BasicPreviewPanel basicPreviewPanel = BasicPreviewPanel.this;
                basicPreviewPanel.actualPage = basicPreviewPanel.actualPage - 1;
                BasicPreviewPanel.this.updatePage();
            }
        }
    }
}

