/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print.plaf.basic;

import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.listtext.dicom.exporter.util.ExportDicomObjectComparator;
import com.agfa.pacs.listtext.lta.print.IImageBoxInfo;
import com.agfa.pacs.logging.ALogger;
import java.util.Comparator;

public class DataSorter
implements Comparator<IImageBoxInfo> {
    private static final ALogger LOGGER = ALogger.getLogger(DataSorter.class);
    private Comparator<IObjectInfo> sorter = ExportDicomObjectComparator.getObjectInfoComparator();

    @Override
    public int compare(IImageBoxInfo iImageBoxInfo, IImageBoxInfo iImageBoxInfo2) {
        int n = this.sorter.compare(iImageBoxInfo.getObjectInfo(), iImageBoxInfo2.getObjectInfo());
        if (n == 0) {
            n = this.getFrameNumber(iImageBoxInfo) - this.getFrameNumber(iImageBoxInfo2);
        }
        return n;
    }

    private int getFrameNumber(IImageBoxInfo iImageBoxInfo) {
        int n = iImageBoxInfo.getFrameNumber();
        if (n == 0) {
            try {
                String string = iImageBoxInfo.getObjectInfo().getKey();
                int n2 = string.lastIndexOf(95);
                if (n2 >= 0) {
                    n = Integer.parseInt(string.substring(n2 + 1));
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Extracting frame number failed.", (Throwable)exception);
            }
        }
        return n;
    }
}

