/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print.raster;

import com.agfa.pacs.listtext.lta.print.IImageBoxInfo;
import java.util.ArrayList;
import java.util.List;

public class RasterPage {
    private List<IImageBoxInfo> boxData = null;
    private int x;
    private int y;

    public RasterPage(int n, int n2, List<IImageBoxInfo> list) {
        this.x = n;
        this.y = n2;
        this.boxData = list;
    }

    public RasterPage(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.boxData = new ArrayList<IImageBoxInfo>(n * n2);
    }

    public IImageBoxInfo getObj(int n, int n2) {
        return this.boxData.get(n + n2 * this.x);
    }

    public void setObj(int n, int n2, IImageBoxInfo iImageBoxInfo) {
        this.boxData.set(n + n2 * this.x, iImageBoxInfo);
    }

    public void setObj(int n, IImageBoxInfo iImageBoxInfo) {
        this.boxData.set(n, iImageBoxInfo);
    }

    public void setObjAt(float f, float f2, IImageBoxInfo iImageBoxInfo) {
        int n = (int)Math.floor(f * (float)this.x);
        int n2 = (int)Math.floor(f2 * (float)this.y);
        this.setObj(n, n2, iImageBoxInfo);
    }

    public int getFreePosition() {
        int n = 0;
        while (n < this.x * this.y) {
            if (this.boxData.get(n) == null) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public IImageBoxInfo getObjAt(float f, float f2) {
        int n = (int)Math.ceil(f * (float)this.x);
        int n2 = (int)Math.ceil(f2 * (float)this.y);
        return this.getObj(n - 1, n2 - 1);
    }

    public List<IImageBoxInfo> getBoxData() {
        return this.boxData;
    }
}

