/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.print.remote;

import com.agfa.pacs.data.shared.dicom.YesNo;
import com.agfa.pacs.listtext.dicomobject.module.print.Media;
import com.agfa.pacs.listtext.dicomobject.module.print.PrinterConfigurationItem;
import com.agfa.pacs.listtext.dicomobject.type.print.Density;
import com.agfa.pacs.listtext.dicomobject.type.print.MediumType;
import com.agfa.pacs.listtext.lta.print.IDicomConfigProvider;
import com.agfa.pacs.listtext.lta.print.remote.DicomPrinterWrapper;

public class DicomConfigProvider
implements IDicomConfigProvider {
    private PrinterConfigurationItem config;
    private DicomPrinterWrapper printer;
    private Density borderDensity;
    private Density emptyDensity;

    public DicomConfigProvider(PrinterConfigurationItem printerConfigurationItem, DicomPrinterWrapper dicomPrinterWrapper) {
        this.config = printerConfigurationItem;
        this.printer = dicomPrinterWrapper;
        Media media = dicomPrinterWrapper.getSelectedMedium();
        this.borderDensity = dicomPrinterWrapper.getBorderDensity();
        this.emptyDensity = dicomPrinterWrapper.getEmptyDensity() == null ? (media.getMediumType().equals((Object)MediumType.Paper) ? Density.WHITE : Density.BLACK) : dicomPrinterWrapper.getBorderDensity();
    }

    @Override
    public PrinterConfigurationItem getConfig() {
        return this.config;
    }

    @Override
    public Media getSelectedMedium() {
        return this.printer.getSelectedMedium();
    }

    @Override
    public Density getBorderDensity() {
        return this.borderDensity;
    }

    @Override
    public YesNo getTrim() {
        Boolean bl = this.printer.getTrim();
        if (bl == null) {
            return null;
        }
        return bl != false ? YesNo.Yes : YesNo.No;
    }

    @Override
    public Density getEmptyDensity() {
        return this.emptyDensity;
    }

    @Override
    public boolean isAgfaPrinter() {
        return this.printer.isAgfaPrinter();
    }
}

