/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.lw.dicomdir;

import com.agfa.pacs.base.util.OSUtils;
import com.agfa.pacs.data.dicom.comm.DicomCFindConst;
import com.agfa.pacs.data.shared.TagConstants;
import com.agfa.pacs.data.shared.dicom.AgfaDicomInputStream;
import com.agfa.pacs.data.shared.dicom.DicomDirRecordType;
import com.agfa.pacs.data.shared.dicom.DicomDirRecordUtils;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.filter.IFilter;
import com.agfa.pacs.data.shared.icon.impl.ImagePixelIconProvider;
import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import com.agfa.pacs.data.shared.instanceinfo.impl.URIInstanceInfo;
import com.agfa.pacs.data.shared.instanceinfo.impl.ZIPURIInstanceInfo;
import com.agfa.pacs.data.shared.lw.DataInfoFactoryProvider;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoFactory;
import com.agfa.pacs.data.shared.lw.IDataInfoRetriever;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.node.AbstractDataInfoNode;
import com.agfa.pacs.data.shared.node.IDataNodeErrorCounter;
import com.agfa.pacs.data.shared.primitives.IntHashSet;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.TempDirectoryProvider;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.media.DicomDirReader;
import org.dcm4che3.util.SafeClose;

public class DicomDirDataInfoSource {
    private IRootInfo root;
    private static ALogger log = ALogger.getLogger(DicomDirDataInfoSource.class);
    private IDataInfoFactory diFact;
    private boolean defectData;
    private boolean readFiles;
    private DicomDirObjectRetriever retriever;
    private URI fileURI;
    private URL url;
    private String parentDir;
    private ImagePixelIconProvider iconProvider;
    private IDataNodeErrorCounter errorCounter;
    private static final String[] ENHANCED_SOP_CLASSES = new String[]{"1.2.840.10008.5.1.4.1.1.2.1", "1.2.840.10008.5.1.4.1.1.4.1"};
    private static final String[] multiframeSOPClasses = new String[]{"1.2.840.10008.5.1.4.1.1.20", "1.2.840.10008.5.1.4.1.1.128", "1.2.840.10008.5.1.4.1.1.6.1", "1.2.840.10008.5.1.4.1.1.3.1", "1.2.840.10008.5.1.4.1.1.7.2", "1.2.840.10008.5.1.4.1.1.7.4", "1.2.840.10008.5.1.4.1.1.12.1", "1.2.840.10008.5.1.4.1.1.12.2", "1.2.840.10008.5.1.4.1.1.481.1", "1.2.840.10008.5.1.4.1.1.77.1.1.1", "1.2.840.10008.5.1.4.1.1.77.1.2.1", "1.2.840.10008.5.1.4.1.1.77.1.4.1", "1.2.840.10008.5.1.4.1.1.2.1", "1.2.840.10008.5.1.4.1.1.4.1", "1.2.840.10008.5.1.4.1.1.13.1.3", "1.2.840.10008.5.1.4.1.1.130", "1.2.840.10008.5.1.4.1.1.12.1.1"};
    private static final DicomDirRecordType[] objectTypes = new DicomDirRecordType[]{DicomDirRecordType.Image, DicomDirRecordType.Curve, DicomDirRecordType.Overlay, DicomDirRecordType.KeyObject, DicomDirRecordType.ModalityLUT, DicomDirRecordType.VOILut, DicomDirRecordType.StoredPrint, DicomDirRecordType.RTDose, DicomDirRecordType.RTPlan, DicomDirRecordType.RTStructureSet, DicomDirRecordType.RTTreatRecord, DicomDirRecordType.Presentation, DicomDirRecordType.Waveform, DicomDirRecordType.SRDocument, DicomDirRecordType.RAWData, DicomDirRecordType.EncapsulatedDocument, DicomDirRecordType.Private};

    /*
     * Unable to fully structure code
     */
    @SuppressWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Old code that re-throws the exception anyhow.")
    public DicomDirDataInfoSource(String var1_1, ImagePixelIconProvider var2_2, IDataNodeErrorCounter var3_3) throws Exception {
        block30: {
            super();
            this.diFact = DataInfoFactoryProvider.getInstance();
            this.defectData = false;
            this.readFiles = true;
            this.retriever = new DicomDirObjectRetriever();
            var4_4 = null;
            this.root = this.diFact.createRootInfo("ROOT");
            this.iconProvider = var2_2;
            this.errorCounter = var3_3;
            this.errorCounter.resetErrorCounter();
            this.fileURI = null;
            var5_5 = null;
            this.url = new URL(var1_1);
            this.parentDir = null;
            if (this.url.getRef() != null) {
                var6_7 = null;
                var7_9 = null;
                try {
                    var8_11 = new ZipInputStream(new BufferedInputStream(this.url.openStream()));
                    try {
                        while ((var9_12 = var8_11.getNextEntry()) != null) {
                            if (!var9_12.getName().equals(this.url.getRef())) continue;
                            var4_4 = new DicomDirReader(this.cacheDicomDir((InputStream)var8_11));
                            break;
                        }
                        ** if (var8_11 == null) goto lbl-1000
                    }
                    catch (Throwable var6_8) {
                        if (var8_11 != null) {
                            var8_11.close();
                        }
                        throw var6_8;
                    }
lbl-1000:
                    // 1 sources

                    {
                        var8_11.close();
                    }
lbl-1000:
                    // 1 sources

                    {
                        ** break block29
                    }
                }
                finally {
                    if (var4_4 != null) break block30;
                }
            }
            if ("file".equals(this.url.getProtocol())) {
                if (this.url.toString().length() == 18) {
                    DicomDirDataInfoSource.log.debug("USING CACHED DICOM DIR");
                    var6_7 = new File(this.url.getPath());
                    this.parentDir = var6_7.getParent();
                    var5_5 = this.cacheDicomDir();
                    var4_4 = new DicomDirReader(var5_5);
                    this.fileURI = var6_7.toURI();
                }
                var6_7 = new File(this.url.getPath());
                this.parentDir = var6_7.getParent();
                var4_4 = new DicomDirReader((File)var6_7);
                this.fileURI = var6_7.toURI();
            }
            var4_4 = new DicomDirReader(this.cacheDicomDir());
            this.fileURI = this.url.toURI();
            return this.fileURI;
lbl-1000:
            // 1 sources

            {
            }
            SafeClose.close((Closeable)var4_4);
            return;
        }
        try {
            try {
                var6_7 = var4_4.findFirstRootDirectoryRecordInUse(false);
                var7_9 = new HashMap<Object, ZipEntry>();
                while (var6_7 != null) {
                    if (DicomDirRecordUtils.isType((DicomDirRecordType)DicomDirRecordType.Patient, (Attributes)var6_7)) {
                        var8_11 = DataInfoUtilities.compilePatientKey((Attributes)var6_7);
                        if (var7_9.containsKey(var8_11)) {
                            var9_12 = (IPatientInfo)var7_9.get(var8_11);
                        } else {
                            var9_12 = this.diFact.createPatientInfo(this.root, (String)var8_11);
                            var7_9.put(var8_11, var9_12);
                            this.root.addChild((IDataInfo)var9_12);
                            var9_12.getAttributes().addAll((Attributes)var6_7);
                        }
                        var10_13 = var4_4.findLowerDirectoryRecordInUse((Attributes)var6_7, false);
                        while (var10_13 != null) {
                            if (DicomDirRecordUtils.isType((DicomDirRecordType)DicomDirRecordType.Study, (Attributes)var10_13)) {
                                var11_14 = var10_13.getString(0x20000D);
                                if (var11_14 == null) {
                                    var11_14 = this.detectStudyInstanceUID(var10_13);
                                    this.defectData = true;
                                    var10_13.setString(0x20000D, VR.UI, var11_14);
                                }
                                if (var11_14 == null) {
                                    throw new DicomDirRecordUtils.MissingStudyInstanceUIDException("DicomDIR contains not a valid Study Instance UID");
                                }
                                var12_15 = this.diFact.createStudyInfo((IPatientInfo)var9_12, var11_14);
                                var12_15.getAttributes().addAll(var10_13);
                                var9_12.addChild((IDataInfo)var12_15);
                                var13_16 = var4_4.findLowerDirectoryRecordInUse(var10_13, false);
                                while (var13_16 != null) {
                                    if (DicomDirRecordUtils.isType((DicomDirRecordType)DicomDirRecordType.Series, (Attributes)var13_16)) {
                                        var14_17 = var13_16.getString(0x20000E);
                                        var15_18 = this.diFact.createSeriesInfo(var12_15, var14_17);
                                        var15_18.getAttributes().addAll(var13_16);
                                        var12_15.addChild((IDataInfo)var15_18);
                                        var16_19 = 0;
                                        var17_20 = var4_4.findLowerDirectoryRecordInUse(var13_16, false);
                                        while (var17_20 != null) {
                                            if (DicomDirRecordUtils.isType((DicomDirRecordType[])DicomDirDataInfoSource.objectTypes, (Attributes)var17_20)) {
                                                this.retriever.addObject(var14_17, var17_20);
                                                ++var16_19;
                                            }
                                            var17_20 = var4_4.findNextDirectoryRecordInUse(var17_20, false);
                                        }
                                        var15_18.getAttributes().setInt(2101769, VR.IS, new int[]{var16_19});
                                    }
                                    var13_16 = var4_4.findNextDirectoryRecordInUse(var13_16, false);
                                }
                            }
                            var10_13 = var4_4.findNextDirectoryRecordInUse(var10_13, false);
                        }
                    }
                    var6_7 = var4_4.findNextDirectoryRecordInUse((Attributes)var6_7, false);
                }
                if (var5_5 != null) {
                    var5_5.delete();
                }
                AbstractDataInfoNode.updateCountFields((IDataInfo)this.root);
            }
            catch (Exception var5_6) {
                var6_7 = Collections.emptyList();
                this.root.addChildren(var6_7);
                DicomDirDataInfoSource.log.error("DICOMDIR Read Exception ", (Throwable)var5_6);
                throw var5_6;
            }
        }
        catch (Throwable var18_21) {
            SafeClose.close(var4_4);
            throw var18_21;
        }
        SafeClose.close((Closeable)var4_4);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Old code that returns null whenever any kind of exception occurs.")
    private Integer readFrameNumber(String string) {
        string = string.substring(OSUtils.isWindows() ? 6 : 5).replace("%20", " ");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(FileSystems.getDefault().getPath(string, new String[0]), new OpenOption[0]));
                try {
                    Integer n;
                    block19: {
                        AgfaDicomInputStream agfaDicomInputStream = new AgfaDicomInputStream((InputStream)bufferedInputStream);
                        try {
                            Attributes attributes = agfaDicomInputStream.readDataset(-1, 2145386512);
                            if (attributes.containsValue(0x280008)) {
                                n = attributes.getInt(0x280008, 0);
                                return n;
                            }
                        }
                        finally {
                            if (agfaDicomInputStream == null) break block19;
                            agfaDicomInputStream.close();
                        }
                    }
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                    return n;
                    {
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (bufferedInputStream == null) throw throwable;
                    bufferedInputStream.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Exception exception) {
            log.warn("Could not read DICOM File", (Throwable)exception);
            return null;
        }
    }

    private int[] getObjectTags2Delete(Attributes attributes) {
        int n;
        IntHashSet intHashSet = new IntHashSet(128);
        int[] nArray = attributes.tags();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            n = nArray[n3];
            intHashSet.add(n);
            ++n3;
        }
        n = 0;
        while (n < DicomCFindConst.IMAGE_TAGS.length) {
            intHashSet.remove(DicomCFindConst.IMAGE_TAGS[n]);
            ++n;
        }
        intHashSet.remove(0x100010);
        intHashSet.remove(0x100020);
        intHashSet.remove(0x100021);
        intHashSet.remove(0x20000D);
        intHashSet.remove(0x20000E);
        int[] nArray2 = intHashSet.toArray();
        return nArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Old code that returns null whenever any kind of exception occurs.")
    private Attributes readDicomMetadata(String string, boolean bl) {
        string = string.substring(6).replace("%20", " ");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(FileSystems.getDefault().getPath(string, new String[0]), new OpenOption[0]), 32768);
                try {
                    Attributes attributes;
                    block24: {
                        DicomInputStream dicomInputStream;
                        block23: {
                            dicomInputStream = new DicomInputStream((InputStream)bufferedInputStream);
                            Attributes attributes2 = dicomInputStream.readDataset(-1, 2145386512);
                            dicomInputStream.close();
                            if (UIDUtilities.getBaseType((String)attributes2.getString(524310, null)) == UIDType.Image) {
                                Attributes attributes3;
                                int[] nArray = this.getObjectTags2Delete(attributes2);
                                if (bl) {
                                    attributes3 = new Attributes(attributes2.size() - nArray.length);
                                    attributes3.addNotSelected(attributes2, nArray);
                                } else {
                                    attributes3 = new Attributes(nArray.length);
                                    attributes3.addSelected(attributes2, nArray);
                                }
                                attributes = attributes3;
                                return attributes;
                            }
                            if (!bl) break block23;
                            Attributes attributes4 = attributes2;
                            return attributes4;
                        }
                        finally {
                            if (dicomInputStream == null) break block24;
                            dicomInputStream.close();
                        }
                    }
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                    return attributes;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (bufferedInputStream == null) throw throwable;
                    bufferedInputStream.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (Exception exception) {
            log.warn("Error on reading dicom details:" + string, (Throwable)exception);
            this.errorCounter.incrementErrorCounter();
            return null;
        }
    }

    private boolean fileExists(Attributes attributes) {
        Object object;
        String[] stringArray = attributes.getStrings(267520);
        StringBuilder stringBuilder = new StringBuilder(this.parentDir);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray2[n2];
            stringBuilder.append(File.separatorChar).append((String)object);
            ++n2;
        }
        object = new File(stringBuilder.toString());
        return ((File)object).exists();
    }

    private String detectStudyInstanceUID(Attributes attributes) {
        Object object;
        log.warn("Non-dicom conform CD, missing Study Instance UID, continuing by reading referenced objects");
        DicomInputStream dicomInputStream = attributes.getStrings(267520);
        if (dicomInputStream == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(this.parentDir);
        DicomInputStream dicomInputStream2 = dicomInputStream;
        int n = ((String[])dicomInputStream2).length;
        int n2 = 0;
        while (n2 < n) {
            object = dicomInputStream2[n2];
            stringBuffer.append(File.separatorChar).append((String)object);
            ++n2;
        }
        object = new File(stringBuffer.toString());
        if (!((File)object).exists()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var6_6 = null;
            try {
                dicomInputStream2 = new DicomInputStream((File)object);
                try {
                    Attributes attributes2 = dicomInputStream2.readDataset(-1, -1);
                    return attributes2.getString(0x20000D, null);
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (dicomInputStream2 != null) {
                        dicomInputStream2.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            log.error("Could not open associated Study Object", (Throwable)iOException);
            return null;
        }
    }

    private File cacheDicomDir() throws Exception {
        try (InputStream inputStream = null;){
            inputStream = this.url.openStream();
            File file = this.cacheDicomDir(inputStream);
            return file;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File cacheDicomDir(InputStream inputStream) throws Exception {
        File file = TempDirectoryProvider.createTemporaryFile((String)"agfa", (String)"dicomdir");
        file.deleteOnExit();
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            try {
                try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
                    int n;
                    byte[] byArray = new byte[0x100000];
                    while ((n = inputStream.read(byArray, 0, 0x100000)) >= 0) {
                        bufferedOutputStream.write(byArray, 0, n);
                    }
                }
                if (outputStream == null) return file;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (outputStream == null) throw throwable;
                outputStream.close();
                throw throwable;
            }
            outputStream.close();
            return file;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public IRootInfo getDataInfo(IFilter iFilter) {
        return this.root;
    }

    private void setLocation(IObjectInfo iObjectInfo, String string) {
        try {
            iObjectInfo.setInstanceInfo((IInstanceInfo)new URIInstanceInfo(new URI(string)));
        }
        catch (Exception exception) {
            log.error("URI Error", (Throwable)exception);
        }
    }

    private void setZIPLocation(IDataInfo iDataInfo, URI uRI, String string) {
        try {
            if (iDataInfo instanceof IObjectInfo) {
                ((IObjectInfo)iDataInfo).setInstanceInfo((IInstanceInfo)new ZIPURIInstanceInfo(uRI, string));
            }
        }
        catch (Exception exception) {
            log.error("URI Error", (Throwable)exception);
        }
    }

    private boolean canBeMultiFrame(String string) {
        String[] stringArray = multiframeSOPClasses;
        int n = multiframeSOPClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (string2.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isEnhanced(String string) {
        String[] stringArray = ENHANCED_SOP_CLASSES;
        int n = ENHANCED_SOP_CLASSES.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (string2.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String concat(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(String.valueOf(string) + stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean isReadingDicomFiles() {
        return this.readFiles;
    }

    public void setReadDicomFiles(boolean bl) {
        this.readFiles = bl;
    }

    public URI getURI() {
        return null;
    }

    IDataInfoRetriever getRetriever() {
        return this.retriever;
    }

    private class DicomDirObjectRetriever
    implements IDataInfoRetriever {
        private Map<String, List<Attributes>> objectLevel = new HashMap<String, List<Attributes>>();
        private Set<String> initialisedSeries = new HashSet<String>();

        private DicomDirObjectRetriever() {
        }

        public void addObject(String string, Attributes attributes) {
            List<Attributes> list = this.objectLevel.get(string);
            if (list == null) {
                list = new ArrayList<Attributes>(64);
                this.objectLevel.put(string, list);
            }
            list.add(attributes);
        }

        private synchronized IObjectInfo createObjectInfo(Attributes attributes, ISeriesInfo iSeriesInfo) throws URISyntaxException {
            String string = attributes.getString(267537);
            if (!DicomDirDataInfoSource.this.defectData || DicomDirDataInfoSource.this.fileExists(attributes)) {
                String string2 = attributes.getString(267536);
                IObjectInfo iObjectInfo = DicomDirDataInfoSource.this.diFact.createObjectInfo(iSeriesInfo, string);
                iObjectInfo.getAttributes().setString(524312, VR.UI, string);
                iObjectInfo.getAttributes().setString(524310, VR.UI, string2);
                iObjectInfo.getAttributes().addAll(attributes);
                iSeriesInfo.addChild((IDataInfo)iObjectInfo);
                Attributes attributes2 = attributes.getNestedDataset(0x880200);
                if (attributes2 != null) {
                    DicomDirDataInfoSource.this.iconProvider.putIcon(iObjectInfo, attributes2);
                }
                if (DicomDirDataInfoSource.this.url.getRef() != null) {
                    URI uRI = new URI(DicomDirDataInfoSource.this.url.getProtocol(), DicomDirDataInfoSource.this.url.getUserInfo(), DicomDirDataInfoSource.this.url.getHost(), DicomDirDataInfoSource.this.url.getPort(), DicomDirDataInfoSource.this.url.getPath(), DicomDirDataInfoSource.this.url.getQuery(), null);
                    DicomDirDataInfoSource.this.setZIPLocation((IDataInfo)iObjectInfo, uRI, DicomDirDataInfoSource.concat(attributes.getStrings(267520), "/"));
                } else {
                    Integer n;
                    String string3 = DicomDirDataInfoSource.this.fileURI.toString();
                    int n2 = string3.lastIndexOf(47);
                    string3 = string3.substring(0, n2);
                    string3 = String.valueOf(string3) + "/" + DicomDirDataInfoSource.concat(attributes.getStrings(267520), "/");
                    if (DicomDirDataInfoSource.this.readFiles || DicomDirDataInfoSource.isEnhanced(string2)) {
                        Attributes attributes3 = DicomDirDataInfoSource.this.readDicomMetadata(string3, true);
                        if (attributes3 != null) {
                            iObjectInfo.getSeries().getStudy().getPatient().getAttributes().addSelected(attributes3, TagConstants.PATIENT_TAGS);
                            iObjectInfo.getSeries().getStudy().getAttributes().addSelected(attributes3, TagConstants.STUDY_MERGED_TAGS);
                            iObjectInfo.getSeries().getAttributes().addSelected(attributes3, TagConstants.SERIES_MERGED_TAGS);
                            iObjectInfo.getAttributes().addNotSelected(attributes3, TagConstants.SERIES_MERGED_TAGS);
                        }
                        if (!this.initialisedSeries.contains(iSeriesInfo.getKey())) {
                            attributes3 = DicomDirDataInfoSource.this.readDicomMetadata(string3, false);
                            if (attributes3 != null) {
                                iSeriesInfo.getAttributes().addAll(attributes3);
                            }
                            this.initialisedSeries.add(iSeriesInfo.getKey());
                        }
                    } else if (DicomDirDataInfoSource.this.canBeMultiFrame(string2) && (n = DicomDirDataInfoSource.this.readFrameNumber(string3)) != null) {
                        iObjectInfo.getAttributes().setInt(0x280008, VR.IS, new int[]{n});
                    }
                    DicomDirDataInfoSource.this.setLocation(iObjectInfo, string3);
                }
                return iObjectInfo;
            }
            return null;
        }

        public List<IDataInfo> getDataInfo(IDataInfo iDataInfo, Level level) {
            String string = iDataInfo.getKey();
            if (this.objectLevel.containsKey(string) && iDataInfo.getHierarchyLevel() == Level.Series) {
                ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>();
                try {
                    for (Attributes attributes : this.objectLevel.get(string)) {
                        arrayList.add((IDataInfo)this.createObjectInfo(attributes, (ISeriesInfo)iDataInfo));
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    log.error("Could not handle URI", (Throwable)uRISyntaxException);
                }
                return arrayList;
            }
            List list = DataInfoUtilities.getLevel((IDataInfo)DicomDirDataInfoSource.this.root, (Level)iDataInfo.getHierarchyLevel());
            for (IDataInfo iDataInfo2 : list) {
                if (!iDataInfo2.equalsKey(iDataInfo)) continue;
                return DataInfoUtilities.cloneData((List)iDataInfo2.children());
            }
            return Collections.emptyList();
        }
    }
}

