/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.tce;

import com.agfa.pacs.data.export.tce.Messages;
import com.agfa.pacs.data.export.tce.TeachingFileProperty;
import com.agfa.pacs.data.export.tce.keyword.IKeywordProvider;
import com.agfa.pacs.data.export.tce.property.TeachingFileConfigProperties;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.dcm4che3.net.Connection;

public interface ITeachingFileConfig {
    public static final String EXT_PT = "com.agfa.pacs.data.export.tce.TeachingFileConfig";

    public boolean isAutoQueryEnabled();

    public boolean isAutoQueryAgeEnabled();

    public TeachingFileAge getAutoQueryAge();

    public boolean isCurrentUserAuthor();

    public TeachingFileConfigProperties getProperties();

    public boolean isAuditingEnabled();

    public String getAuditHost();

    public int getAuditPort();

    public Connection.Protocol getAuditProtocol();

    public String getAuditApplicationName();

    public IKeywordProvider getKeywordProvider(TeachingFileProperty<? extends Object> var1);

    public boolean isKeywordProviderExclusive(TeachingFileProperty<? extends Object> var1);

    public List<String> getEthnicGroups();

    public Collection<String> getXMLKeywordProviderNames();

    public InputStream getXMLKeyProviderStream(String var1) throws Exception;

    public String[] getAvailableModalities();

    public String getLocalizedTagName(int var1);

    public static enum TeachingFileAge {
        Days7(5, -7),
        Days14(5, -14),
        Months1(2, -1),
        Months3(2, -3),
        Months6(2, -6),
        Years1(1, -1),
        Years5(1, -5),
        Years10(1, -10);

        private int calField;
        private int calAmount;

        private TeachingFileAge(int n2, int n3) {
            this.calField = n2;
            this.calAmount = n3;
        }

        public String toString() {
            return Messages.getString("TeachingFileAge." + this.name());
        }

        public Date toFromDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.add(this.calField, this.calAmount);
            return calendar.getTime();
        }
    }
}

