/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.tce;

import com.agfa.pacs.data.export.ImageObject;
import com.agfa.pacs.data.export.tce.TeachingFile;
import com.agfa.pacs.data.export.tce.TeachingFileAuditManager;
import com.agfa.pacs.data.shared.dicom.UIDMap;
import com.agfa.pacs.data.shared.export.IProcessingElement;
import com.agfa.pacs.data.shared.export.ProcessingException;
import com.agfa.pacs.data.shared.export.ProcessingProperty;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcm4che3.data.Attributes;

public class TeachingFileCreator
implements IProcessingElement {
    public static final String TEACHING_FILE = "TCE_FILE";
    public static final String FINISH_TASK = "TCE_FINISH_TASK";
    private AtomicInteger instanceCount;
    private TeachingFile<Attributes> tf;
    private Runnable finishTask = null;
    private IDataInfoSource auditSource;

    public void prepareProcessing(Properties properties, List<? extends Object> list) throws ProcessingException {
        UIDMap uIDMap = new UIDMap();
        properties.put("UID_MAP", uIDMap);
        uIDMap.addTransferSyntaxUID("1.2.840.10008.5.1.4.1.1.88.59", "1.2.840.10008.1.2.1");
        uIDMap.addTransferSyntaxUID("1.2.840.10008.5.1.4.1.1.88.11", "1.2.840.10008.1.2.1");
        this.instanceCount = new AtomicInteger(list.size());
        if (properties.containsKey(FINISH_TASK)) {
            this.finishTask = (Runnable)properties.get(FINISH_TASK);
        }
        if (!properties.containsKey(TEACHING_FILE)) {
            throw new ProcessingException("TCE File not provided");
        }
        this.tf = (TeachingFile)properties.get(TEACHING_FILE);
        this.auditSource = TeachingFileCreator.getExportAuditSource(properties, list);
    }

    private static IDataInfoSource getExportAuditSource(Properties properties, List<? extends Object> list) {
        Object object;
        Object object2 = properties.get("AUDIT_EXPORT_SOURCE");
        if (object2 == null && !list.isEmpty() && (object = list.get(0)) instanceof IDataInfo) {
            object2 = ((IDataInfo)object).getSource();
        }
        if (object2 instanceof IDataInfoSource) {
            return (IDataInfoSource)object2;
        }
        return null;
    }

    public void finishProcessing() throws ProcessingException {
        TeachingFileAuditManager.getInstance().logTFCreated(this.tf, this.auditSource);
        if (this.finishTask != null) {
            this.finishTask.run();
        }
    }

    public void cleanUp() {
        this.tf = null;
        this.finishTask = null;
        this.auditSource = null;
    }

    public Object process(Object object) throws ProcessingException {
        if (!(object instanceof Attributes)) {
            throw new ProcessingException("Wrong input element");
        }
        this.tf.addReferencedObject((Attributes)object);
        if (this.instanceCount.decrementAndGet() <= 0) {
            ArrayList<ImageObject> arrayList = new ArrayList<ImageObject>();
            Attributes attributes = this.tf.createSRTCEObject();
            arrayList.add(this.createPlainImageObject(attributes));
            for (Attributes attributes2 : this.tf.createManifestObjects(attributes)) {
                arrayList.add(this.createPlainImageObject(attributes2));
            }
            return arrayList.toArray();
        }
        return null;
    }

    private ImageObject createPlainImageObject(Attributes attributes) {
        ImageObject imageObject = new ImageObject();
        imageObject.setDatasetAndFinish(attributes);
        return imageObject;
    }

    public ProcessingProperty[] queryProperties() {
        ProcessingProperty[] processingPropertyArray = new ProcessingProperty[]{new ProcessingProperty(TEACHING_FILE, TeachingFile.class, null)};
        return processingPropertyArray;
    }

    public String getErrorMessage() {
        return null;
    }

    public boolean supportsConcurrentProcessing() {
        return false;
    }
}

