/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.tce;

import com.agfa.pacs.data.export.tce.Messages;
import com.agfa.pacs.data.export.tce.TCEProviderFactory;
import com.agfa.pacs.data.export.tce.TeachingFileDicomCode;
import com.agfa.pacs.data.export.tce.TeachingFileDicomTag;
import com.agfa.pacs.data.export.tce.TeachingFilePropertyValue;
import com.agfa.pacs.data.export.tce.TeachingFilePropertyValueType;
import com.agfa.pacs.data.export.tce.TeachingFileUtilities;
import com.agfa.pacs.data.export.tce.keyword.IKeyword;
import com.agfa.pacs.data.export.tce.keyword.IKeywordProvider;
import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.logging.ALogger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TeachingFileProperty<T>
implements Comparable<TeachingFileProperty<?>> {
    private static final ALogger log = ALogger.getLogger(TeachingFileProperty.class);
    public static final TeachingFileProperty<String> Abstract = new TeachingFileProperty<String>(TeachingFileDicomCode.Abstract, TeachingFilePropertyValueType.createStringInstance(), TeachingFileDicomTag.AllTags);
    public static final TeachingFileProperty<String> AcquisitionModalities = new TeachingFileProperty<String>(TeachingFileDicomCode.AcquisitionModality, TeachingFilePropertyValueType.createModalityInstance(), TeachingFileDicomTag.createDicomTags(524384, 524385));
    public static final TeachingFileProperty<IKeyword> Anatomy = new TeachingFileProperty<IKeyword>(TeachingFileDicomCode.Anatomy, TeachingFilePropertyValueType.createKeywordInstance(), new TeachingFileDicomTag[0]);
    public static final TeachingFileProperty<String> AuthorAffiliation = new TeachingFileProperty<String>(TeachingFileDicomCode.Affiliation, TeachingFilePropertyValueType.createStringInstance(), new TeachingFileDicomTag[0]);
    public static final TeachingFileProperty<String> AuthorContact = new TeachingFileProperty<String>(TeachingFileDicomCode.Contact, TeachingFilePropertyValueType.createStringInstance(), new TeachingFileDicomTag[0]);
    public static final TeachingFileProperty<String> AuthorName = new TeachingFileProperty<String>(TeachingFileDicomCode.AuthorName, TeachingFilePropertyValueType.createStringInstance(), new TeachingFileDicomTag[0]);
    public static final TeachingFileProperty<TeachingFilePropertyValue.Category> Category = new TeachingFileProperty<TeachingFilePropertyValue.Category>(TeachingFileDicomCode.Category, TeachingFilePropertyValueType.createEnumInstance(TeachingFilePropertyValue.Category.class), new TeachingFileDicomTag[0]);
    public static final TeachingFileProperty<Date> CreatedOn = new TeachingFileProperty<Date>(TeachingFileDicomCode.CreatedOn, TeachingFilePropertyValueType.createDateInstance(), new TeachingFileDicomTag[0]);
    public static final TeachingFileProperty<IKeyword> Diagnosis = new TeachingFileProperty<IKeyword>(TeachingFileDicomCode.Diagnosis, TeachingFilePropertyValueType.createKeywordInstance(), TeachingFileDicomTag.StudySeriesTags);
    public static final TeachingFileProperty<TeachingFilePropertyValue.YesNo> DiagnosisConfirmed = new TeachingFileProperty<TeachingFilePropertyValue.YesNo>(TeachingFileDicomCode.DiagnosisConfirmed, TeachingFilePropertyValueType.createEnumInstance(TeachingFilePropertyValue.YesNo.class), new TeachingFileDicomTag[0]);
    public static final TeachingFileProperty<IKeyword> DifferentialDiagnosis = new TeachingFileProperty<IKeyword>(TeachingFileDicomCode.DifferentialDiagnosis, TeachingFilePropertyValueType.createKeywordInstance(), TeachingFileDicomTag.StudySeriesTags);
    public static final TeachingFileProperty<String> Discussion = new TeachingFileProperty<String>(TeachingFileDicomCode.Discussion, TeachingFilePropertyValueType.createStringInstance(), TeachingFileDicomTag.StudySeriesTags);
    public static final TeachingFileProperty<IKeyword> Findings = new TeachingFileProperty<IKeyword>(TeachingFileDicomCode.Finding, TeachingFilePropertyValueType.createKeywordInstance(), TeachingFileDicomTag.StudySeriesTags);
    public static final TeachingFileProperty<String> History = new TeachingFileProperty<String>(TeachingFileDicomCode.History, TeachingFilePropertyValueType.createStringInstance(), TeachingFileDicomTag.StudySeriesTags);
    public static final TeachingFileProperty<IKeyword> Keywords = new TeachingFileProperty<IKeyword>(TeachingFileDicomCode.Keyword, TeachingFilePropertyValueType.createKeywordInstance(), TeachingFileDicomTag.AllTags);
    public static final TeachingFileProperty<TeachingFilePropertyValue.Level> Level = new TeachingFileProperty<TeachingFilePropertyValue.Level>(TeachingFileDicomCode.Level, TeachingFilePropertyValueType.createEnumInstance(TeachingFilePropertyValue.Level.class), new TeachingFileDicomTag[0]);
    public static final TeachingFileProperty<IKeyword> OrganSystems = new TeachingFileProperty<IKeyword>(TeachingFileDicomCode.OrganSystem, TeachingFilePropertyValueType.createKeywordInstance(), TeachingFileDicomTag.StudySeriesTags);
    public static final TeachingFileProperty<IKeyword> Pathology = new TeachingFileProperty<IKeyword>(TeachingFileDicomCode.Pathology, TeachingFilePropertyValueType.createKeywordInstance(), new TeachingFileDicomTag[0]);
    public static final TeachingFileProperty<Integer> PatientAge = new TeachingFileProperty<Integer>(TeachingFileDicomCode.PatientAge, TeachingFilePropertyValueType.createIntegerInstance(1, 730000), TeachingFileDicomTag.createDicomTags(0x100030));
    public static final TeachingFileProperty<TeachingFilePropertyValue.PatientSex> PatientSex = new TeachingFileProperty<TeachingFilePropertyValue.PatientSex>(TeachingFileDicomCode.PatientSex, TeachingFilePropertyValueType.createEnumInstance(TeachingFilePropertyValue.PatientSex.class), TeachingFileDicomTag.createDicomTags(0x100040));
    public static final TeachingFileProperty<String> PatientSpecies = new TeachingFileProperty<String>(TeachingFileDicomCode.PatientSpecies, TeachingFilePropertyValueType.createStringInstance(), TeachingFileDicomTag.appendTags(TeachingFileDicomTag.PatientTags, TeachingFileDicomTag.createDicomTags(0x102201)));
    public static final TeachingFileProperty<TeachingFilePropertyValue.Purpose> Purpose = new TeachingFileProperty<TeachingFilePropertyValue.Purpose>(TeachingFileDicomCode.Purpose, TeachingFilePropertyValueType.createEnumInstance(TeachingFilePropertyValue.Purpose.class), new TeachingFileDicomTag[0]);
    public static final TeachingFileProperty<String> BibliographicReferences = new TeachingFileProperty<String>(TeachingFileDicomCode.BibliographicReference, TeachingFilePropertyValueType.createStringInstance(), new TeachingFileDicomTag[0]);
    public static final TeachingFileProperty<String> Title = new TeachingFileProperty<String>(TeachingFileDicomCode.Title, TeachingFilePropertyValueType.createStringInstance(), TeachingFileDicomTag.StudySeriesTags);
    private static List<TeachingFileProperty<? extends Object>> allProperties = null;
    private static Map<TeachingFileProperty<? extends Object>, String> nameMap = null;
    private Code code;
    private TeachingFilePropertyValueType<T> valueType;
    private TeachingFileDicomTag[] compatibleDicomTags;

    private TeachingFileProperty(Code code, TeachingFilePropertyValueType<T> teachingFilePropertyValueType, TeachingFileDicomTag ... teachingFileDicomTagArray) {
        this.code = code;
        this.valueType = teachingFilePropertyValueType;
        this.compatibleDicomTags = teachingFileDicomTagArray;
    }

    public String name() {
        if (nameMap == null) {
            nameMap = TeachingFileProperty.nameMapImpl();
        }
        return nameMap.get(this);
    }

    public Code getCode() {
        return this.code;
    }

    public String getName() {
        return Messages.getString("TeachingFileProperty." + this.name());
    }

    public String toString() {
        return this.getName();
    }

    public TeachingFilePropertyValueType<T> getValueType() {
        return this.valueType;
    }

    public TeachingFileDicomTag[] getCompatibleDicomTags() {
        return this.compatibleDicomTags;
    }

    public IKeywordProvider getKeywordProvider() {
        if (IKeyword.class.isAssignableFrom(this.valueType.getValueClass())) {
            return TCEProviderFactory.getInstance().getConfiguration().getKeywordProvider(this);
        }
        return null;
    }

    public boolean isKeywordProviderExclusive() {
        return this.getKeywordProvider() != null && TCEProviderFactory.getInstance().getConfiguration().isKeywordProviderExclusive(this);
    }

    @Override
    public int compareTo(TeachingFileProperty<?> teachingFileProperty) {
        return this.getName().compareTo(teachingFileProperty.getName());
    }

    public boolean equals(Object object) {
        if (object instanceof TeachingFileProperty) {
            return this.getCode().equals((Object)((TeachingFileProperty)object).getCode());
        }
        return false;
    }

    public int hashCode() {
        return this.getCode().hashCode();
    }

    public TeachingFilePropertyValue<T> createValue(T ... TArray) {
        return TeachingFilePropertyValue.createInstance(this.valueType, TArray);
    }

    public TeachingFilePropertyValue<T> createValueUnchecked(Object ... objectArray) throws Exception {
        Class<T> clazz = this.valueType.getValueClass();
        List<Object> list = this.getValidValues(objectArray);
        if (String.class.isAssignableFrom(clazz)) {
            String[] stringArray = new String[list.size()];
            int n = 0;
            while (n < list.size()) {
                stringArray[n] = TeachingFileUtilities.convert(list.get(n), String.class);
                ++n;
            }
            return TeachingFilePropertyValue.createInstance(this.valueType, stringArray);
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            Integer[] integerArray = new Integer[list.size()];
            int n = 0;
            while (n < list.size()) {
                integerArray[n] = TeachingFileUtilities.convert(list.get(n), Integer.class);
                ++n;
            }
            return TeachingFilePropertyValue.createInstance(this.valueType, integerArray);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            Date[] dateArray = new Date[list.size()];
            int n = 0;
            while (n < list.size()) {
                dateArray[n] = TeachingFileUtilities.convert(list.get(n), Date.class);
                ++n;
            }
            return TeachingFilePropertyValue.createInstance(this.valueType, dateArray);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            Enum[] enumArray = new Enum[list.size()];
            int n = 0;
            while (n < list.size()) {
                enumArray[n] = (Enum)TeachingFileUtilities.convert(list.get(n), clazz);
                ++n;
            }
            return TeachingFilePropertyValue.createInstance(this.valueType, enumArray);
        }
        if (IKeyword.class.isAssignableFrom(clazz)) {
            IKeywordProvider iKeywordProvider = this.getKeywordProvider();
            IKeyword[] iKeywordArray = new IKeyword[list.size()];
            int n = 0;
            while (n < list.size()) {
                iKeywordArray[n] = TeachingFileUtilities.convert(list.get(n), IKeyword.class, iKeywordProvider);
                ++n;
            }
            return TeachingFilePropertyValue.createInstance(this.valueType, iKeywordArray);
        }
        return null;
    }

    public static TeachingFileProperty<? extends Object> valueOf(String string) {
        for (TeachingFileProperty<Object> teachingFileProperty : TeachingFileProperty.properties()) {
            if (!string.equals(teachingFileProperty.name())) continue;
            return teachingFileProperty;
        }
        return null;
    }

    public static TeachingFileProperty<? extends Object> find(Code code) {
        for (TeachingFileProperty<Object> teachingFileProperty : TeachingFileProperty.properties()) {
            if (!teachingFileProperty.getCode().equals((Object)code)) continue;
            return teachingFileProperty;
        }
        return null;
    }

    public static Collection<TeachingFileProperty<? extends Object>> properties() {
        if (allProperties == null) {
            allProperties = TeachingFileProperty.allPropertiesImpl();
        }
        return allProperties;
    }

    public static List<TeachingFileProperty<? extends Object>> keywordProperties() {
        ArrayList<TeachingFileProperty<? extends Object>> arrayList = new ArrayList<TeachingFileProperty<? extends Object>>();
        for (TeachingFileProperty<Object> teachingFileProperty : TeachingFileProperty.properties()) {
            if (!IKeyword.class.isAssignableFrom(teachingFileProperty.valueType.getValueClass())) continue;
            arrayList.add(teachingFileProperty);
        }
        return arrayList;
    }

    private static List<TeachingFileProperty<? extends Object>> allPropertiesImpl() {
        Field[] fieldArray = TeachingFileProperty.class.getFields();
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<TeachingFileProperty<? extends Object>> arrayList = new ArrayList<TeachingFileProperty<? extends Object>>(fieldArray.length);
            Field[] fieldArray2 = fieldArray;
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray2[n2];
                try {
                    Object object = field.get(null);
                    if (object instanceof TeachingFileProperty) {
                        arrayList.add((TeachingFileProperty)object);
                    }
                }
                catch (Exception exception) {
                    log.error("Error reading teaching file property!", (Throwable)exception);
                }
                ++n2;
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private static Map<TeachingFileProperty<? extends Object>, String> nameMapImpl() {
        Field[] fieldArray = TeachingFileProperty.class.getFields();
        if (fieldArray != null && fieldArray.length > 0) {
            HashMap<TeachingFileProperty<? extends Object>, String> hashMap = new HashMap<TeachingFileProperty<? extends Object>, String>(fieldArray.length);
            Field[] fieldArray2 = fieldArray;
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray2[n2];
                try {
                    Object object = field.get(null);
                    if (object instanceof TeachingFileProperty) {
                        hashMap.put((TeachingFileProperty)object, field.getName());
                    }
                }
                catch (Exception exception) {
                    log.error("Error reading teaching file property!", (Throwable)exception);
                }
                ++n2;
            }
            return hashMap;
        }
        return Collections.emptyMap();
    }

    private List<Object> getValidValues(Object ... objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray != null) {
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray2[n2];
                if (object != null) {
                    arrayList.add(object);
                }
                ++n2;
            }
        }
        return arrayList;
    }
}

