/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.tce.keyword;

import com.agfa.pacs.data.export.tce.keyword.AbstractKeywordProvider;
import com.agfa.pacs.data.export.tce.keyword.GenericSimpleListXMLKeywordProvider;
import com.agfa.pacs.data.export.tce.keyword.GenericSimpleTreeXMLKeywordProvider;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.BooleanUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class GenericXMLKeywordProvider
extends AbstractKeywordProvider {
    private static final String SIMPLE_LIST = "simple-list";
    private static final String SIMPLE_TREE = "simple-tree";
    private static final String USE_COMPLIANT_DESIGNATOR = "use-compliant-designator";

    protected GenericXMLKeywordProvider(String string, String string2) {
        super(string, string2);
    }

    public static GenericXMLKeywordProvider createInstance(File file) throws Exception {
        return GenericXMLKeywordProvider.createInstance(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public static GenericXMLKeywordProvider createInstance(InputStream inputStream) throws Exception {
        Document document = GenericXMLKeywordProvider.createDocument(inputStream);
        if (document.getElementsByTagName(SIMPLE_LIST).getLength() > 0) {
            return GenericSimpleListXMLKeywordProvider.createInstance(document);
        }
        if (document.getElementsByTagName(SIMPLE_TREE).getLength() > 0) {
            return GenericSimpleTreeXMLKeywordProvider.createInstance(document);
        }
        throw new UnsupportedOperationException("Unsupported XML format!");
    }

    protected static boolean useCompliantDesignator(Document document) {
        Node node = document.getElementsByTagName("coding-system").item(0);
        Node node2 = node.getAttributes().getNamedItem(USE_COMPLIANT_DESIGNATOR);
        if (node2 != null) {
            return BooleanUtils.toBoolean((String)node2.getNodeValue());
        }
        return false;
    }

    private static Document createDocument(InputStream inputStream) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setNamespaceAware(true);
        return documentBuilderFactory.newDocumentBuilder().parse(inputStream);
    }

    public static /* bridge */ /* synthetic */ AbstractKeywordProvider createInstance(File file) throws Exception {
        return GenericXMLKeywordProvider.createInstance(file);
    }
}

