/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.tce.property;

import com.agfa.pacs.data.export.tce.TeachingFileDicomTag;
import com.agfa.pacs.data.export.tce.TeachingFileProperty;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TeachingFileConfigProperty {
    private TeachingFileProperty<?> p;
    private PropertyValue value;
    private boolean useInExport;
    private boolean useInQuery;
    private boolean useInExportUI;
    private boolean useInQueryUI;
    private boolean modified;

    public TeachingFileConfigProperty(TeachingFileProperty<? extends Object> teachingFileProperty, PropertyValue propertyValue, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.p = teachingFileProperty;
        this.value = propertyValue;
        this.useInExport = bl;
        this.useInExportUI = bl2;
        this.useInQuery = bl3;
        this.useInQueryUI = bl4;
    }

    public static TeachingFileConfigProperty create(Node node) throws Exception {
        boolean bl;
        NamedNodeMap namedNodeMap = node.getAttributes();
        TeachingFileProperty<Object> teachingFileProperty = TeachingFileProperty.valueOf(namedNodeMap.getNamedItem("name").getTextContent());
        PropertyValueType propertyValueType = PropertyValueType.valueOf(namedNodeMap.getNamedItem("value-type").getTextContent());
        String string = namedNodeMap.getNamedItem("value") != null ? namedNodeMap.getNamedItem("value").getTextContent() : null;
        boolean bl2 = namedNodeMap.getNamedItem("query") != null ? Boolean.valueOf(namedNodeMap.getNamedItem("query").getTextContent()) : true;
        boolean bl3 = namedNodeMap.getNamedItem("export") != null ? Boolean.valueOf(namedNodeMap.getNamedItem("export").getTextContent()) : true;
        boolean bl4 = namedNodeMap.getNamedItem("query-ui") != null ? Boolean.valueOf(namedNodeMap.getNamedItem("query-ui").getTextContent()) : true;
        boolean bl5 = bl = namedNodeMap.getNamedItem("export-ui") != null ? Boolean.valueOf(namedNodeMap.getNamedItem("export-ui").getTextContent()) : true;
        if (teachingFileProperty == null) {
            throw new UnsupportedOperationException("Property null is not supported");
        }
        if (string == null || string.length() == 0) {
            propertyValueType = PropertyValueType.Empty;
        }
        if (PropertyValueType.Empty.equals((Object)propertyValueType)) {
            return new TeachingFileConfigProperty(teachingFileProperty, PropertyValue.createEmptyValue(), bl3, bl, bl2, bl4);
        }
        if (PropertyValueType.Constant.equals((Object)propertyValueType)) {
            return new TeachingFileConfigProperty(teachingFileProperty, PropertyValue.createConstantValue(string), bl3, bl, bl2, bl4);
        }
        if (PropertyValueType.DicomTag.equals((Object)propertyValueType)) {
            TeachingFileDicomTag teachingFileDicomTag = null;
            if (string != null) {
                teachingFileDicomTag = string.startsWith("0x") ? new TeachingFileDicomTag(Integer.parseInt(string.substring(2), 16)) : new TeachingFileDicomTag(Integer.parseInt(string));
            }
            return new TeachingFileConfigProperty(teachingFileProperty, PropertyValue.createDicomTagValue(teachingFileDicomTag), bl3, bl, bl2, bl4);
        }
        throw new UnsupportedOperationException("Property value type is not supported!");
    }

    public TeachingFileProperty<?> getProperty() {
        return this.p;
    }

    public PropertyValue getPropertyValue() {
        return this.value;
    }

    public boolean useInQuery() {
        return this.useInQuery;
    }

    public boolean useInExport() {
        return this.useInExport;
    }

    public boolean useInExportUI() {
        return this.useInExportUI;
    }

    public boolean useInQueryUI() {
        return this.useInQueryUI;
    }

    public void setUseInQuery(boolean bl) {
        this.useInQuery = bl;
        this.modified = true;
    }

    public void setUseInExport(boolean bl) {
        this.useInExport = bl;
        this.modified = true;
    }

    public void setUseInQueryUI(boolean bl) {
        this.useInQueryUI = bl;
        this.modified = true;
    }

    public void setUseInExportUI(boolean bl) {
        this.useInExportUI = bl;
        this.modified = true;
    }

    public boolean isModified() {
        return this.modified || this.value.modified;
    }

    public void resetModified() {
        this.modified = false;
        this.value.modified = false;
    }

    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<property");
        stringBuilder.append(" name=\"" + this.p.name() + "\"");
        stringBuilder.append(" value-type=\"" + this.value.getValueType().name() + "\"");
        Object object = this.value.getValue();
        if (object != null) {
            if (object instanceof TeachingFileDicomTag) {
                stringBuilder.append(" value=\"0x" + Integer.toHexString(((TeachingFileDicomTag)object).getTag()) + "\"");
            } else if (object instanceof Enum) {
                stringBuilder.append(" value=\"" + ((Enum)object).name() + "\"");
            } else {
                stringBuilder.append(" value=\"" + object.toString() + "\"");
            }
        }
        stringBuilder.append(" query=\"").append(this.useInQuery).append("\"");
        stringBuilder.append(" query-ui=\"").append(this.useInQueryUI).append("\"");
        stringBuilder.append(" export=\"").append(this.useInExport).append("\"");
        stringBuilder.append(" export-ui=\"").append(this.useInExportUI).append("\"");
        stringBuilder.append("/>");
        return stringBuilder.toString();
    }

    public String toString() {
        return this.p.getName();
    }

    public static class PropertyValue {
        private PropertyValueType type;
        private Object value;
        private boolean modified;

        private PropertyValue(PropertyValueType propertyValueType, Object object) {
            this.type = propertyValueType;
            this.value = object;
        }

        public static PropertyValue createEmptyValue() {
            return new PropertyValue(PropertyValueType.Empty, null);
        }

        public static PropertyValue createConstantValue(Object object) {
            return new PropertyValue(PropertyValueType.Constant, object);
        }

        public static PropertyValue createDicomTagValue(TeachingFileDicomTag teachingFileDicomTag) {
            return new PropertyValue(PropertyValueType.DicomTag, teachingFileDicomTag);
        }

        public PropertyValueType getValueType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setDicomTagValue(TeachingFileDicomTag teachingFileDicomTag) {
            this.type = PropertyValueType.DicomTag;
            this.value = teachingFileDicomTag;
            this.modified = true;
        }

        public void setConstantValue(Object object) {
            this.type = PropertyValueType.Constant;
            this.value = object;
            this.modified = true;
        }

        public void setEmptyValue() {
            this.type = PropertyValueType.Empty;
            this.value = null;
            this.modified = true;
        }
    }

    public static enum PropertyValueType {
        Empty,
        Constant,
        DicomTag;

    }
}

