/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicom.lw.datainfo;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.QueryRetrieveLevel;
import com.agfa.pacs.data.dicom.comm.DicomCFindConst;
import com.agfa.pacs.data.dicom.comm.DicomCompositeCFindSCU;
import com.agfa.pacs.data.dicom.comm.QueryRetrieveInformationModel;
import com.agfa.pacs.data.dicom.lw.datainfo.DicomCFindUtilities;
import com.agfa.pacs.data.dicom.lw.datainfo.IDicomDatabaseAccess;
import com.agfa.pacs.data.shared.IPatientHierarchy;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.filter.IFilter;
import com.agfa.pacs.data.shared.lw.DataInfoFactoryProvider;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoFactory;
import com.agfa.pacs.data.shared.lw.IDataProviderIdentifier;
import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.primitives.IntHashSet;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;

public abstract class AbstractDicomDatabaseAccess
implements IDicomDatabaseAccess {
    private static final ALogger log = ALogger.getLogger(AbstractDicomDatabaseAccess.class);
    protected static final IDataInfoFactory diFact = DataInfoFactoryProvider.getInstance();
    protected DicomCompositeCFindSCU cfind;
    protected boolean isAgfaNode;
    protected boolean closeImmediately;
    private int[] notSeriesTags;
    private boolean reduceMemory = true;
    private static final int[] PatientTags = new int[]{524293, 0x100010, 0x100020, 0x100021};
    private static final int[] StudyTags = new int[]{0x20000D};
    private static final int[] SeriesTags = new int[]{0x20000D, 0x20000E};
    private final EnumMap<Level, Attributes> searchObjects = new EnumMap(Level.class);
    private static /* synthetic */ int[] $SWITCH_TABLE$com$agfa$pacs$data$shared$dicom$Level;

    public AbstractDicomDatabaseAccess(IDicomNode iDicomNode, byte[] byArray, boolean bl, boolean bl2) throws DicomException {
        this.cfind = new DicomCompositeCFindSCU(iDicomNode, bl2 ? DicomCompositeCFindSCU.DefaultStandardQueryClassUIDs : DicomCompositeCFindSCU.DefaultQueryClassUIDs, byArray, bl2);
        if (iDicomNode instanceof IDataProviderIdentifier) {
            this.isAgfaNode = ((IDataProviderIdentifier)iDicomNode).getType().toUpperCase(Locale.ENGLISH).contains("AGFA");
        }
        this.closeImmediately = bl;
        this.reduceMemory = ConfigurationProviderFactory.getConfig().getBoolean("listtext.dicom.device.config.ReduceFindMemory");
    }

    private void initTags() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(DicomCFindConst.IMAGE_TAGS.length);
        int n = 0;
        while (n < DicomCFindConst.IMAGE_TAGS.length) {
            arrayList.add(DicomCFindConst.IMAGE_TAGS[n]);
            ++n;
        }
        arrayList.add(0x100010);
        arrayList.add(0x100020);
        arrayList.add(0x100021);
        this.notSeriesTags = new int[arrayList.size()];
        n = 0;
        while (n < arrayList.size()) {
            this.notSeriesTags[n] = (Integer)arrayList.get(n);
            ++n;
        }
        Arrays.sort(this.notSeriesTags);
    }

    protected void finalize() throws Throwable {
        this.cfind.close();
        super.finalize();
    }

    protected void checkConnection() throws Exception {
        if (this.cfind.isConnected()) {
            return;
        }
        if (this.notSeriesTags == null) {
            this.initTags();
        }
        this.cfind.connect();
    }

    protected void releaseConnection() {
        if (this.closeImmediately) {
            try {
                this.cfind.close();
            }
            catch (Exception exception) {
                log.error("Error", (Throwable)exception);
            }
        }
    }

    private List<Attributes> getSearch(IFilter iFilter, Attributes attributes, Level level) throws Exception {
        return this.getSearch(iFilter.getLevel(level), attributes, level);
    }

    private synchronized List<Attributes> getSearch(List<Attributes> list, Attributes attributes, Level level) {
        ArrayList<Attributes> arrayList = new ArrayList<Attributes>();
        try {
            try {
                this.checkConnection();
                if (attributes != null && attributes.isEmpty()) {
                    attributes = null;
                }
                for (Attributes attributes2 : list) {
                    List<Attributes> list2 = DicomCFindUtilities.splitListOfUIDMatching(attributes2);
                    for (Attributes attributes3 : list2) {
                        Attributes attributes4 = null;
                        if (this.cfind.isInitReturnTags() || attributes != null) {
                            attributes4 = this.fillDataset(level, null);
                            if (attributes != null) {
                                attributes4.addAll(attributes);
                            }
                            attributes4.addAll(attributes3);
                        } else {
                            attributes4 = attributes3;
                        }
                        arrayList.addAll(this.cfind.find(attributes4, QueryRetrieveLevel.get((IPatientHierarchy)level)));
                    }
                }
            }
            catch (Exception exception) {
                log.warn("CFind problem on " + level, (Throwable)exception);
                this.releaseConnection();
            }
        }
        finally {
            this.releaseConnection();
        }
        return arrayList;
    }

    private synchronized List<Attributes> getSearch(Attributes attributes, Level level) {
        ArrayList arrayList = null;
        try {
            try {
                this.checkConnection();
                List<Attributes> list = DicomCFindUtilities.splitListOfUIDMatching(attributes);
                for (Attributes attributes2 : list) {
                    Attributes attributes3 = null;
                    if (this.cfind.isInitReturnTags()) {
                        attributes3 = this.fillDataset(level, null);
                        attributes3.addAll(attributes2);
                    } else {
                        attributes3 = attributes2;
                    }
                    List list2 = this.cfind.find(attributes3, QueryRetrieveLevel.get((IPatientHierarchy)level));
                    if (arrayList == null) {
                        arrayList = new ArrayList(list2);
                        continue;
                    }
                    arrayList.addAll(list2);
                }
            }
            catch (Exception exception) {
                log.warn("CFind problem", (Throwable)exception);
                this.releaseConnection();
                return null;
            }
        }
        finally {
            this.releaseConnection();
        }
        if (arrayList == null) {
            arrayList = new ArrayList(0);
        }
        return arrayList;
    }

    @Override
    public List<Attributes> rawDicomSearch(Attributes attributes, String string) throws DicomException {
        return this.cfind.cFind(attributes);
    }

    @Override
    public synchronized List<Attributes> getRelationalSearch(List<Attributes> list, Attributes attributes, Level level) throws Exception {
        try {
            ArrayList<Attributes> arrayList = new ArrayList<Attributes>();
            this.checkConnection();
            for (Attributes attributes2 : list) {
                List<Attributes> list2 = DicomCFindUtilities.splitListOfUIDMatching(attributes2);
                for (Attributes attributes3 : list2) {
                    Attributes attributes4 = null;
                    if (this.cfind.isInitReturnTags() || attributes != null) {
                        attributes4 = this.createRelationalDataset(level);
                        if (attributes != null) {
                            attributes4.addAll(attributes);
                        }
                        attributes4.addAll(attributes3);
                    } else {
                        attributes4 = attributes3;
                    }
                    arrayList.addAll(this.cfind.find(attributes4, QueryRetrieveLevel.get((IPatientHierarchy)level)));
                }
            }
            ArrayList<Attributes> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.releaseConnection();
        }
    }

    @Override
    public void cancel() {
        this.cfind.cancel();
    }

    @Override
    public List<IDataInfo> getHierarchicalDataInfo(IFilter iFilter, Level level, Level level2) throws Exception {
        Object object;
        Object object2;
        if (QueryRetrieveInformationModel.PatientStudyOnly == this.cfind.getQueryRetrieveInformationModel()) {
            if (level.getLevel() > Level.Study.getLevel()) {
                level = Level.Study;
            }
            if (level2.getLevel() > Level.Study.getLevel()) {
                level2 = Level.Study;
            }
        }
        List<Attributes> list = null;
        List<Attributes> list2 = null;
        List<Attributes> list3 = null;
        List<Attributes> list4 = null;
        Attributes attributes = new Attributes();
        boolean bl = false;
        int n = level2.getLevel();
        while (n >= Level.Study.getLevel()) {
            object2 = Level.get((int)n);
            switch (AbstractDicomDatabaseAccess.$SWITCH_TABLE$com$agfa$pacs$data$shared$dicom$Level()[object2.ordinal()]) {
                case 2: {
                    list2 = this.doHierarchicalDataInfoForStudy(iFilter, attributes, (Level)object2);
                    break;
                }
                case 3: {
                    list3 = this.getSearch(iFilter, attributes, (Level)object2);
                    if (list3.size() == 0) {
                        bl = true;
                        break;
                    }
                    object = this.extractIDs(list3, 0x20000D);
                    attributes.setString(0x20000D, VR.UI, object.toArray(new String[object.size()]));
                    break;
                }
                case 4: {
                    list4 = this.getSearch(iFilter, attributes, (Level)object2);
                    if (list4.size() == 0) {
                        bl = true;
                        break;
                    }
                    object = this.extractIDs(list4, 0x20000E);
                    attributes.setString(0x20000E, VR.UI, object.toArray(new String[object.size()]));
                }
            }
            if (bl) break;
            --n;
        }
        Map<String, IPatientInfo> map = null;
        object2 = null;
        object = null;
        Map<String, IObjectInfo> map2 = null;
        if (QueryRetrieveInformationModel.StudyRoot == this.cfind.getQueryRetrieveInformationModel()) {
            if (list2 == null) {
                ArrayList<Attributes> arrayList = new ArrayList<Attributes>();
                List list5 = iFilter.getLevel(Level.Patient);
                List list6 = iFilter.getLevel(Level.Study);
                for (Attributes attributes2 : list5) {
                    for (Attributes attributes3 : list6) {
                        Attributes attributes4 = new Attributes(attributes3);
                        attributes4.addAll(attributes2);
                        if (attributes4.isEmpty()) continue;
                        arrayList.add(attributes4);
                    }
                }
                if (!arrayList.isEmpty()) {
                    list2 = this.getRelationalSearch(arrayList, null, Level.Study);
                }
            }
            if (list2 != null) {
                map = this.createPatients(list2, level2 == Level.Patient);
            }
        } else {
            list = this.patientRootQR(iFilter, level, list2);
            map = this.createPatients(list, level2 == Level.Patient);
        }
        if (map != null && level2 == Level.Patient) {
            return new ArrayList<IPatientInfo>(map.values());
        }
        object2 = this.createStudies(list2, map, level2 == Level.Study);
        if (level2 == Level.Study) {
            return new ArrayList<IDataInfo>(object2.values());
        }
        object = this.createSeries(list3, (Map<String, IStudyInfo>)object2, level2 == Level.Series);
        if (level2 == Level.Series) {
            return new ArrayList<IDataInfo>(object.values());
        }
        map2 = this.createObjects(list4, (Map<String, ISeriesInfo>)object);
        if (level2 == Level.Object) {
            return new ArrayList<IObjectInfo>(map2.values());
        }
        return new ArrayList<IDataInfo>();
    }

    private List<Attributes> patientRootQR(IFilter iFilter, Level level, List<Attributes> list) {
        List<Attributes> list2;
        if (level == Level.Patient) {
            List<Attributes> list3 = this.extractTags(iFilter.getLevel(Level.Patient), new int[]{0x100010, 0x100020, 0x100021});
            if (list3.isEmpty() && list != null) {
                list3 = this.extractTags(list, new int[]{0x100010, 0x100020, 0x100021});
            }
            list2 = this.getSearch(list3, null, Level.Patient);
        } else {
            List<Attributes> list4 = this.extractTags(list, new int[]{0x100010, 0x100020, 0x100021});
            list2 = this.getSearch(list4, null, Level.Patient);
        }
        return list2;
    }

    private List<Attributes> doHierarchicalDataInfoForStudy(IFilter iFilter, Attributes attributes, Level level) throws Exception {
        List<Attributes> list;
        if (QueryRetrieveInformationModel.StudyRoot == this.cfind.getQueryRetrieveInformationModel()) {
            ArrayList<Attributes> arrayList = new ArrayList<Attributes>();
            List list2 = iFilter.getLevel(Level.Patient);
            List list3 = iFilter.getLevel(Level.Study);
            for (Attributes attributes2 : list2) {
                for (Attributes attributes3 : list3) {
                    Attributes attributes4 = new Attributes(attributes3);
                    attributes4.addAll(attributes2);
                    arrayList.add(attributes4);
                }
            }
            list = this.getRelationalSearch(arrayList, attributes, level);
        } else {
            list = this.getSearch(iFilter, attributes, level);
        }
        return list;
    }

    private List<Attributes> extractTags(List<Attributes> list, int[] nArray) {
        ArrayList<Attributes> arrayList = new ArrayList<Attributes>();
        for (Attributes attributes : list) {
            Attributes attributes2 = new Attributes(attributes, nArray);
            if (attributes2.isEmpty()) continue;
            arrayList.add(attributes2);
        }
        return arrayList;
    }

    private List<String> extractIDs(List<Attributes> list, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Attributes attributes : list) {
            String string = attributes.getString(n);
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public List<IDataInfo> getRelationalPatientInfo(List<Attributes> list, Attributes attributes) throws Exception {
        if (QueryRetrieveInformationModel.StudyRoot == this.cfind.getQueryRetrieveInformationModel()) {
            List<Attributes> list2 = this.getRelationalSearch(list, attributes, Level.Study);
            ArrayList<Attributes> arrayList = new ArrayList<Attributes>();
            for (Attributes object2 : list2) {
                Attributes attributes2 = new Attributes(16);
                attributes2.addSelected(object2, DicomCFindConst.PATIENT_TAGS);
                arrayList.add(attributes2);
            }
            Map<String, IPatientInfo> map = this.createPatients(arrayList, true);
            return new ArrayList<IPatientInfo>(map.values());
        }
        List<Attributes> list3 = this.getRelationalSearch(list, attributes, Level.Patient);
        Map<String, IPatientInfo> map = this.createPatients(list3, true);
        return new ArrayList<IPatientInfo>(map.values());
    }

    @Override
    public List<IDataInfo> getRelationalStudyInfo(List<Attributes> list, Attributes attributes) throws Exception {
        List<Attributes> list2 = this.getRelationalSearch(list, attributes, Level.Study);
        Map<String, IPatientInfo> map = this.createPatients(list2, false);
        Map<String, IStudyInfo> map2 = this.createStudies(list2, map, true);
        return new ArrayList<IStudyInfo>(map2.values());
    }

    @Override
    public List<IDataInfo> getRelationalSeriesInfo(List<Attributes> list, Attributes attributes) throws Exception {
        List<Attributes> list2 = this.getRelationalSearch(list, attributes, Level.Series);
        Map<String, IPatientInfo> map = this.createPatients(list2, false);
        Map<String, IStudyInfo> map2 = this.createStudies(list2, map, false);
        Map<String, ISeriesInfo> map3 = this.createSeries(list2, map2, true);
        return new ArrayList<ISeriesInfo>(map3.values());
    }

    @Override
    public List<IDataInfo> getRelationalObjectInfo(List<Attributes> list, Attributes attributes) throws Exception {
        List<Attributes> list2 = this.getRelationalSearch(list, attributes, Level.Object);
        Map<String, IPatientInfo> map = this.createPatients(list2, false);
        Map<String, IStudyInfo> map2 = this.createStudies(list2, map, false);
        Map<String, ISeriesInfo> map3 = this.createSeries(list2, map2, false);
        Map<String, IObjectInfo> map4 = this.createObjects(list2, map3);
        return new ArrayList<IObjectInfo>(map4.values());
    }

    private Map<String, IObjectInfo> createObjects(List<Attributes> list, Map<String, ISeriesInfo> map) {
        HashMap<String, IObjectInfo> hashMap = new HashMap<String, IObjectInfo>();
        for (Attributes attributes : list) {
            String string;
            ISeriesInfo iSeriesInfo;
            String string2 = attributes.getString(524312);
            if (hashMap.containsKey(string2) || (iSeriesInfo = map.get(string = this.getCompoundSeriesKey(attributes))) == null) continue;
            IObjectInfo iObjectInfo = this.createObjectInfo(iSeriesInfo, attributes);
            iSeriesInfo.addChild((IDataInfo)iObjectInfo);
            hashMap.put(string2, iObjectInfo);
        }
        return hashMap;
    }

    @Override
    public Map<String, ISeriesInfo> createSeries(List<Attributes> list, Map<String, IStudyInfo> map, boolean bl) {
        LinkedHashMap<String, ISeriesInfo> linkedHashMap = new LinkedHashMap<String, ISeriesInfo>();
        for (Attributes attributes : list) {
            IStudyInfo iStudyInfo;
            String string = this.getCompoundSeriesKey(attributes);
            if (linkedHashMap.containsKey(string) || (iStudyInfo = map.get(this.getCompoundStudyKey(attributes))) == null) continue;
            ISeriesInfo iSeriesInfo = this.createSeriesInfo(iStudyInfo, attributes, bl);
            iStudyInfo.addChild((IDataInfo)iSeriesInfo);
            linkedHashMap.put(string, iSeriesInfo);
        }
        return linkedHashMap;
    }

    @Override
    public Map<String, IStudyInfo> createStudies(List<Attributes> list, Map<String, IPatientInfo> map, boolean bl) {
        LinkedHashMap<String, IStudyInfo> linkedHashMap = new LinkedHashMap<String, IStudyInfo>();
        for (Attributes attributes : list) {
            String string;
            IPatientInfo iPatientInfo;
            String string2 = this.getCompoundStudyKey(attributes);
            if (linkedHashMap.containsKey(string2) || (iPatientInfo = map.get(string = DataInfoUtilities.compilePatientKey((Attributes)attributes))) == null) continue;
            IStudyInfo iStudyInfo = this.createStudyInfo(iPatientInfo, attributes, attributes.getString(0x20000D), bl);
            iPatientInfo.addChild((IDataInfo)iStudyInfo);
            linkedHashMap.put(string2, iStudyInfo);
        }
        return linkedHashMap;
    }

    private String getCompoundStudyKey(Attributes attributes) {
        return String.valueOf(DataInfoUtilities.compilePatientKey((Attributes)attributes)) + attributes.getString(0x20000D);
    }

    private String getCompoundSeriesKey(Attributes attributes) {
        return String.valueOf(DataInfoUtilities.compilePatientKey((Attributes)attributes)) + attributes.getString(0x20000D) + attributes.getString(0x20000E);
    }

    @Override
    public Map<String, IPatientInfo> createPatients(List<Attributes> list, boolean bl) {
        LinkedHashMap<String, IPatientInfo> linkedHashMap = new LinkedHashMap<String, IPatientInfo>();
        if (list != null) {
            for (Attributes attributes : list) {
                String string = DataInfoUtilities.compilePatientKey((Attributes)attributes);
                if (linkedHashMap.containsKey(string)) continue;
                IPatientInfo iPatientInfo = null;
                if (bl) {
                    iPatientInfo = diFact.createPatientInfo(null, attributes, string);
                } else {
                    Attributes attributes2 = new Attributes();
                    attributes2.addSelected(attributes, DicomCFindConst.PATIENT_TAGS);
                    iPatientInfo = diFact.createPatientInfo(null, attributes2, string);
                }
                linkedHashMap.put(string, iPatientInfo);
            }
        }
        return linkedHashMap;
    }

    protected Attributes fillDataset(Level level, Attributes attributes) {
        try {
            DicomCFindConst.searchLock.await();
        }
        catch (InterruptedException interruptedException) {}
        Attributes attributes2 = this.searchObjects.get(level);
        if (attributes2 != null) {
            if (attributes == null) {
                attributes = new Attributes(50);
            }
            attributes.addAll(attributes2);
            return attributes;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (Level.Study.compareTo((Enum)level) <= 0) {
            arrayList.add(0x100010);
            arrayList.add(0x100020);
            arrayList.add(0x100021);
        }
        if (Level.Series.compareTo((Enum)level) <= 0) {
            arrayList.add(0x20000D);
        }
        if (Level.Object.compareTo((Enum)level) <= 0) {
            arrayList.add(0x20000E);
        }
        int[] nArray = DicomCFindConst.TAGS[level.getLevel()];
        int[][] nArray2 = DicomCFindConst.NESTED_TAGS[level.getLevel()];
        Attributes attributes3 = new Attributes(50);
        for (Integer n : arrayList) {
            attributes3.setNull(n.intValue(), ElementDictionary.vrOf((int)n, null));
        }
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n];
                VR vR = ElementDictionary.vrOf((int)nArray[n], null);
                if (vR == VR.SQ) {
                    this.createIfAbsentSequence(attributes3, n2);
                } else {
                    attributes3.setNull(n2, vR);
                }
                ++n;
            }
        }
        if (nArray2 != null) {
            int n = 0;
            while (n < nArray2.length) {
                Sequence sequence = this.createIfAbsentSequence(attributes3, nArray2[n][0]);
                int n3 = nArray2[n][2];
                ((Attributes)sequence.get(0)).setNull(n3, ElementDictionary.vrOf((int)n3, null));
                ++n;
            }
        }
        if (!this.isAgfaNode) {
            attributes3.remove(4390932);
        }
        this.searchObjects.put(level, attributes3);
        if (attributes == null) {
            attributes = new Attributes(attributes3.size());
        }
        attributes.addAll(attributes3);
        return attributes;
    }

    private Sequence createIfAbsentSequence(Attributes attributes, int n) {
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            sequence = attributes.newSequence(n, 2);
            sequence.add(new Attributes());
        }
        return sequence;
    }

    private Attributes createRelationalDataset(Level level) {
        Attributes attributes = new Attributes();
        int n = Level.Patient.getLevel();
        while (n <= level.getLevel()) {
            this.fillDataset(Level.get((int)n), attributes);
            ++n;
        }
        return attributes;
    }

    @Override
    public synchronized boolean isRelational() throws Exception {
        try {
            this.checkConnection();
            boolean bl = this.cfind.isRelational();
            return bl;
        }
        finally {
            this.releaseConnection();
        }
    }

    protected abstract void setLocations(ILoadableInfo var1, Attributes var2);

    public List<IDataInfo> getDataInfo(IDataInfo iDataInfo, Level level) {
        try {
            if (iDataInfo instanceof IRootInfo) {
                Attributes attributes = new Attributes();
                return this.getPatientInfo((IRootInfo)iDataInfo, attributes);
            }
            if (iDataInfo instanceof IPatientInfo) {
                Attributes attributes = new Attributes();
                attributes.addSelected(iDataInfo.getAttributes(), PatientTags);
                if (level != null && level == Level.Study) {
                    return this.getStudyInfo((IPatientInfo)iDataInfo, attributes);
                }
                if (level != null && level == Level.Series) {
                    return this.getStudiesAndSeriesInfo((IPatientInfo)iDataInfo, attributes);
                }
                return this.getStudyInfo((IPatientInfo)iDataInfo, attributes);
            }
            if (iDataInfo instanceof IStudyInfo) {
                Attributes attributes = new Attributes();
                attributes.addSelected(iDataInfo.getAttributes(), StudyTags);
                if (level != null && level == Level.Object && this.isAgfaNode) {
                    return this.getSeriesAndObjectInfo((IStudyInfo)iDataInfo, attributes);
                }
                return this.getSeriesInfo((IStudyInfo)iDataInfo, attributes);
            }
            if (iDataInfo instanceof ISeriesInfo) {
                Attributes attributes = new Attributes();
                attributes.addSelected(iDataInfo.getAttributes(), SeriesTags);
                return this.getObjectInfo((ISeriesInfo)iDataInfo, attributes);
            }
            return null;
        }
        catch (Exception exception) {
            log.error("Retriever error", (Throwable)exception);
            return null;
        }
    }

    private List<IDataInfo> getPatientInfo(IRootInfo iRootInfo, Attributes attributes) {
        int n;
        List<Attributes> list = this.getSearch(attributes, Level.Patient);
        if (list != null && (n = list.size()) > 0) {
            ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>(n);
            Iterator<Attributes> iterator = list.iterator();
            while (iterator.hasNext()) {
                Attributes attributes2;
                Attributes attributes3 = attributes2 = iterator.next();
                String string = DataInfoUtilities.compilePatientKey((Attributes)attributes3);
                IPatientInfo iPatientInfo = diFact.createPatientInfo(iRootInfo, attributes3, string);
                if (iRootInfo != null) {
                    iPatientInfo.setSource(iRootInfo.getSource());
                }
                arrayList.add((IDataInfo)iPatientInfo);
            }
            return arrayList;
        }
        return new ArrayList<IDataInfo>(0);
    }

    private List<IDataInfo> getStudyInfo(IPatientInfo iPatientInfo, Attributes attributes) {
        int n;
        List<Attributes> list = this.getSearch(attributes, Level.Study);
        String string = iPatientInfo.getString(0x100021);
        if (list != null && (n = list.size()) > 0) {
            ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>(n);
            for (Attributes attributes2 : list) {
                if (!CompareUtils.equals((Object)attributes2.getString(0x100021), (Object)string)) continue;
                String string2 = attributes2.getString(0x20000D);
                IStudyInfo iStudyInfo = diFact.createStudyInfo(iPatientInfo, attributes2, string2);
                iStudyInfo.setSource(iPatientInfo.getSource());
                arrayList.add((IDataInfo)iStudyInfo);
            }
            return arrayList;
        }
        return new ArrayList<IDataInfo>(0);
    }

    protected List<IDataInfo> getSeriesInfo(IStudyInfo iStudyInfo, Attributes attributes) {
        int n;
        List<Attributes> list = this.getSearch(attributes, Level.Series);
        if (list != null && (n = list.size()) > 0) {
            ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>(n);
            for (Attributes attributes2 : list) {
                ISeriesInfo iSeriesInfo = this.createSeriesInfo(iStudyInfo, attributes2, true);
                arrayList.add((IDataInfo)iSeriesInfo);
            }
            return arrayList;
        }
        return new ArrayList<IDataInfo>(0);
    }

    protected ISeriesInfo createSeriesInfo(IStudyInfo iStudyInfo, Attributes attributes, boolean bl) {
        String string = attributes.getString(0x20000E);
        ISeriesInfo iSeriesInfo = null;
        if (bl) {
            iSeriesInfo = diFact.createSeriesInfo(iStudyInfo, attributes, string);
        } else {
            Attributes attributes2 = new Attributes();
            attributes2.addSelected(attributes, DicomCFindConst.SERIES_MERGED_TAGS);
            iSeriesInfo = diFact.createSeriesInfo(iStudyInfo, attributes2, string);
        }
        this.setLocations((ILoadableInfo)iSeriesInfo, attributes);
        return iSeriesInfo;
    }

    private IStudyInfo createStudyInfo(IPatientInfo iPatientInfo, Attributes attributes) {
        String string = attributes.getString(0x20000D);
        return this.createStudyInfo(iPatientInfo, attributes, string, false);
    }

    private IStudyInfo createStudyInfo(IPatientInfo iPatientInfo, Attributes attributes, String string, boolean bl) {
        IStudyInfo iStudyInfo;
        if (bl) {
            iStudyInfo = diFact.createStudyInfo(iPatientInfo, attributes, string);
        } else {
            Attributes attributes2 = new Attributes();
            attributes2.addSelected(attributes, DicomCFindConst.STUDIES_MERGED_TAGS);
            iStudyInfo = diFact.createStudyInfo(iPatientInfo, attributes2, string);
        }
        return iStudyInfo;
    }

    private int[] getObjectTags2Delete(Attributes attributes) {
        int n;
        if (!this.reduceMemory) {
            return new int[0];
        }
        IntHashSet intHashSet = new IntHashSet(128);
        int[] nArray = attributes.tags();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            n = nArray[n3];
            intHashSet.add(n);
            ++n3;
        }
        n = 0;
        while (n < DicomCFindConst.IMAGE_TAGS.length) {
            intHashSet.remove(DicomCFindConst.IMAGE_TAGS[n]);
            ++n;
        }
        intHashSet.remove(0x100010);
        intHashSet.remove(0x100020);
        intHashSet.remove(0x100021);
        intHashSet.remove(0x20000D);
        intHashSet.remove(0x20000E);
        int[] nArray2 = intHashSet.toArray();
        Arrays.sort(nArray2);
        return nArray2;
    }

    protected List<IDataInfo> getObjectInfo(ISeriesInfo iSeriesInfo, Attributes attributes) {
        try {
            this.checkConnection();
            Attributes attributes2 = attributes;
            if (this.cfind.isInitReturnTags()) {
                attributes2 = this.fillDataset(Level.Object, null);
                attributes2.addAll(attributes);
            }
            List list = this.cfind.find(attributes2, QueryRetrieveLevel.Image);
            ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>(list.size());
            if (list.size() > 0) {
                int[] nArray = this.getObjectTags2Delete((Attributes)list.get(0));
                int n = ((Attributes)list.get(0)).size() - nArray.length;
                int n2 = 0;
                while (n2 < list.size()) {
                    Attributes attributes3 = (Attributes)list.get(n2);
                    Attributes attributes4 = new Attributes(n);
                    attributes4.addNotSelected(attributes3, nArray);
                    arrayList.add((IDataInfo)this.createObjectInfo(iSeriesInfo, attributes4));
                    ++n2;
                }
            }
            ArrayList<IDataInfo> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            log.warn("CFind problem", (Throwable)exception);
            ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>(0);
            return arrayList;
        }
        finally {
            this.releaseConnection();
        }
    }

    private ISeriesInfo createSeriesInfo(IStudyInfo iStudyInfo, Attributes attributes) {
        String string = attributes.getString(0x20000E);
        ISeriesInfo iSeriesInfo = diFact.createSeriesInfo(iStudyInfo, attributes, string);
        if (iStudyInfo != null) {
            iSeriesInfo.setSource(iStudyInfo.getSource());
        }
        return iSeriesInfo;
    }

    protected IObjectInfo createObjectInfo(ISeriesInfo iSeriesInfo, Attributes attributes) {
        String string = attributes.getString(524312);
        attributes.remove(524370);
        IObjectInfo iObjectInfo = diFact.createObjectInfo(iSeriesInfo, attributes, string);
        if (iSeriesInfo != null) {
            iObjectInfo.setSource(iSeriesInfo.getSource());
        }
        this.setLocations((ILoadableInfo)iObjectInfo, attributes);
        return iObjectInfo;
    }

    protected List<IDataInfo> getSeriesAndObjectInfo(IStudyInfo iStudyInfo, Attributes attributes) {
        try {
            this.checkConnection();
            Attributes attributes2 = attributes;
            if (this.cfind.isInitReturnTags()) {
                attributes2 = this.fillDataset(Level.Object, null);
                attributes2 = this.fillDataset(Level.Series, attributes2);
                attributes2.addAll(attributes);
            }
            List list = this.cfind.find(attributes2, QueryRetrieveLevel.Image);
            ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>(list.size());
            HashMap<String, Serie> hashMap = new HashMap<String, Serie>();
            for (Attributes attributes3 : list) {
                Attributes attributes4;
                String string = attributes3.getString(0x20000E);
                Serie serie = (Serie)hashMap.get(string);
                if (serie == null) {
                    attributes4 = new Attributes();
                    attributes4.addNotSelected(attributes3, this.notSeriesTags);
                    serie = new Serie(this.createSeriesInfo(iStudyInfo, attributes4, false));
                    arrayList.add((IDataInfo)serie.serie);
                    serie.toRemove = this.getObjectTags2Delete(attributes3);
                    serie.startSize = attributes3.size() - serie.toRemove.length;
                    hashMap.put(string, serie);
                }
                attributes4 = new Attributes(serie.startSize);
                attributes4.addNotSelected(attributes3, serie.toRemove);
                IObjectInfo iObjectInfo = this.createObjectInfo(serie.serie, attributes4);
                serie.serie.addChild((IDataInfo)iObjectInfo);
            }
            ArrayList<IDataInfo> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            log.warn("CFind problem", (Throwable)exception);
            List<IDataInfo> list = this.getSeriesInfo(iStudyInfo, attributes);
            return list;
        }
        finally {
            this.releaseConnection();
        }
    }

    private List<IDataInfo> getStudiesAndSeriesInfo(IPatientInfo iPatientInfo, Attributes attributes) {
        List<Attributes> list = this.getSearch(attributes, Level.Series);
        String string = iPatientInfo.getString(0x100021);
        if (list == null) {
            return this.getStudyInfo(iPatientInfo, attributes);
        }
        ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>();
        HashMap<String, IStudyInfo> hashMap = new HashMap<String, IStudyInfo>();
        for (Attributes attributes2 : list) {
            if (!CompareUtils.equals((Object)attributes2.getString(0x100021), (Object)string)) continue;
            String string2 = attributes2.getString(0x20000D);
            ISeriesInfo iSeriesInfo = null;
            IStudyInfo iStudyInfo = (IStudyInfo)hashMap.get(string2);
            if (iStudyInfo == null) {
                iStudyInfo = this.createStudyInfo(iPatientInfo, attributes2);
                if (iStudyInfo == null) continue;
                arrayList.add((IDataInfo)iStudyInfo);
                hashMap.put(string2, iStudyInfo);
            }
            iSeriesInfo = this.createSeriesInfo(iStudyInfo, attributes2, true);
            iStudyInfo.addChild((IDataInfo)iSeriesInfo);
        }
        return arrayList;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$agfa$pacs$data$shared$dicom$Level() {
        if ($SWITCH_TABLE$com$agfa$pacs$data$shared$dicom$Level != null) {
            return $SWITCH_TABLE$com$agfa$pacs$data$shared$dicom$Level;
        }
        int[] nArray = new int[Level.values().length];
        try {
            nArray[Level.Object.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Level.Patient.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Level.Series.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Level.Study.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$agfa$pacs$data$shared$dicom$Level = nArray;
        return nArray;
    }

    private static class Serie {
        public ISeriesInfo serie;
        public int[] toRemove;
        public int startSize;

        public Serie(ISeriesInfo iSeriesInfo) {
            this.serie = iSeriesInfo;
        }
    }
}

