/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicom.lw.datainfo;

import com.agfa.pacs.tools.Pattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;

public class DicomCFindUtilities {
    private static final int MAX_UID_VALUE_MATCHING_COUNT = 256;
    private static final int MAX_STUDY_SERIES_UID_VALUE_MATCHING_COUNT = 20;

    static List<Attributes> splitListOfUIDMatching(Attributes attributes) {
        List<Attributes> list = null;
        list = DicomCFindUtilities.splitListOfUIDMatchingForTag(attributes, 524312);
        if (list != null) {
            return list;
        }
        list = DicomCFindUtilities.splitListOfUIDMatchingForTag(attributes, 0x100020);
        if (list != null) {
            return list;
        }
        list = DicomCFindUtilities.splitListOfUIDMatchingForTag(attributes, 0x20000D);
        if (list != null) {
            return list;
        }
        list = DicomCFindUtilities.splitListOfUIDMatchingForTag(attributes, 0x20000E);
        if (list != null) {
            return list;
        }
        return Collections.singletonList(attributes);
    }

    private static List<Attributes> splitListOfUIDMatchingForTag(Attributes attributes, int n) {
        if (!attributes.contains(n)) {
            return null;
        }
        String[] stringArray = attributes.getStrings(n);
        if (stringArray.length == 1 && stringArray[0].contains("\\")) {
            stringArray = Pattern.BACK_SLASH.split(stringArray[0]);
        }
        if (stringArray == null) {
            return null;
        }
        int n2 = 256;
        if (n == 0x20000D || n == 0x20000E) {
            n2 = 20;
        }
        if (stringArray.length <= n2) {
            Attributes attributes2 = new Attributes(attributes);
            attributes2.setString(n, ElementDictionary.vrOf((int)n, null), stringArray);
            return Collections.singletonList(attributes2);
        }
        ArrayList<Attributes> arrayList = new ArrayList<Attributes>();
        int n3 = (int)Math.ceil((double)stringArray.length / (double)n2);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n4 * n2;
            int n6 = Math.min(stringArray.length, n5 + n2);
            Attributes attributes3 = new Attributes(attributes);
            attributes3.setString(n, ElementDictionary.vrOf((int)n, null), Arrays.copyOfRange(stringArray, n5, n6));
            arrayList.add(attributes3);
            ++n4;
        }
        return arrayList;
    }
}

