/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.print.mapper;

import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.hw.DicomDataRequester;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.hw.IDicomDataRequester;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationSizeMode;
import com.agfa.pacs.listtext.dicomobject.renderer.IDicomObjectRenderer;
import com.agfa.pacs.listtext.print.IDisplayFormat;
import com.agfa.pacs.listtext.print.mapper.IDicomEvaluation;
import com.agfa.pacs.listtext.print.mapper.MapperConfigurationContainer;
import com.agfa.pacs.listtext.print.mapper.MapperImageBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class MapperFilmBox
extends MapperConfigurationContainer {
    protected IDisplayFormat displayFormat;
    private List<MapperImageBox> imageBoxes;
    private String configurationInformation = null;

    public MapperFilmBox(IDisplayFormat iDisplayFormat, PresentationSizeMode presentationSizeMode) {
        this.displayFormat = iDisplayFormat;
        this.imageBoxes = new ArrayList<MapperImageBox>();
        int n = iDisplayFormat.getFilmBoxLayout().getNumberOfImageBoxes();
        int n2 = 0;
        while (n2 < n) {
            MapperImageBox mapperImageBox = new MapperImageBox(n2 + 1);
            mapperImageBox.setPresentationSizeMode(presentationSizeMode);
            this.imageBoxes.add(mapperImageBox);
            ++n2;
        }
    }

    public IDicomEvaluation getDicomEvaluation() {
        for (MapperImageBox mapperImageBox : this.imageBoxes) {
            if (mapperImageBox == null || mapperImageBox.getEvaluator() == null) continue;
            return mapperImageBox.getEvaluator();
        }
        return null;
    }

    public Attributes getOneDicomObject() {
        for (MapperImageBox mapperImageBox : this.imageBoxes) {
            if (mapperImageBox == null || mapperImageBox.getObjectInfo() == null) continue;
            return mapperImageBox.getObjectInfo().getAttributes();
        }
        return null;
    }

    public String getConfigurationInformation() {
        return this.configurationInformation;
    }

    public void setConfigurationInformation(String string) {
        this.configurationInformation = string;
    }

    public List<MapperImageBox> imageBoxes() {
        return this.imageBoxes;
    }

    public Collection<IObjectInfo> objects() {
        ArrayList<IObjectInfo> arrayList = new ArrayList<IObjectInfo>();
        for (MapperImageBox mapperImageBox : this.imageBoxes) {
            arrayList.add(mapperImageBox.getObjectInfo());
        }
        return arrayList;
    }

    public IDisplayFormat getDisplayFormat() {
        return this.displayFormat;
    }

    public void prepareRendering(boolean bl) {
        ArrayList<IDicomDataRequest> arrayList = new ArrayList<IDicomDataRequest>();
        IDicomDataRequester iDicomDataRequester = DicomDataRequester.getInstance();
        for (MapperImageBox mapperImageBox : this.imageBoxes) {
            if (mapperImageBox.getObjectInfo() == null) continue;
            if (mapperImageBox.getObjectInfo() instanceof IDicomObjectRenderer) {
                mapperImageBox.setDicomObjectRenderer((IDicomObjectRenderer)mapperImageBox.getObjectInfo());
                mapperImageBox.dicomDataAvailable(mapperImageBox.getObjectInfo().getSOPInstanceUID(), mapperImageBox.getObjectInfo().getAttributes(), true);
                continue;
            }
            IDicomDataRequest iDicomDataRequest = iDicomDataRequester.createDicomDataRequest(mapperImageBox.getObjectInfo());
            iDicomDataRequest.setListener((IDicomDataListener)mapperImageBox);
            arrayList.add(iDicomDataRequest);
        }
        iDicomDataRequester.addRequests(arrayList);
        if (bl) {
            for (IDicomDataRequest iDicomDataRequest : arrayList) {
                iDicomDataRequest.waitUntilFinished();
            }
        }
    }
}

