/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.data.shared.util.OverlayUtils;
import com.agfa.pacs.listtext.dicomobject.module.ps.OverlayPlane;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.OverlayFrame;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.StringOverlayDataFactory;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.List;

public class OverlayContainer {
    private static final ALogger log = ALogger.getLogger(OverlayContainer.class);
    private static final StringOverlayDataFactory odFact = new StringOverlayDataFactory();
    private final List<OverlayFrame> overlayFrames;
    private final String layer;
    private final int numFrames;
    private final int firstFrame;
    private final String label;
    private final String description;
    private final String subtype;
    private final String type;
    private final OverlayPlane overlayPlane;

    public OverlayContainer(OverlayPlane overlayPlane, String string) {
        this.layer = string;
        this.numFrames = overlayPlane.getNumberOfFramesInOverlay();
        this.firstFrame = overlayPlane.getImageFrameOrigin() - 1;
        this.label = overlayPlane.getOverlayLabel();
        this.description = overlayPlane.getOverlayDescription();
        this.subtype = overlayPlane.getOverlaySubtype();
        this.type = overlayPlane.getOverlayType();
        this.overlayPlane = overlayPlane;
        this.overlayFrames = new ArrayList<OverlayFrame>();
        int n = 0;
        while (n < this.numFrames) {
            OverlayFrame overlayFrame = new OverlayFrame(this, this.firstFrame + n);
            this.overlayFrames.add(overlayFrame);
            ++n;
        }
    }

    public OverlayFrame getOverlayFrame(String string, String string2, int n, IPixelDataFrame<?> iPixelDataFrame) {
        if (n - this.firstFrame < 0) {
            return null;
        }
        if (n - this.firstFrame >= this.numFrames) {
            return null;
        }
        return this.getFrame(string, string2, n - this.firstFrame, iPixelDataFrame);
    }

    private OverlayFrame getFrame(String string, String string2, int n, IPixelDataFrame<?> iPixelDataFrame) {
        OverlayFrame overlayFrame = this.overlayFrames.get(n);
        if (overlayFrame.getOverlayData() == null) {
            if (this.overlayPlane.getOverlayOrigin() == null || this.overlayPlane.getOverlayOrigin().length != 2) {
                log.error("Origin on the overlay plane incorrect or not specified.");
                return null;
            }
            int n2 = this.overlayPlane.getOverlayOrigin()[1] - 1;
            int n3 = this.overlayPlane.getOverlayOrigin()[0] - 1;
            int n4 = this.overlayPlane.getOverlayColumns();
            int n5 = this.overlayPlane.getOverlayRows();
            int n6 = this.overlayPlane.getOverlayBitPosition();
            if (n6 == 0) {
                CacheID cacheID = this.overlayPlane.getOverlayDataCacheID();
                if (cacheID != null) {
                    try {
                        overlayFrame.setOverlayData(n2, n3, n4, n5, odFact.createOverlayData(cacheID, n4, n5, n));
                    }
                    catch (Exception exception) {
                        log.error("Error while creating overlay data... Ommiting overlay...", (Throwable)exception);
                        overlayFrame = null;
                    }
                } else {
                    log.error("Expected bitmap overlay data not found. Omitting overlay.");
                    overlayFrame = null;
                }
            } else {
                if (iPixelDataFrame.getWidth() != n4 || iPixelDataFrame.getHeight() != n5) {
                    log.warn("Correcting embedded overlay bitmap inconsistency - image:" + iPixelDataFrame.getWidth() + "x" + iPixelDataFrame.getHeight() + " bitmap:" + n4 + "x" + n5);
                    n4 = iPixelDataFrame.getWidth();
                    n5 = iPixelDataFrame.getHeight();
                }
                overlayFrame.setOverlayData(n2, n3, n4, n5, odFact.createOverlayData(OverlayUtils.getOverlayCacheID((String)string, (String)string2, (int)n6), iPixelDataFrame, n6));
            }
        }
        return overlayFrame;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getType() {
        return this.type;
    }

    public String getLayer() {
        return this.layer;
    }

    public String getProviderUID() {
        return this.overlayPlane.getProviderUID();
    }

    public int getGroupTag() {
        return this.overlayPlane.getGroupTag();
    }
}

