/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation.overlay;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.data.shared.util.OverlayUtils;
import com.agfa.pacs.logging.ALogger;
import java.util.Arrays;

public class BitmapOverlayHolder
implements AutoCloseable {
    private CacheID id;
    private int offset;
    private int length;
    private byte[] data;

    BitmapOverlayHolder(CacheID cacheID, int n, int n2) {
        this.id = cacheID;
        this.offset = n;
        this.length = n2;
    }

    BitmapOverlayHolder(byte[] byArray) {
        this.data = byArray;
        this.offset = 0;
        this.length = byArray.length;
    }

    synchronized boolean isValid() {
        return this.id != null || this.data != null;
    }

    public synchronized byte[] toBytes() {
        if (this.data == null) {
            ByteArrayContainer byteArrayContainer = OverlayUtils.getBitmapOverlay((CacheID)this.id);
            try {
                if (this.isArrayPart()) {
                    if (byteArrayContainer.length < this.offset + this.length) {
                        ALogger.getLogger(this.getClass()).error("Overlay data not large enough (expected: " + (this.offset + this.length) + " or larger; was: " + byteArrayContainer.length + ')');
                        this.data = new byte[0];
                    } else {
                        this.data = Arrays.copyOfRange(byteArrayContainer.data, byteArrayContainer.offset + this.offset, byteArrayContainer.offset + this.offset + this.length);
                    }
                } else {
                    this.data = Arrays.copyOfRange(byteArrayContainer.data, byteArrayContainer.offset, byteArrayContainer.offset + byteArrayContainer.length);
                }
            }
            finally {
                DataCacheProviderFactory.getPersistentCache().releaseReference(this.id);
            }
        }
        return this.data;
    }

    @Override
    public synchronized void close() {
        if (this.data != null) {
            this.data = null;
        }
    }

    private boolean isArrayPart() {
        return this.offset >= 0 && this.length >= 0;
    }
}

