/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation.overlay;

import com.agfa.pacs.data.shared.BitReader;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.AbstractOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.BitmapOverlayHolder;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.ByteOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.GraphicsOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IntOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.ShortOverlayRenderer;
import java.awt.Graphics;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;

class PackedOverlayData
implements IOverlayData {
    private final byte[] data;
    private final int width;
    private final int height;
    private final int offset;

    PackedOverlayData(byte[] byArray, int n, int n2, int n3) {
        this.data = byArray;
        this.width = n2;
        this.height = n3;
        this.offset = n;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final void renderTo(int n, int n2, Graphics graphics) {
        GraphicsOverlayRenderer graphicsOverlayRenderer = new GraphicsOverlayRenderer(n, n2, graphics);
        BitReader bitReader = new BitReader(this.data, this.offset);
        int n3 = 0;
        while (n3 < this.height) {
            byte[] byArray = bitReader.getBits(this.width);
            graphicsOverlayRenderer.drawLine(byArray, this.width);
            ++n3;
        }
    }

    @Override
    public final void renderTo(int n, int n2, Object object, int n3, int n4) {
        AbstractOverlayRenderer abstractOverlayRenderer = null;
        if (object instanceof DataBufferByte) {
            abstractOverlayRenderer = new ByteOverlayRenderer(n, n2, ((DataBufferByte)object).getData(), n3, (byte)n4);
        }
        if (object instanceof DataBufferShort) {
            abstractOverlayRenderer = new ShortOverlayRenderer(n, n2, ((DataBufferShort)object).getData(), n3, (short)n4);
        }
        if (object instanceof DataBufferUShort) {
            abstractOverlayRenderer = new ShortOverlayRenderer(n, n2, ((DataBufferUShort)object).getData(), n3, (short)n4);
        }
        if (object instanceof DataBufferInt) {
            abstractOverlayRenderer = new IntOverlayRenderer(n, n2, ((DataBufferInt)object).getData(), n3, n4);
        }
        if (object instanceof byte[]) {
            abstractOverlayRenderer = new ByteOverlayRenderer(n, n2, (byte[])object, n3, (byte)n4);
        }
        if (object instanceof short[]) {
            abstractOverlayRenderer = new ShortOverlayRenderer(n, n2, (short[])object, n3, (byte)n4);
        }
        if (object instanceof int[]) {
            abstractOverlayRenderer = new IntOverlayRenderer(n, n2, (int[])object, n3, n4);
        }
        BitReader bitReader = new BitReader(this.data, this.offset);
        if (abstractOverlayRenderer != null) {
            int n5 = 0;
            while (n5 < this.height) {
                byte[] byArray = bitReader.getBits(this.width);
                abstractOverlayRenderer.drawLine(byArray, this.width);
                ++n5;
            }
        }
    }

    @Override
    public final BitmapOverlayHolder toPackedBits() {
        return new BitmapOverlayHolder(this.data);
    }
}

