/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation.overlay;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.data.shared.BitReader;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.EmptyOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayDataWriter;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.PaddedOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.PaddedOverlayDataWriter;
import com.agfa.pacs.logging.ALogger;
import java.io.ByteArrayOutputStream;

public class PaddedOverlayDataFactory {
    private static final ALogger logger = ALogger.getLogger(PaddedOverlayDataFactory.class);

    public IOverlayData createOverlayData(CacheID cacheID, int n, int n2, int n3) {
        try {
            byte[] byArray = DataCacheProviderFactory.getPersistentCache().referencePersistentBytes(cacheID);
            BitReader bitReader = new BitReader(byArray, n * n2 * n3);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n4 = 0;
            while (n4 < n2) {
                byte[] byArray2 = bitReader.getBits(n);
                byteArrayOutputStream.write(byArray2);
                ++n4;
            }
            PaddedOverlayData paddedOverlayData = new PaddedOverlayData(byteArrayOutputStream.toByteArray(), n, n2);
            return paddedOverlayData;
        }
        catch (Exception exception) {
            logger.error("Error creating overlay data - returning empty instance", (Throwable)exception);
            EmptyOverlayData emptyOverlayData = new EmptyOverlayData();
            return emptyOverlayData;
        }
        finally {
            DataCacheProviderFactory.getPersistentCache().releaseReference(cacheID);
        }
    }

    public IOverlayDataWriter createOverlayDataWriter() {
        return new PaddedOverlayDataWriter();
    }
}

