/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation.overlay;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.data.shared.overlay.BitmapOverlayShrink;
import com.agfa.pacs.data.shared.util.OverlayUtils;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.AbstractOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.BitmapOverlayHolder;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.ByteOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.GraphicsOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IntOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.ShortOverlayRenderer;
import java.awt.Graphics;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.util.Arrays;

public class StringOverlayData
implements IOverlayData {
    private final CacheID id;
    private final int width;
    private final int height;
    private final int frameIndex;

    public StringOverlayData(CacheID cacheID, int n, int n2) {
        this(cacheID, n, n2, 0);
    }

    public StringOverlayData(CacheID cacheID, int n, int n2, int n3) {
        this.id = cacheID;
        this.width = n;
        this.height = n2;
        this.frameIndex = n3;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void renderTo(int n, int n2, Graphics graphics) {
        BitmapOverlayShrink bitmapOverlayShrink = new BitmapOverlayShrink(this.height, this.width, new int[2]);
        GraphicsOverlayRenderer graphicsOverlayRenderer = new GraphicsOverlayRenderer(n, n2, graphics);
        try {
            ByteArrayContainer byteArrayContainer = OverlayUtils.getBitmapOverlay((CacheID)this.id);
            if (byteArrayContainer.offset != 0) {
                throw new UnsupportedOperationException();
            }
            int n3 = 0;
            while (n3 < this.height) {
                byte[] byArray = bitmapOverlayShrink.getPaddedLine(byteArrayContainer.data, this.frameIndex, n3, this.width, this.height);
                graphicsOverlayRenderer.drawLine(byArray, this.width);
                ++n3;
            }
        }
        finally {
            DataCacheProviderFactory.getPersistentCache().releaseReference(this.id);
        }
    }

    @Override
    public void renderTo(int n, int n2, Object object, int n3, int n4) {
        AbstractOverlayRenderer abstractOverlayRenderer = null;
        if (object instanceof DataBufferByte) {
            abstractOverlayRenderer = new ByteOverlayRenderer(n, n2, ((DataBufferByte)object).getData(), n3, (byte)n4);
        }
        if (object instanceof DataBufferShort) {
            abstractOverlayRenderer = new ShortOverlayRenderer(n, n2, ((DataBufferShort)object).getData(), n3, (short)n4);
        }
        if (object instanceof DataBufferUShort) {
            abstractOverlayRenderer = new ShortOverlayRenderer(n, n2, ((DataBufferUShort)object).getData(), n3, (short)n4);
        }
        if (object instanceof DataBufferInt) {
            abstractOverlayRenderer = new IntOverlayRenderer(n, n2, ((DataBufferInt)object).getData(), n3, n4);
        }
        if (object instanceof byte[]) {
            abstractOverlayRenderer = new ByteOverlayRenderer(n, n2, (byte[])object, n3, (byte)n4);
        }
        if (object instanceof short[]) {
            abstractOverlayRenderer = new ShortOverlayRenderer(n, n2, (short[])object, n3, (byte)n4);
        }
        if (object instanceof int[]) {
            abstractOverlayRenderer = new IntOverlayRenderer(n, n2, (int[])object, n3, n4);
        }
        int n5 = this.width / 8;
        if (this.width % 8 > 0) {
            ++n5;
        }
        if (abstractOverlayRenderer != null) {
            try {
                ByteArrayContainer byteArrayContainer = OverlayUtils.getBitmapOverlay((CacheID)this.id);
                int n6 = this.getFrameSize() * this.frameIndex;
                int n7 = 0;
                while (n7 < this.height) {
                    int n8 = n6 + n7 * this.width / 8;
                    byte[] byArray = Arrays.copyOfRange(byteArrayContainer.data, byteArrayContainer.offset + n8, n8 + n5);
                    abstractOverlayRenderer.drawLine(byArray, this.width);
                    ++n7;
                }
            }
            finally {
                DataCacheProviderFactory.getPersistentCache().releaseReference(this.id);
            }
        }
    }

    private int getFrameSize() {
        return this.width * this.height + 7 >> 3;
    }

    @Override
    public BitmapOverlayHolder toPackedBits() {
        int n = this.getFrameSize();
        int n2 = n * this.frameIndex;
        return new BitmapOverlayHolder(this.id, n2, n);
    }
}

