/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation.overlay;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.data.shared.util.OverlayUtils;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.BitmapOverlayHolder;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.EmptyOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.InvalidStringOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.StringOverlayData;
import com.agfa.pacs.logging.ALogger;

public class StringOverlayDataFactory {
    private static final ALogger log = ALogger.getLogger(StringOverlayDataFactory.class);

    public IOverlayData createOverlayData(CacheID cacheID, int n, int n2, int n3) {
        IOverlayData iOverlayData = new StringOverlayData(cacheID, n, n2, n3);
        Throwable throwable = null;
        Object var7_8 = null;
        try (BitmapOverlayHolder bitmapOverlayHolder = iOverlayData.toPackedBits();){
            if (!bitmapOverlayHolder.isValid()) {
                iOverlayData = InvalidStringOverlayData.INSTANCE;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return iOverlayData;
    }

    public IOverlayData createOverlayData(CacheID cacheID, IPixelDataFrame<?> iPixelDataFrame, int n) {
        try {
            int n2;
            int n3;
            byte by;
            byte by2;
            Object[] objectArray;
            int n4;
            Object object = iPixelDataFrame.getOriginalData();
            int n5 = iPixelDataFrame.getWidth();
            int n6 = iPixelDataFrame.getHeight();
            byte[] byArray = null;
            if (object instanceof byte[]) {
                n4 = 0;
                objectArray = (byte[])object;
                byArray = new byte[n5 * n6 + 7 >> 3];
                by2 = 0;
                by = 0;
                n3 = 0;
                while (n3 < byArray.length) {
                    n2 = 7;
                    while (n2 >= 0 && n4 + n2 < objectArray.length) {
                        by2 = objectArray[n4 + n2];
                        by = (byte)(by << 1 | by2 >> n & 1);
                        --n2;
                    }
                    n4 += 8;
                    byArray[n3] = by;
                    ++n3;
                }
                byArray[byArray.length - 1] = (byte)(byArray[byArray.length - 1] << (8 - n5 * n6 % 8) % 8);
            }
            if (object instanceof short[]) {
                n4 = 0;
                objectArray = (short[])object;
                byArray = new byte[n5 * n6 + 7 >> 3];
                by2 = 0;
                by = 0;
                n3 = 0;
                while (n3 < byArray.length) {
                    n2 = 7;
                    while (n2 >= 0 && n4 + n2 < objectArray.length) {
                        by2 = objectArray[n4 + n2];
                        by = (byte)(by << 1 | by2 >> n & 1);
                        --n2;
                    }
                    n4 += 8;
                    byArray[n3] = by;
                    ++n3;
                }
                byArray[byArray.length - 1] = (byte)(byArray[byArray.length - 1] << (8 - n5 * n6 % 8) % 8);
            }
            iPixelDataFrame.releaseOriginalData(object);
            OverlayUtils.putBitmapOverlay((CacheID)cacheID, byArray);
            return new StringOverlayData(cacheID, n5, n6);
        }
        catch (Exception exception) {
            log.error("Overlay error", (Throwable)exception);
            return new EmptyOverlayData();
        }
    }
}

