/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentationstate;

import com.agfa.pacs.listtext.dicomobject.iod.ps.SoftcopyPresentationStateInformationObject;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationStateProvider;
import com.agfa.pacs.listtext.dicomobject.presentation.SoftcopyPresentationStateProvider;
import com.agfa.pacs.listtext.dicomobject.presentationstate.ExternalPresentationStateInfo;
import com.agfa.pacs.listtext.dicomobject.presentationstate.IPresentationStateInfo;
import com.agfa.pacs.listtext.dicomobject.presentationstate.ImagePresentationStateInfo;
import com.agfa.pacs.tools.CompareUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class FramePresentationStateProviderContainer {
    private Collection<IPresentationStateInfo> psInfos = new TreeSet<IPresentationStateInfo>(new PresentationStateInfoSorter());

    public synchronized IPresentationStateInfo add(SoftcopyPresentationStateInformationObject softcopyPresentationStateInformationObject, boolean bl) {
        return this.add(softcopyPresentationStateInformationObject, bl, -1);
    }

    public synchronized IPresentationStateInfo add(SoftcopyPresentationStateInformationObject softcopyPresentationStateInformationObject, boolean bl, int n) {
        SoftcopyPresentationStateProvider softcopyPresentationStateProvider = new SoftcopyPresentationStateProvider(softcopyPresentationStateInformationObject);
        ExternalPresentationStateInfo externalPresentationStateInfo = (ExternalPresentationStateInfo)this.getPresentationStateInfo(softcopyPresentationStateProvider);
        if (externalPresentationStateInfo == null) {
            externalPresentationStateInfo = new ExternalPresentationStateInfo(bl, n);
            externalPresentationStateInfo.add(softcopyPresentationStateProvider);
            this.psInfos.add(externalPresentationStateInfo);
        } else {
            externalPresentationStateInfo.add(softcopyPresentationStateProvider);
        }
        return externalPresentationStateInfo;
    }

    public synchronized void removeTemporaryPresentationStates(int n) {
        if (n <= 0) {
            return;
        }
        Iterator<IPresentationStateInfo> iterator = this.psInfos.iterator();
        while (iterator.hasNext()) {
            ExternalPresentationStateInfo externalPresentationStateInfo;
            IPresentationStateInfo iPresentationStateInfo = iterator.next();
            if (!(iPresentationStateInfo instanceof ExternalPresentationStateInfo) || n != (externalPresentationStateInfo = (ExternalPresentationStateInfo)iPresentationStateInfo).getDisplaySetID() || !externalPresentationStateInfo.isTemporary()) continue;
            iterator.remove();
        }
    }

    public synchronized boolean remove(IPresentationStateInfo iPresentationStateInfo) {
        return this.psInfos.remove(iPresentationStateInfo);
    }

    public boolean isEmpty() {
        return this.psInfos.isEmpty();
    }

    private IPresentationStateInfo getPresentationStateInfo(IFramePresentationStateProvider iFramePresentationStateProvider) {
        for (IPresentationStateInfo iPresentationStateInfo : this.psInfos) {
            if (!iPresentationStateInfo.contains(iFramePresentationStateProvider.getProviderUID())) continue;
            return iPresentationStateInfo;
        }
        return null;
    }

    public synchronized boolean isSeriesReferencedByExtPresState(String string) {
        for (IPresentationStateInfo iPresentationStateInfo : this.psInfos) {
            if (iPresentationStateInfo.isExternal() && iPresentationStateInfo.isTemporary() || !iPresentationStateInfo.containsSeries(string)) continue;
            return true;
        }
        return false;
    }

    public synchronized List<IPresentationStateInfo> getPresentationStateInfo(String string, int n) {
        ArrayList<IPresentationStateInfo> arrayList = new ArrayList<IPresentationStateInfo>();
        for (IPresentationStateInfo iPresentationStateInfo : this.psInfos) {
            if (!iPresentationStateInfo.hasFramePresentationState(string, n)) continue;
            arrayList.add(iPresentationStateInfo);
        }
        arrayList.add(ImagePresentationStateInfo.staticInstance);
        return arrayList;
    }

    public synchronized List<IPresentationStateInfo> getAllPresentationStateInfos() {
        return new ArrayList<IPresentationStateInfo>(this.psInfos);
    }

    private static class PresentationStateInfoSorter
    implements Comparator<IPresentationStateInfo> {
        private PresentationStateInfoSorter() {
        }

        @Override
        public int compare(IPresentationStateInfo iPresentationStateInfo, IPresentationStateInfo iPresentationStateInfo2) {
            Date date = iPresentationStateInfo.getCreationDateTime();
            Date date2 = iPresentationStateInfo2.getCreationDateTime();
            if (date == null && date2 == null) {
                return 0;
            }
            if (date == null) {
                return 1;
            }
            if (date2 == null) {
                return -1;
            }
            int n = date2.compareTo(date);
            if (n == 0) {
                n = CompareUtils.compareAdvanced((Comparable)((Object)iPresentationStateInfo.getUID()), (Comparable)((Object)iPresentationStateInfo2.getUID()));
            }
            return n;
        }
    }
}

