/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.renderer;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.listtext.dicomobject.renderer.IDicomObjectRenderer;
import com.agfa.pacs.listtext.dicomobject.renderer.IDicomObjectRendererProvider;
import org.dcm4che3.data.Attributes;

public abstract class DicomObjectRendererFactory {
    private static DicomObjectRendererFactory implementation;

    public static synchronized DicomObjectRendererFactory getInstance() {
        if (implementation == null) {
            DicomObjectRendererFactory.initialize();
        }
        return implementation;
    }

    public IDicomObjectRenderer createDicomObjectRenderer(Attributes attributes, IPixelDataFrame<?> iPixelDataFrame, int n, Object object) {
        return implementation.getDicomObjectRendererProviderInt().createDicomObjectRenderer(attributes, iPixelDataFrame, n, object);
    }

    protected abstract IDicomObjectRendererProvider getDicomObjectRendererProviderInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)DicomObjectRendererFactory.class.getName()));
            implementation = (DicomObjectRendererFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException2) {
            reflectiveOperationException = reflectiveOperationException2;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + DicomObjectRendererFactory.class.getName(), reflectiveOperationException);
        }
    }
}

