/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.integration;

import com.agfa.integration.IDesktopIntegrationListener;
import com.agfa.integration.IDesktopIntegrationProvider;
import com.agfa.integration.IIntegrationFramework;
import com.agfa.integration.ext.AbstractActor;
import com.agfa.integration.ext.AbstractTransformer;
import com.agfa.integration.ext.IActor;
import com.agfa.integration.ext.IActorDispatcher;
import com.agfa.integration.ext.IFrameworkDispatcher;
import com.agfa.integration.ext.ITransformer;
import com.agfa.integration.impl.ActorDispatcher;
import com.agfa.integration.impl.ActorInfo;
import com.agfa.integration.impl.IntegrationFramework;
import com.agfa.integration.impl.NotificationSubDispatcher;
import com.agfa.integration.impl.TransformerInfo;
import com.agfa.integration.level23.ILevelIntegration;
import com.agfa.integration.level23.LevelIntegrationInformation;
import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.easymock.EasyMock;
import org.easymock.IAnswer;

public class IntegrationTestSupport {
    protected static final int INBOUND_EVENT = 1;
    protected static final int OUTBOUND_EVENT = 2;

    protected static class DefaultTransformer
    extends AbstractTransformer {
        protected IActor actor;

        @Override
        public void init(IFrameworkDispatcher iFrameworkDispatcher, IActor iActor) {
            this.actor = iActor;
            super.init(iFrameworkDispatcher, this.actor);
        }
    }

    protected static class TestActor
    extends AbstractActor {
        protected IActorDispatcher dispatcher;

        @Override
        public void start(IActorDispatcher iActorDispatcher, Properties properties) {
            this.dispatcher = iActorDispatcher;
            super.start(this.dispatcher);
        }

        @Override
        public void stop() {
        }

        @Override
        public Properties initConfiguration() {
            return null;
        }

        @Override
        public String[] getPropertyList() {
            return null;
        }

        @Override
        public String[] getDefaultValues() {
            return null;
        }

        public IActorDispatcher getDispatcher() {
            return this.dispatcher;
        }
    }

    protected static class TestIntegrationFrameWorkBuilder {
        protected List<ActorInfo> actors = new ArrayList<ActorInfo>();
        protected List<TransformerInfo> transformers = new ArrayList<TransformerInfo>();
        protected Map<String, LevelIntegrationInformation> levels = new HashMap<String, LevelIntegrationInformation>();
        protected IDesktopIntegrationProvider provider;
        protected IDesktopIntegrationListener listener;
        protected IEventEngine engine;
        protected Set<IEventListener> eventListeners = new HashSet<IEventListener>();

        public void actor(IActor iActor, String string, boolean bl) {
            this.actors.add(new ActorInfo(iActor, string, bl));
        }

        public void transformer(ITransformer iTransformer, String string, String string2, int n) {
            this.transformers.add(new TransformerInfo(iTransformer, string, string2, n));
        }

        public <T extends ILevelIntegration> void levelIntegration(Class<?> clazz, T t, int n) {
            this.levels.put(clazz.getSimpleName(), new LevelIntegrationInformation(t, n));
        }

        public IIntegrationFramework create() {
            IntegrationFramework integrationFramework = new IntegrationFramework(){

                @Override
                protected ActorInfo[] getActors() {
                    return TestIntegrationFrameWorkBuilder.this.actors.toArray(new ActorInfo[0]);
                }

                @Override
                protected TransformerInfo[] getTransformers() {
                    return TestIntegrationFrameWorkBuilder.this.transformers.toArray(new TransformerInfo[0]);
                }

                @Override
                protected Map<String, LevelIntegrationInformation> getLevelIntegrations() {
                    return new HashMap<String, LevelIntegrationInformation>(TestIntegrationFrameWorkBuilder.this.levels);
                }

                @Override
                protected TransformerInfo[] getSimpleActors() {
                    return new TransformerInfo[0];
                }

                @Override
                public synchronized void start(boolean bl) {
                    for (ActorInfo actorInfo : TestIntegrationFrameWorkBuilder.this.actors) {
                        EasyMock.expect((Object)TestIntegrationFrameWorkBuilder.this.provider.isActorActive(actorInfo.name)).andReturn((Object)true).anyTimes();
                    }
                    EasyMock.replay((Object[])new Object[]{TestIntegrationFrameWorkBuilder.this.provider, TestIntegrationFrameWorkBuilder.this.listener, TestIntegrationFrameWorkBuilder.this.engine});
                    super.start(bl, TestIntegrationFrameWorkBuilder.this.provider, TestIntegrationFrameWorkBuilder.this.engine);
                }

                @Override
                protected ActorDispatcher createActorDispatcher(boolean bl) {
                    return new ActorDispatcher(this, bl){

                        @Override
                        protected ActorInfo[] getActors() {
                            return (this).TestIntegrationFrameWorkBuilder.this.actors.toArray(new ActorInfo[0]);
                        }

                        @Override
                        protected TransformerInfo[] getTransformers() {
                            return (this).TestIntegrationFrameWorkBuilder.this.transformers.toArray(new TransformerInfo[0]);
                        }

                        @Override
                        protected TransformerInfo[] getSimpleActors() {
                            return new TransformerInfo[0];
                        }
                    };
                }

                @Override
                protected NotificationSubDispatcher createNotificationDispatcher(List<TransformerInfo> list) {
                    return new NotificationSubDispatcher(this, list){

                        @Override
                        protected int getEventId() {
                            return 2;
                        }
                    };
                }

                @Override
                protected int getMessageEventId() {
                    return 1;
                }

                @Override
                protected int getNotificationEventId() {
                    return 2;
                }
            };
            EasyMock.expect((Object)this.engine.createListenerProvider((IEventListener)integrationFramework)).andReturn(null).anyTimes();
            return integrationFramework;
        }

        public TestIntegrationFrameWorkBuilder() {
            this.engine = (IEventEngine)EasyMock.createNiceMock(IEventEngine.class);
            this.listener = (IDesktopIntegrationListener)EasyMock.createNiceMock(IDesktopIntegrationListener.class);
            this.provider = (IDesktopIntegrationProvider)EasyMock.createNiceMock(IDesktopIntegrationProvider.class);
            EasyMock.expect((Object)this.provider.getListener()).andReturn((Object)this.listener).anyTimes();
            EasyMock.expect((Object)this.provider.isActorActive((String)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
            EasyMock.expect((Object)this.engine.createInternalEvent(EasyMock.eq((int)2), (IEventListenerProvider)EasyMock.anyObject(), EasyMock.anyObject(), (Serializable)EasyMock.anyObject(), (ActionInfo)EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<IEvent>(){

                public IEvent answer() throws Throwable {
                    Object[] objectArray = EasyMock.getCurrentArguments();
                    Iterator iterator = ((IEventListenerProvider)objectArray[1]).iterator(null, null);
                    while (iterator.hasNext()) {
                        TestIntegrationFrameWorkBuilder.this.eventListeners.add((IEventListener)iterator.next());
                    }
                    IEvent iEvent = (IEvent)EasyMock.createNiceMock(IEvent.class);
                    EasyMock.expect((Object)iEvent.getEventID()).andReturn((Object)2).anyTimes();
                    EasyMock.expect((Object)iEvent.getPayload()).andReturn(objectArray[3]).anyTimes();
                    EasyMock.replay((Object[])new Object[]{iEvent});
                    return iEvent;
                }
            }).anyTimes();
            EasyMock.expect((Object)this.engine.createListenerProvider((IEventListener)EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<IEventListenerProvider<IEventListener>>(){

                public IEventListenerProvider<IEventListener> answer() throws Throwable {
                    TestIntegrationFrameWorkBuilder.this.eventListeners.add((IEventListener)EasyMock.getCurrentArguments()[0]);
                    return null;
                }
            }).anyTimes();
            this.engine.sendEvent((IEvent)EasyMock.anyObject());
            EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

                public Object answer() throws Throwable {
                    for (IEventListener iEventListener : TestIntegrationFrameWorkBuilder.this.eventListeners) {
                        iEventListener.handleEvent((IEvent)EasyMock.getCurrentArguments()[0]);
                    }
                    return null;
                }
            }).anyTimes();
        }
    }
}

