/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.integration.impl;

import com.agfa.integration.IDesktopIntegrationFunctions;
import com.agfa.integration.IDesktopIntegrationListener;
import com.agfa.integration.IDesktopIntegrationProvider;
import com.agfa.integration.IIntegrationFramework;
import com.agfa.integration.IScriptInterpreter;
import com.agfa.integration.ObjectID;
import com.agfa.integration.ext.EventConst;
import com.agfa.integration.ext.ExtendedFuture;
import com.agfa.integration.ext.IActor;
import com.agfa.integration.ext.ICommandMessage;
import com.agfa.integration.ext.INotificationMessage;
import com.agfa.integration.ext.ISimpleActor;
import com.agfa.integration.ext.IStatus;
import com.agfa.integration.ext.ITransformer;
import com.agfa.integration.impl.ActorDispatcher;
import com.agfa.integration.impl.ActorInfo;
import com.agfa.integration.impl.DesktopIntegrationDelegate;
import com.agfa.integration.impl.NotificationSubDispatcher;
import com.agfa.integration.impl.PriorityDesktopIntegrationProvider;
import com.agfa.integration.impl.ScriptProxy;
import com.agfa.integration.impl.Status;
import com.agfa.integration.impl.TransformerInfo;
import com.agfa.integration.impl.factory.ActorFactory;
import com.agfa.integration.impl.factory.Level23IntegrationFactory;
import com.agfa.integration.impl.factory.ScriptHelperFactory;
import com.agfa.integration.impl.factory.ScriptInterpreterFactory;
import com.agfa.integration.impl.factory.SimpleActorFactory;
import com.agfa.integration.impl.factory.TransformerFactory;
import com.agfa.integration.level23.ILevelIntegration;
import com.agfa.integration.level23.LevelIntegrationInformation;
import com.agfa.integration.messages.AddToList;
import com.agfa.integration.messages.ClearDisplay;
import com.agfa.integration.messages.ClearList;
import com.agfa.integration.messages.EnablePart;
import com.agfa.integration.messages.ExecuteScript;
import com.agfa.integration.messages.Exit;
import com.agfa.integration.messages.FindStudy;
import com.agfa.integration.messages.GetStudiesInDisplay;
import com.agfa.integration.messages.Hide;
import com.agfa.integration.messages.PerformDictation;
import com.agfa.integration.messages.PerformLogin;
import com.agfa.integration.messages.PerformLogout;
import com.agfa.integration.messages.RemoveFromList;
import com.agfa.integration.messages.RequestFocus;
import com.agfa.integration.messages.Restore;
import com.agfa.integration.messages.SetStatus;
import com.agfa.integration.messages.SetWindowState;
import com.agfa.integration.messages.ShowMessage;
import com.agfa.integration.messages.ShowStudy;
import com.agfa.integration.notifications.DictationChanged;
import com.agfa.integration.notifications.ImagingCleared;
import com.agfa.integration.notifications.ListCleared;
import com.agfa.integration.notifications.Login;
import com.agfa.integration.notifications.Logout;
import com.agfa.integration.notifications.PatientRemoved;
import com.agfa.integration.notifications.SessionStored;
import com.agfa.integration.notifications.StatusChanged;
import com.agfa.integration.notifications.StudyChanged;
import com.agfa.integration.notifications.StudyRemoved;
import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.event.IEventListener;
import com.agfa.pacs.event.IEventListenerProvider;
import com.agfa.pacs.event.IListenerSynchronization;
import com.agfa.pacs.event.ListenerSynchronizationFactory;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.EnviromentVariableReader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class IntegrationFramework
extends DesktopIntegrationDelegate
implements IIntegrationFramework,
IEventListener {
    private static final ALogger log = ALogger.getLogger(IntegrationFramework.class);
    private IListenerSynchronization sync;
    private IEventEngine engine = null;
    private IDesktopIntegrationListener integrator = null;
    private IDesktopIntegrationProvider provider = null;
    private Map<String, LevelIntegrationInformation> levelIntegrationInterfaces = null;
    private IEventListenerProvider<IEventListener> inQueue;
    private IEventListenerProvider<IEventListener> outQueue;
    private List<NotificationSubDispatcher> transformers = new ArrayList<NotificationSubDispatcher>();
    private volatile State actualState = State.NotStarted;
    private ActorDispatcher adispatcher = null;
    private HashMap<String, Method> methodMap = new HashMap();
    private boolean isHidden = false;
    private ExtendedFuture<IStatus> loginTask = null;

    @Override
    public boolean isActorRunning(String string) {
        if (this.actualState == State.NotStarted) {
            return false;
        }
        return this.adispatcher.isActorRunning(string);
    }

    @Override
    public boolean startActor(String string) {
        return this.startActor(string, null);
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getEnviromentVariable(String string) {
        return EnviromentVariableReader.getEnviromentVariable((String)string);
    }

    @Override
    public boolean startActor(String string, Properties properties) {
        TransformerInfo[] transformerInfoArray;
        TransformerInfo[] transformerInfoArray2 = this.getTransformers();
        ActorInfo[] actorInfoArray = this.getActors();
        if (this.adispatcher.isActorRunning(string) && properties == null) {
            return true;
        }
        if (properties == null) {
            properties = this.provider.getActorProperties(string);
        }
        ArrayList<TransformerInfo> arrayList = new ArrayList<TransformerInfo>();
        ActorInfo actorInfo = null;
        TransformerInfo[] transformerInfoArray3 = transformerInfoArray2;
        int n = transformerInfoArray2.length;
        int n2 = 0;
        while (n2 < n) {
            transformerInfoArray = transformerInfoArray3[n2];
            if (transformerInfoArray.forActor.equals(string) && (actorInfo = IntegrationFramework.findActor(actorInfoArray, transformerInfoArray.forActor)) != null) {
                arrayList.add((TransformerInfo)transformerInfoArray);
            }
            ++n2;
        }
        if (!arrayList.isEmpty()) {
            this.transformers.add(new NotificationSubDispatcher(this, arrayList));
            return this.adispatcher.startActor(actorInfo, properties);
        }
        TransformerInfo[] transformerInfoArray4 = transformerInfoArray = SimpleActorFactory.getActors();
        int n3 = transformerInfoArray.length;
        n = 0;
        while (n < n3) {
            TransformerInfo transformerInfo = transformerInfoArray4[n];
            if (transformerInfo.name.equals(string)) {
                this.transformers.add(this.createNotificationDispatcher(Collections.singletonList(transformerInfo)));
                return this.adispatcher.startActor((ISimpleActor)transformerInfo.transformer, string, properties);
            }
            ++n;
        }
        return true;
    }

    @Override
    public boolean stopActor(String string) {
        Object object;
        TransformerInfo[] transformerInfoArray = this.getTransformers();
        ActorInfo[] actorInfoArray = this.getActors();
        ActorInfo actorInfo = null;
        TransformerInfo[] transformerInfoArray2 = transformerInfoArray;
        int n = transformerInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = transformerInfoArray2[n2];
            if (!object.forActor.equals(string) || (actorInfo = IntegrationFramework.findActor(actorInfoArray, object.forActor)) == null) {
                // empty if block
            }
            ++n2;
        }
        if (actorInfo != null) {
            this.removeSubDispatcher(actorInfo.name);
            return this.adispatcher.stopActor(actorInfo);
        }
        Object object2 = object = SimpleActorFactory.getActors();
        int n3 = ((TransformerInfo[])object).length;
        n = 0;
        while (n < n3) {
            TransformerInfo transformerInfo = object2[n];
            if (transformerInfo.name.equals(string)) {
                this.removeSubDispatcher(transformerInfo.name);
                return this.adispatcher.stopActor((ISimpleActor)transformerInfo.transformer, string);
            }
            ++n;
        }
        return true;
    }

    private void removeSubDispatcher(String string) {
        Iterator<NotificationSubDispatcher> iterator = this.transformers.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getActorName().equals(string)) continue;
            iterator.remove();
            return;
        }
    }

    private void initIntegrator() {
        Class<?>[] classArray;
        int n;
        int n2;
        String[] stringArray;
        Object object2;
        this.integrator = this.provider.getListener();
        HashSet<Object> hashSet = new HashSet<Object>();
        TransformerInfo[] transformerInfoArray = this.getTransformers();
        Object[] objectArray = transformerInfoArray;
        int n3 = transformerInfoArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object2 = objectArray[n4];
            stringArray = ((TransformerInfo)object2).transformer.getAdditionalCommands();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                classArray = stringArray[n];
                hashSet.add(classArray);
                ++n;
            }
            ++n4;
        }
        objectArray = this.getSimpleActors();
        n3 = objectArray.length;
        n4 = 0;
        while (n4 < n3) {
            object2 = objectArray[n4];
            stringArray = ((TransformerInfo)object2).transformer.getAdditionalCommands();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                classArray = stringArray[n];
                hashSet.add(String.valueOf(classArray.substring(0, 1).toLowerCase()) + classArray.substring(1));
                ++n;
            }
            ++n4;
        }
        objectArray = this.integrator.getClass().getMethods();
        n3 = objectArray.length;
        n4 = 0;
        while (n4 < n3) {
            object2 = objectArray[n4];
            if (((Method)object2).getReturnType() == IStatus.ErrorCode.class && Modifier.isPublic(((Method)object2).getModifiers()) && (classArray = ((Method)object2).getParameterTypes()) != null && classArray.length == 1 && classArray[0] == ICommandMessage.class) {
                this.methodMap.put(((Method)object2).getName(), (Method)object2);
            }
            ++n4;
        }
        for (Object object2 : hashSet) {
            if (this.methodMap.containsKey(object2)) continue;
            log.error("Integrator does not implement the method:" + (String)object2);
            throw new Error("Some of the Integration methods not supported by the application");
        }
    }

    public IDesktopIntegrationProvider getProvider() {
        return this.provider;
    }

    public IListenerSynchronization getSync() {
        if (this.sync == null) {
            this.sync = ListenerSynchronizationFactory.getInstance();
        }
        return this.sync;
    }

    public boolean handleEvent(IEvent iEvent) {
        if (iEvent.getEventID() == this.getMessageEventId()) {
            IStatus.ErrorCode errorCode = null;
            IStatus iStatus = null;
            ICommandMessage iCommandMessage = (ICommandMessage)iEvent.getPayload();
            if (iCommandMessage instanceof PerformLogin) {
                PerformLogin performLogin = (PerformLogin)iCommandMessage;
                this.integrator.performLogin(performLogin.user, performLogin.password);
            } else if (iCommandMessage instanceof PerformLogout) {
                PerformLogout performLogout = (PerformLogout)iCommandMessage;
                this.integrator.performLogout(performLogout.restart);
            } else if (iCommandMessage instanceof AddToList) {
                AddToList addToList = (AddToList)iCommandMessage;
                iStatus = this.integrator.addToList(addToList.getList(), addToList.option, addToList.bypassSecurity, addToList.hangingProtocolHint);
            } else if (iCommandMessage instanceof ClearDisplay) {
                errorCode = this.integrator.clearDisplay();
            } else if (iCommandMessage instanceof ClearList) {
                errorCode = this.integrator.clearList();
            } else if (iCommandMessage instanceof EnablePart) {
                errorCode = this.integrator.enablePart(((EnablePart)iCommandMessage).part);
            } else if (iCommandMessage instanceof Exit) {
                this.shutdown(true, ((Exit)iCommandMessage).restart);
                this.provider.shutdown();
            } else if (iCommandMessage instanceof Hide) {
                this.isHidden = true;
                this.integrator.hide();
            } else if (iCommandMessage instanceof RemoveFromList) {
                errorCode = this.integrator.removeFromList(((RemoveFromList)iCommandMessage).getList());
            } else if (iCommandMessage instanceof RequestFocus) {
                this.integrator.requestFocus();
            } else if (iCommandMessage instanceof Restore) {
                this.isHidden = false;
                this.integrator.restore();
            } else if (iCommandMessage instanceof SetStatus) {
                SetStatus setStatus = (SetStatus)iCommandMessage;
                errorCode = this.integrator.setStatus(setStatus.obj, setStatus.newStatus);
            } else if (iCommandMessage instanceof SetWindowState) {
                SetWindowState setWindowState = (SetWindowState)iCommandMessage;
                this.integrator.setWindowState(setWindowState.state, setWindowState.monitor);
            } else if (iCommandMessage instanceof ShowMessage) {
                ShowMessage showMessage = (ShowMessage)iCommandMessage;
                Object object = this.integrator.showMessage(showMessage.message, showMessage.type, showMessage.options);
                if (object instanceof IStatus.ErrorCode) {
                    errorCode = (IStatus.ErrorCode)object;
                }
                if (object instanceof String) {
                    iStatus = new Status(IStatus.ErrorCode.OK);
                    ((Status)iStatus).setInfo((String)object);
                } else {
                    errorCode = IStatus.ErrorCode.FrameworkError;
                }
            } else if (iCommandMessage instanceof ExecuteScript) {
                try {
                    errorCode = this.executeScript(((ExecuteScript)iCommandMessage).script, null);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    errorCode = IStatus.ErrorCode.ScriptError;
                    log.warn("Script error", (Throwable)unsupportedOperationException);
                }
            } else if (iCommandMessage instanceof PerformDictation) {
                PerformDictation performDictation = (PerformDictation)iCommandMessage;
                errorCode = this.integrator.performDictation(performDictation.study, performDictation.type);
            } else if (iCommandMessage instanceof com.agfa.integration.messages.DictationChanged) {
                com.agfa.integration.messages.DictationChanged dictationChanged = (com.agfa.integration.messages.DictationChanged)iCommandMessage;
                this.integrator.dictationChanged(dictationChanged.study, dictationChanged.state);
            } else if (iCommandMessage instanceof ShowStudy) {
                ShowStudy showStudy = (ShowStudy)iCommandMessage;
                errorCode = this.integrator.showStudy(showStudy.object, showStudy.hangingProtocolHint);
            } else if (iCommandMessage instanceof FindStudy) {
                FindStudy findStudy = (FindStudy)iCommandMessage;
                String string = this.integrator.findStudy(findStudy.study);
                if (string != null) {
                    iStatus = new Status();
                    ((Status)iStatus).setInfo(string);
                } else {
                    iStatus = new Status(IStatus.ErrorCode.UIDNotFound);
                }
            } else if (iCommandMessage instanceof GetStudiesInDisplay) {
                iStatus = new Status();
                ((Status)iStatus).setInfo(this.getDisplayedStudiesAsKVPID());
            } else {
                String string = IntegrationFramework.getProcedureName(iCommandMessage);
                Method method = this.methodMap.get(string);
                if (method == null) {
                    log.error("Transformer send undeclared command");
                    return false;
                }
                try {
                    errorCode = (IStatus.ErrorCode)method.invoke((Object)this.integrator, iCommandMessage);
                }
                catch (Exception exception) {
                    throw new Error("Internal Error", exception);
                }
            }
            if (iStatus == null) {
                iStatus = new Status(errorCode);
            }
            iCommandMessage.setStatus(iStatus);
        }
        return false;
    }

    private String getDisplayedStudiesAsKVPID() {
        ObjectID[] objectIDArray = this.integrator.getDisplayedStudies();
        return IntegrationFramework.getKVPid(objectIDArray);
    }

    private String getStudiesinListAsKVPID() {
        ObjectID[] objectIDArray = this.integrator.getStudiesInList();
        return IntegrationFramework.getKVPid(objectIDArray);
    }

    public static String getKVPid(ObjectID[] objectIDArray) {
        String string = "patient_id=";
        String string2 = "accession_number=";
        String string3 = "study_uid=";
        StringBuffer stringBuffer = new StringBuffer("status=");
        int n = 0;
        while (n < objectIDArray.length) {
            ObjectID objectID = objectIDArray[n];
            boolean bl = n + 1 == objectIDArray.length;
            string = String.valueOf(string) + IntegrationFramework.handleNull(objectID.getPatientID()) + (bl ? "" : "\\");
            string2 = String.valueOf(string2) + IntegrationFramework.handleNull(objectID.getAccessionNr()) + (bl ? "" : "\\");
            string3 = String.valueOf(string3) + objectID.getStudyUID() + (bl ? "" : "\\");
            stringBuffer.append("N" + (bl ? "" : "\\"));
            ++n;
        }
        return String.valueOf(string) + "&" + string2 + "&" + string3 + "&" + stringBuffer.toString();
    }

    private static String handleNull(String string) {
        return string == null ? "" : string;
    }

    private static String getProcedureName(Object object) {
        String string = object.getClass().getSimpleName();
        string = String.valueOf(string.substring(0, 1).toLowerCase()) + string.substring(1);
        return string;
    }

    @Override
    public IStatus.ErrorCode executeScript(String string, Map<String, Object> map) throws UnsupportedOperationException {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.putAll(ScriptHelperFactory.getScriptHelpers());
        IScriptInterpreter[] iScriptInterpreterArray = ScriptInterpreterFactory.getInterpreters();
        if (iScriptInterpreterArray.length > 1) {
            IScriptInterpreter[] iScriptInterpreterArray2 = iScriptInterpreterArray;
            int n = iScriptInterpreterArray.length;
            int n2 = 0;
            while (n2 < n) {
                IScriptInterpreter iScriptInterpreter = iScriptInterpreterArray2[n2];
                if (iScriptInterpreter.detectLanguage(string)) {
                    this.executeScriptInt(iScriptInterpreter, string, map);
                    return null;
                }
                ++n2;
            }
        }
        if (iScriptInterpreterArray.length > 0) {
            this.executeScriptInt(iScriptInterpreterArray[0], string, map);
            return null;
        }
        return IStatus.ErrorCode.NoScriptEngine;
    }

    @Override
    public Object createScriptObject(String string, Map<String, Object> map) {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.putAll(ScriptHelperFactory.getScriptHelpers());
        IScriptInterpreter[] iScriptInterpreterArray = ScriptInterpreterFactory.getInterpreters();
        if (iScriptInterpreterArray.length > 1) {
            IScriptInterpreter[] iScriptInterpreterArray2 = iScriptInterpreterArray;
            int n = iScriptInterpreterArray.length;
            int n2 = 0;
            while (n2 < n) {
                IScriptInterpreter iScriptInterpreter = iScriptInterpreterArray2[n2];
                if (iScriptInterpreter.detectLanguage(string)) {
                    return this.executeScriptInt(iScriptInterpreter, string, map);
                }
                ++n2;
            }
        }
        if (iScriptInterpreterArray.length > 0) {
            return this.executeScriptInt(iScriptInterpreterArray[0], string, map);
        }
        return IStatus.ErrorCode.NoScriptEngine;
    }

    private Object executeScriptInt(IScriptInterpreter iScriptInterpreter, String string, Map<String, Object> map) {
        ScriptProxy scriptProxy = new ScriptProxy(this);
        map.put("Application", scriptProxy);
        map.put("Framework", this);
        try {
            return iScriptInterpreter.evaluate(string, map);
        }
        catch (Exception exception) {
            log.warn("Script execution failed", (Throwable)exception);
            throw new UnsupportedOperationException(exception.getLocalizedMessage());
        }
    }

    @Override
    public void shutdown() {
        this.shutdown(true, false);
    }

    protected void shutdown(boolean bl, boolean bl2) {
        if (bl) {
            this.queueNotification(new Logout(bl2));
        }
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {}
        if (this.adispatcher != null) {
            this.adispatcher.shutdown();
        }
        this.actualState = State.NotStarted;
        this.transformers.clear();
    }

    private static ActorInfo findActor(ActorInfo[] actorInfoArray, String string) {
        ActorInfo[] actorInfoArray2 = actorInfoArray;
        int n = actorInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActorInfo actorInfo = actorInfoArray2[n2];
            if (actorInfo.name.equals(string)) {
                return actorInfo;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public synchronized void start(boolean bl) {
        this.start(bl, new PriorityDesktopIntegrationProvider(), bl ? null : EventEngineFactory.getInstance());
    }

    public synchronized void start(boolean bl, IDesktopIntegrationProvider iDesktopIntegrationProvider, IEventEngine iEventEngine) {
        TransformerInfo[] transformerInfoArray;
        Object object2;
        if (this.actualState == State.FullStarted) {
            return;
        }
        if (this.actualState == State.NotStarted) {
            this.outQueue = new OutQueue();
            this.provider = iDesktopIntegrationProvider;
            this.levelIntegrationInterfaces = this.getLevel23IntegrationInterfaces();
        }
        if (this.actualState == State.Jumpstart && !bl) {
            this.actualState = State.FullStarted;
        }
        if (!bl) {
            this.engine = iEventEngine;
            this.inQueue = iEventEngine.createListenerProvider((IEventListener)this);
            this.initIntegrator();
        }
        TransformerInfo[] transformerInfoArray2 = this.getTransformers();
        ActorInfo[] actorInfoArray = this.getActors();
        HashMap hashMap = new HashMap();
        TransformerInfo[] transformerInfoArray3 = transformerInfoArray2;
        int n = transformerInfoArray2.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = transformerInfoArray3[n2];
            transformerInfoArray = IntegrationFramework.findActor(actorInfoArray, object2.forActor);
            if (transformerInfoArray != null && !(!bl ? !iDesktopIntegrationProvider.isActorActive(transformerInfoArray.name) || this.isActorRunning(transformerInfoArray.name) : !transformerInfoArray.inJumpstart || transformerInfoArray.actor.initConfiguration() == null)) {
                if (!hashMap.containsKey(object2.forActor)) {
                    hashMap.put(object2.forActor, new LinkedList());
                }
                ((List)hashMap.get(object2.forActor)).add(object2);
            }
            ++n2;
        }
        for (Object object2 : hashMap.values()) {
            this.transformers.add(this.createNotificationDispatcher((List<TransformerInfo>)object2));
        }
        transformerInfoArray = object2 = this.getSimpleActors();
        int n3 = ((TransformerInfo[])object2).length;
        n = 0;
        while (n < n3) {
            TransformerInfo transformerInfo = transformerInfoArray[n];
            ISimpleActor iSimpleActor = (ISimpleActor)transformerInfo.transformer;
            if (!(bl ? !transformerInfo.inJumpstart || iSimpleActor.initConfiguration() == null : !iDesktopIntegrationProvider.isActorActive(transformerInfo.name) || this.isActorRunning(transformerInfo.name))) {
                this.transformers.add(this.createNotificationDispatcher(Collections.singletonList(transformerInfo)));
            }
            ++n;
        }
        if (this.adispatcher == null) {
            this.adispatcher = this.createActorDispatcher(bl);
        } else if (!bl) {
            this.adispatcher.initFull();
        }
        this.actualState = bl ? State.Jumpstart : State.FullStarted;
        if (this.actualState == State.FullStarted && this.loginTask != null) {
            this.loginTask.setDone(IStatus.ErrorCode.OK);
        }
    }

    protected ActorDispatcher createActorDispatcher(boolean bl) {
        return new ActorDispatcher(this, bl);
    }

    protected NotificationSubDispatcher createNotificationDispatcher(List<TransformerInfo> list) {
        return new NotificationSubDispatcher(this, list);
    }

    private Map<String, LevelIntegrationInformation> getLevel23IntegrationInterfaces() {
        Map<String, LevelIntegrationInformation> map = this.getLevelIntegrations();
        if (map.size() == 0) {
            log.info("No Level 2/3 integration interfaces available");
            return null;
        }
        log.info("Using Level 2/3 integration interfaces");
        return map;
    }

    @Override
    public void login(String string, String string2) {
        this.queueNotification(new Login(string, string2));
    }

    @Override
    public void logout() {
        this.queueNotification(new Logout());
    }

    @Override
    public void statusChanged(String string, ObjectID objectID) {
        this.queueNotification(new StatusChanged(string, objectID));
    }

    @Override
    public void studyChanged(ObjectID objectID, ObjectID objectID2) {
        this.queueNotification(new StudyChanged(objectID, objectID2));
    }

    @Override
    public void sessionStored(ObjectID objectID, String string) {
        this.queueNotification(new SessionStored(objectID, string));
    }

    @Override
    public void studyRemoved(ObjectID[] objectIDArray) {
        this.queueNotification(new StudyRemoved(objectIDArray));
    }

    @Override
    public void patientRemoved(ObjectID[] objectIDArray) {
        this.queueNotification(new PatientRemoved(objectIDArray));
    }

    @Override
    public void queueNotification(INotificationMessage iNotificationMessage) {
        if (this.engine == null) {
            return;
        }
        IEvent iEvent = this.engine.createInternalEvent(this.getNotificationEventId(), this.outQueue, (Object)this, (Serializable)iNotificationMessage, ActionInfo.SINGLE);
        this.engine.sendEvent(iEvent);
    }

    protected int getNotificationEventId() {
        return EventConst.framework2transformer;
    }

    @Override
    public void queueCommand(ICommandMessage iCommandMessage) {
        this.queueMessage(iCommandMessage);
    }

    @Override
    public ExtendedFuture<IStatus> queueMessage(ICommandMessage iCommandMessage) {
        if (this.actualState == State.Jumpstart) {
            if (iCommandMessage instanceof PerformLogin) {
                PerformLogin performLogin = (PerformLogin)iCommandMessage;
                this.provider.awake(performLogin.user, performLogin.password, iCommandMessage.getTask());
                this.loginTask = iCommandMessage.getTask();
                return iCommandMessage.getTask();
            }
            if (iCommandMessage instanceof Exit) {
                if (this.adispatcher != null) {
                    this.adispatcher.shutdown();
                }
                this.provider.shutdown();
                iCommandMessage.setStatus(new Status());
                return iCommandMessage.getTask();
            }
            iCommandMessage.setStatus(new Status(IStatus.ErrorCode.NotLoggedIn));
            return iCommandMessage.getTask();
        }
        IEvent iEvent = this.engine.createInternalEvent(this.getMessageEventId(), this.inQueue, (Object)this, (Serializable)iCommandMessage, ActionInfo.SINGLE);
        this.engine.sendEvent(iEvent);
        return iCommandMessage.getTask();
    }

    protected int getMessageEventId() {
        return EventConst.transformer2framework;
    }

    @Override
    public IDesktopIntegrationFunctions getIntegrationFunctions() {
        return this.integrator;
    }

    @Override
    public ObjectID[] getDisplayedStudies() {
        if (!this.isLoggedIn()) {
            return new ObjectID[0];
        }
        return this.integrator.getDisplayedStudies();
    }

    @Override
    public ObjectID[] getSelectedStudies() {
        if (!this.isLoggedIn()) {
            return new ObjectID[0];
        }
        return this.integrator.getSelectedStudies();
    }

    @Override
    public ObjectID[] getStudiesInList() {
        if (!this.isLoggedIn()) {
            return new ObjectID[0];
        }
        return this.integrator.getStudiesInList();
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public boolean isLoggedIn() {
        return this.actualState == State.FullStarted;
    }

    @Override
    public void dictationChanged(ObjectID objectID, IDesktopIntegrationListener.DictationState dictationState) {
        this.queueNotification(new DictationChanged(objectID, dictationState));
    }

    @Override
    public void performDictationNotification(ObjectID objectID, String string) {
        this.queueNotification(new com.agfa.integration.notifications.PerformDictation(objectID, string));
    }

    @Override
    public String getLoggedUser() {
        boolean bl = this.isLoggedIn();
        if (!bl) {
            return null;
        }
        return this.provider.getLoggedUser();
    }

    public String getLoggedPassword() {
        if (this.isLoggedIn()) {
            return this.provider.getLoggedPassword();
        }
        return null;
    }

    @Override
    public void imagingCleared() {
        this.queueNotification(new ImagingCleared());
    }

    @Override
    public void listCleared() {
        this.queueNotification(new ListCleared());
    }

    @Override
    public ISimpleActor getSimpleActorByName(String string) {
        if (!this.isActorRunning(string)) {
            return null;
        }
        TransformerInfo[] transformerInfoArray = this.getSimpleActors();
        int n = transformerInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            TransformerInfo transformerInfo = transformerInfoArray[n2];
            if (transformerInfo.name.equalsIgnoreCase(string)) {
                return (ISimpleActor)transformerInfo.transformer;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IActor getActorByName(String string) {
        if (!this.isActorRunning(string)) {
            return null;
        }
        ActorInfo[] actorInfoArray = this.getActors();
        int n = actorInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActorInfo actorInfo = actorInfoArray[n2];
            if (actorInfo.name.equalsIgnoreCase(string)) {
                return actorInfo.actor;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String getName(IActor iActor) {
        ActorInfo[] actorInfoArray = this.getActors();
        int n = actorInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActorInfo actorInfo = actorInfoArray[n2];
            if (iActor.equals(actorInfo.actor)) {
                return actorInfo.name;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String getName(ITransformer iTransformer) {
        TransformerInfo[] transformerInfoArray = this.getTransformers();
        int n = transformerInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            TransformerInfo transformerInfo = transformerInfoArray[n2];
            if (iTransformer.equals(transformerInfo.transformer)) {
                return transformerInfo.name;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public <U extends ILevelIntegration> U getLevel23Integration(Class<U> clazz) {
        LevelIntegrationInformation levelIntegrationInformation;
        if (clazz != null && this.levelIntegrationInterfaces != null && (levelIntegrationInformation = this.levelIntegrationInterfaces.get(clazz.getSimpleName())) != null) {
            return (U)((ILevelIntegration)clazz.cast(levelIntegrationInformation.getLevelIntegration()));
        }
        return null;
    }

    protected ActorInfo[] getActors() {
        return ActorFactory.getInstance().getActors();
    }

    protected TransformerInfo[] getTransformers() {
        return TransformerFactory.getInstance().getTransformers();
    }

    protected Map<String, LevelIntegrationInformation> getLevelIntegrations() {
        return Level23IntegrationFactory.getLevelIntegrations();
    }

    protected TransformerInfo[] getSimpleActors() {
        return SimpleActorFactory.getActors();
    }

    private class OutQueue
    implements IEventListenerProvider<IEventListener> {
        private OutQueue() {
        }

        public Iterator<IEventListener> iterator() {
            return null;
        }

        public Iterator<IEventListener> iterator(IEvent iEvent, String string) {
            return IntegrationFramework.this.transformers.iterator();
        }
    }

    private static enum State {
        NotStarted,
        Jumpstart,
        FullStarted;

    }
}

