/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.integration.impl;

import com.agfa.integration.ObjectID;
import com.agfa.integration.ext.IStatus;
import java.util.ArrayList;

public class Status<T>
implements IStatus<T> {
    private boolean ok;
    private IStatus.ErrorCode code;
    private String info;
    private Object transformerObject;
    private Object actorObject;
    private T value;

    public Status(IStatus.ErrorCode errorCode) {
        this(errorCode, null);
    }

    public Status(IStatus.ErrorCode errorCode, String string) {
        if (errorCode != null && errorCode == IStatus.ErrorCode.OK) {
            errorCode = null;
        }
        this.ok = errorCode == null;
        this.code = errorCode;
        this.info = string;
    }

    public Status(IStatus.ErrorCode errorCode, String string, T t) {
        this(errorCode, string);
        this.value = t;
    }

    public Status() {
        this.ok = true;
        this.code = null;
    }

    protected void setInfo(String string) {
        this.info = string;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public String getAdditionalInformation() {
        return this.info;
    }

    @Override
    public IStatus.ErrorCode getErrorCode() {
        return this.ok ? IStatus.ErrorCode.OK : this.code;
    }

    @Override
    public Object getActorObject() {
        return this.actorObject;
    }

    @Override
    public Object getTransformerObject() {
        return this.transformerObject;
    }

    public void setTransformerObject(Object object) {
        this.transformerObject = object;
    }

    public void setActorObject(Object object) {
        this.actorObject = object;
    }

    @Override
    public boolean isFailed() {
        return !this.ok;
    }

    @Override
    public boolean isSuccessfull() {
        return this.ok;
    }

    @Override
    public ObjectID[] getReturnedObjects() {
        if (this.value instanceof ObjectID[]) {
            return (ObjectID[])this.value;
        }
        if (this.info != null) {
            return Status.parseStringResult(this.info);
        }
        return null;
    }

    static ObjectID[] parseStringResult(String string) {
        if (string == null || string.length() == 0) {
            return new ObjectID[0];
        }
        String[] stringArray = string.split("\u00a7");
        ArrayList<ObjectID> arrayList = new ArrayList<ObjectID>();
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = stringArray[n].split("\\&");
            if (stringArray2.length == 4) {
                ObjectID objectID = ObjectID.forStudyUID(stringArray2[2]);
                objectID.setAccessionNr(stringArray2[1]);
                objectID.setPatientID(stringArray2[0]);
                objectID.setModalityInStudy(stringArray2[3]);
                arrayList.add(objectID);
            }
            ++n;
        }
        return arrayList.toArray(new ObjectID[arrayList.size()]);
    }
}

