/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.integration.level23.identity;

import com.agfa.integration.level23.IObjectIdentifier;
import com.agfa.integration.level23.identity.SeriesIdentity;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class ObjectIdentity
implements IObjectIdentifier,
Serializable {
    private static final long serialVersionUID = -1729572122012710697L;
    private String sopInstanceUid;
    private String sopClassUid;
    private boolean isSelected;
    private int frameNumber;
    private SeriesIdentity seriesIdentity;
    private Map<String, String> extendedDetails;

    public ObjectIdentity(String string, int n, SeriesIdentity seriesIdentity) {
        this.sopInstanceUid = string;
        this.frameNumber = n;
        this.seriesIdentity = seriesIdentity;
    }

    public ObjectIdentity(String string, String string2, int n, SeriesIdentity seriesIdentity, boolean bl) {
        this(string, n, seriesIdentity);
        this.sopClassUid = string2;
        this.isSelected = bl;
    }

    public ObjectIdentity(String string, String string2, SeriesIdentity seriesIdentity) {
        this.sopInstanceUid = string;
        this.sopClassUid = string2;
        this.seriesIdentity = seriesIdentity;
    }

    public SeriesIdentity getSeriesIdentity() {
        return this.seriesIdentity;
    }

    public String getSopClassUid() {
        return this.sopClassUid;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public String getSopInstanceUID() {
        return this.sopInstanceUid;
    }

    @Override
    public int getFrame() {
        return this.frameNumber;
    }

    public Map<String, String> getExtendedDetails() {
        return this.extendedDetails;
    }

    public void addExtendedDetail(String string, String string2) {
        if (this.extendedDetails == null) {
            this.extendedDetails = new LinkedHashMap<String, String>();
        }
        this.extendedDetails.put(string, string2);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.frameNumber;
        n = 31 * n + (this.sopInstanceUid == null ? 0 : this.sopInstanceUid.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ObjectIdentity objectIdentity = (ObjectIdentity)object;
        if (this.frameNumber != objectIdentity.frameNumber) {
            return false;
        }
        return !(this.sopInstanceUid == null ? objectIdentity.sopInstanceUid != null : !this.sopInstanceUid.equals(objectIdentity.sopInstanceUid));
    }

    @Override
    public int compareTo(IObjectIdentifier iObjectIdentifier) {
        int n = this.sopInstanceUid.compareTo(iObjectIdentifier.getSopInstanceUID());
        return n == 0 ? this.frameNumber - iObjectIdentifier.getFrame() : n;
    }

    public String toString() {
        return "ObjectIdentity " + this.sopInstanceUid + "#" + this.frameNumber;
    }
}

