/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.integration.level23.messages;

import com.agfa.integration.ext.ExtendedFuture;
import com.agfa.integration.level23.FutureStatusUtil;
import com.agfa.integration.level23.IImageSelection;
import com.agfa.integration.level23.messages.ILevelMessage;
import com.agfa.integration.level23.result.SelectionResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SelectionMessage
implements ILevelMessage {
    private static final long serialVersionUID = 7493334736910972744L;
    private ExtendedFuture<SelectionResult> futureTask;
    private IImageSelection.SelectionMode selectionMode;
    private IImageSelection.SelectionScope selectionScope;
    private boolean includeUndisplayableObjects;
    private Map<String, List<String>> extendedDetails = new HashMap<String, List<String>>();

    public SelectionMessage(IImageSelection.SelectionMode selectionMode, IImageSelection.SelectionScope selectionScope, boolean bl, String[] stringArray) {
        this.futureTask = FutureStatusUtil.createTask();
        this.selectionMode = selectionMode;
        this.selectionScope = selectionScope;
        this.includeUndisplayableObjects = bl;
        this.parseExtendedDetails(stringArray);
    }

    private void parseExtendedDetails(String[] stringArray) {
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                String[] stringArray3 = string.split("\\.");
                if (!this.extendedDetails.containsKey(stringArray3[0])) {
                    this.extendedDetails.put(stringArray3[0], new ArrayList());
                }
                this.extendedDetails.get(stringArray3[0]).add(stringArray3[1]);
                ++n2;
            }
        }
    }

    public ExtendedFuture<SelectionResult> getFutureTask() {
        return this.futureTask;
    }

    public IImageSelection.SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public IImageSelection.SelectionScope getSelectionScope() {
        return this.selectionScope;
    }

    public boolean isIncludeUndisplayableObjects() {
        return this.includeUndisplayableObjects;
    }

    public Map<String, List<String>> getExtendedDetails() {
        return this.extendedDetails;
    }
}

