/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.integration.level23.result;

import com.agfa.integration.level23.IObjectIdentifier;
import com.agfa.integration.level23.result.Result;
import com.agfa.integration.level23.result.ResultStatus;
import java.io.Serializable;

public class ObjectResult<T extends Serializable>
extends Result<T>
implements Comparable<ObjectResult> {
    private static final long serialVersionUID = 700261027594030332L;
    private IObjectIdentifier object;

    private ObjectResult(IObjectIdentifier iObjectIdentifier, T t, ResultStatus resultStatus) {
        this.object = iObjectIdentifier;
        this.resultStatus = resultStatus;
        this.setData(t);
    }

    private ObjectResult(IObjectIdentifier iObjectIdentifier, String string) {
        this.object = iObjectIdentifier;
        this.resultStatus = ResultStatus.FAILURE(string);
    }

    public static <T extends Serializable> ObjectResult<T> FAILURE(IObjectIdentifier iObjectIdentifier, String string) {
        return new ObjectResult<T>(iObjectIdentifier, string);
    }

    public static <T extends Serializable> ObjectResult<T> OK(IObjectIdentifier iObjectIdentifier, T t) {
        return new ObjectResult<T>(iObjectIdentifier, t, ResultStatus.OK());
    }

    public static <T extends Serializable> ObjectResult<T> UNKNOWN_ERROR(IObjectIdentifier iObjectIdentifier, T t) {
        return new ObjectResult<T>(iObjectIdentifier, t, ResultStatus.UNKNOWN_ERROR());
    }

    public IObjectIdentifier getObject() {
        return this.object;
    }

    @Override
    public int compareTo(ObjectResult objectResult) {
        return this.object.compareTo(objectResult.getObject());
    }
}

