/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.integration.level23.result;

import com.agfa.integration.level23.result.ResultStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Result<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 5169357321216261032L;
    protected List<T> data;
    protected ResultStatus resultStatus;

    public static <T extends Serializable> Result<T> OK() {
        return new Result<Object>(null);
    }

    public static <T extends Serializable> Result<T> OK(T t) {
        return new Result<T>(t);
    }

    public static <T extends Serializable> Result<T> FAILURE(String string) {
        return new Result<T>(string);
    }

    public static <T extends Serializable> Result<T> FAILURE(T t, String string) {
        return new Result<T>(t, ResultStatus.FAILURE(string));
    }

    public static <T extends Serializable> Result<T> UNKNOWN_ERROR(T t) {
        return new Result<T>(t, ResultStatus.UNKNOWN_ERROR());
    }

    public static <T extends Serializable> Result<T> NOT_SUPPORTED(T t) {
        return new Result<T>(t, ResultStatus.NOT_SUPPORTED());
    }

    public static <T extends Serializable> Result<T> NOT_SUPPORTED(T t, String string) {
        return new Result<T>(t, ResultStatus.NOT_SUPPORTED(string));
    }

    public Result() {
    }

    public Result(T t) {
        this.setData(t);
        this.resultStatus = ResultStatus.OK();
    }

    public Result(T t, ResultStatus resultStatus) {
        this.setData(t);
        this.resultStatus = resultStatus;
    }

    public Result(String string) {
        this.resultStatus = ResultStatus.FAILURE(string);
    }

    public List<T> getData() {
        return this.data;
    }

    public void setData(T t) {
        this.data = new ArrayList<T>();
        if (t instanceof Collection) {
            for (Object e : (Collection)t) {
                if (e == null) continue;
                this.data.add((Serializable)e);
            }
        } else if (t != null) {
            this.data.add(t);
        }
    }

    public ResultStatus getResultStatus() {
        return this.resultStatus;
    }

    public void setResultStatus(ResultStatus resultStatus) {
        this.resultStatus = resultStatus;
    }
}

