/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.core.runtime.internal.stats.StatsManager;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.runnable.StartupMonitor;

public class DefaultStartupMonitor
implements StartupMonitor {
    private Method updateMethod = null;
    private Runnable splashHandler = null;

    public DefaultStartupMonitor(Runnable runnable) throws IllegalStateException {
        this.splashHandler = runnable;
        try {
            this.updateMethod = runnable.getClass().getMethod("updateSplash", null);
        }
        catch (SecurityException securityException) {
            throw (IllegalStateException)new IllegalStateException(securityException.getMessage()).initCause(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw (IllegalStateException)new IllegalStateException(noSuchMethodException.getMessage()).initCause(noSuchMethodException);
        }
    }

    public void update() {
        if (this.updateMethod != null) {
            try {
                this.updateMethod.invoke((Object)this.splashHandler, null);
            }
            catch (Throwable throwable) {}
        }
    }

    public void applicationRunning() {
        if (EclipseStarter.debug) {
            String string = FrameworkProperties.getProperty("eclipse.startTime");
            long l = string == null ? 0L : Long.parseLong(string);
            System.out.println("Application Started: " + (System.currentTimeMillis() - l));
        }
        StatsManager.doneBooting();
        this.splashHandler.run();
    }
}

