/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.equinox.log.internal.EventAdminLogListener;
import org.eclipse.equinox.log.internal.ExtendedLogReaderServiceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventAdminAdapter
implements ServiceTrackerCustomizer<Object, Object> {
    public static final String EVENT_TOPIC = "event.topics";
    private static final String[] LOG_TOPICS_ARRAY = new String[]{"*", "org/*", "org/osgi/*", "org/osgi/service/*", "org/osgi/service/log/*", "org/osgi/service/log/LogEntry/*", "org/osgi/service/log/LogEntry/LOG_ERROR", "org/osgi/service/log/LogEntry/LOG_WARNING", "org/osgi/service/log/LogEntry/LOG_INFO", "org/osgi/service/log/LogEntry/LOG_DEBUG", "org/osgi/service/log/LogEntry/LOG_OTHER"};
    private static final Object LOG_TOPIC_TOKEN = new Object();
    private static Collection<String> logTopics = new HashSet<String>(Arrays.asList(LOG_TOPICS_ARRAY));
    private static Collection<String> eventAdminObjectClass = Arrays.asList("org.osgi.service.event.EventAdmin");
    private static Collection<String> eventHandlerObjectClass = Arrays.asList("org.osgi.service.event.EventHandler");
    private ServiceTracker<Object, Object> eventAdminTracker;
    private ServiceTracker<Object, Object> eventHandlerTracker;
    private BundleContext context;
    private ServiceReference<Object> eventAdmin;
    private int logEventHandlers;
    private ExtendedLogReaderServiceFactory logReaderServiceFactory;
    private EventAdminLogListener logListener;

    public EventAdminAdapter(BundleContext bundleContext, ExtendedLogReaderServiceFactory extendedLogReaderServiceFactory) {
        this.context = bundleContext;
        this.logReaderServiceFactory = extendedLogReaderServiceFactory;
        this.eventAdminTracker = new ServiceTracker<Object, Object>(bundleContext, "org.osgi.service.event.EventAdmin", this);
        this.eventHandlerTracker = new ServiceTracker<Object, Object>(bundleContext, "org.osgi.service.event.EventHandler", this);
    }

    public void start() {
        this.eventAdminTracker.open();
        this.eventHandlerTracker.open();
    }

    public void stop() {
        this.eventAdminTracker.close();
        this.eventHandlerTracker.close();
    }

    @Override
    public Object addingService(ServiceReference<Object> serviceReference) {
        Object object = null;
        Object object2 = serviceReference.getProperty("objectClass");
        Object object3 = serviceReference.getProperty(EVENT_TOPIC);
        if (EventAdminAdapter.checkServiceProp(object2, eventAdminObjectClass) && this.eventAdmin == null) {
            object = serviceReference;
            this.eventAdmin = serviceReference;
        } else if (EventAdminAdapter.checkServiceProp(object2, eventHandlerObjectClass) && EventAdminAdapter.checkServiceProp(object3, logTopics)) {
            ++this.logEventHandlers;
            object = LOG_TOPIC_TOKEN;
        }
        if (this.eventAdmin != null && this.logEventHandlers > 0 && this.logListener == null) {
            try {
                this.logListener = new EventAdminLogListener(this.context.getService(this.eventAdmin));
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            this.logReaderServiceFactory.addLogListener(this.logListener, ExtendedLogReaderServiceFactory.NULL_LOGGER_FILTER);
        }
        return object;
    }

    @Override
    public void modifiedService(ServiceReference<Object> serviceReference, Object object) {
        this.removedService(serviceReference, object);
        this.addingService(serviceReference);
    }

    @Override
    public void removedService(ServiceReference<Object> serviceReference, Object object) {
        if (object == this.eventAdmin) {
            this.eventAdmin = null;
            this.context.ungetService(serviceReference);
        } else if (LOG_TOPIC_TOKEN == object) {
            --this.logEventHandlers;
        }
        if (this.logListener != null && (this.eventAdmin == null || this.logEventHandlers == 0)) {
            this.logReaderServiceFactory.removeLogListener(this.logListener);
            this.logListener = null;
        }
    }

    private static boolean checkServiceProp(Object object, Collection<String> collection) {
        if (object instanceof String) {
            return collection.contains(object);
        }
        if (object instanceof String[]) {
            Object object2 = (String[])object;
            int n = 0;
            while (n < ((String[])object2).length) {
                if (collection.contains(object2[n])) {
                    return true;
                }
                ++n;
            }
        }
        if (object instanceof Collection) {
            for (Object object2 : (Collection)object) {
                if (!collection.contains(object2)) continue;
                return true;
            }
        }
        return false;
    }
}

