/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOnWriteIdentityMap<K, V>
implements Map<K, V> {
    private static final Entry[] emptyArray = new Entry[0];
    private volatile Entry<K, V>[] entries;

    public CopyOnWriteIdentityMap() {
        this.entries = CopyOnWriteIdentityMap.empty();
    }

    public CopyOnWriteIdentityMap(CopyOnWriteIdentityMap<? extends K, ? extends V> copyOnWriteIdentityMap) {
        Entry<? extends K, ? extends V>[] entryArray = super.entries();
        this.entries = entryArray;
    }

    @Override
    public synchronized V put(K k, V v) {
        if (k == null) {
            throw new IllegalArgumentException();
        }
        int n = this.entries.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.entries[n2].key == k) {
                Object v2 = this.entries[n2].value;
                if (v2 == v) {
                    return v2;
                }
                Entry[] entryArray = new Entry[n];
                System.arraycopy(this.entries, 0, entryArray, 0, n);
                entryArray[n2] = new Entry<K, V>(k, v);
                this.entries = entryArray;
                return v2;
            }
            ++n2;
        }
        Entry[] entryArray = new Entry[n + 1];
        if (n > 0) {
            System.arraycopy(this.entries, 0, entryArray, 0, n);
        }
        entryArray[n] = new Entry<K, V>(k, v);
        this.entries = entryArray;
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (map instanceof CopyOnWriteIdentityMap) {
            this.putAll(((CopyOnWriteIdentityMap)map).entries());
            return;
        }
        Entry[] entryArray = new Entry[n];
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        int n2 = 0;
        while (n2 < n) {
            Map.Entry<K, V> entry = iterator.next();
            entryArray[n2] = new Entry<K, V>(entry.getKey(), entry.getValue());
            ++n2;
        }
        this.putAll(entryArray);
    }

    public <L extends K> void putAll(L[] LArray) {
        int n = LArray.length;
        if (n == 0) {
            return;
        }
        Entry[] entryArray = new Entry[n];
        int n2 = 0;
        while (n2 < n) {
            entryArray[n2] = new Entry<L, Object>(LArray[n2], null);
            ++n2;
        }
        this.putAll(entryArray);
    }

    private synchronized void putAll(Entry<? extends K, ? extends V>[] entryArray) {
        int n = entryArray.length;
        int n2 = this.entries.length;
        Entry[] entryArray2 = new Entry[n2 + n];
        System.arraycopy(this.entries, 0, entryArray2, 0, n2);
        int n3 = 0;
        while (n3 < n) {
            block4: {
                Entry<? extends K, ? extends V> entry = entryArray[n3];
                int n4 = 0;
                while (n4 < n2) {
                    if (entryArray2[n4].key == entry.key) {
                        entryArray2[n4] = entry;
                        break block4;
                    }
                    ++n4;
                }
                entryArray2[n2] = entry;
                ++n2;
            }
            ++n3;
        }
        if (n2 == entryArray2.length) {
            this.entries = entryArray2;
            return;
        }
        Entry[] entryArray3 = new Entry[n2];
        System.arraycopy(entryArray2, 0, entryArray3, 0, n2);
        this.entries = entryArray3;
    }

    @Override
    public synchronized V remove(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        int n = this.entries.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.entries[n2].key == object) {
                Object v = this.entries[n2].value;
                this.entries = CopyOnWriteIdentityMap.removeEntry(this.entries, n2);
                return v;
            }
            ++n2;
        }
        return null;
    }

    static <K, V> Entry<K, V>[] removeEntry(Entry<K, V>[] entryArray, int n) {
        int n2;
        int n3 = entryArray.length;
        if (n3 == 1) {
            return CopyOnWriteIdentityMap.empty();
        }
        Entry[] entryArray2 = new Entry[n3 - 1];
        if (n > 0) {
            System.arraycopy(entryArray, 0, entryArray2, 0, n);
        }
        if ((n2 = n3 - 1 - n) > 0) {
            System.arraycopy(entryArray, n + 1, entryArray2, n, n2);
        }
        return entryArray2;
    }

    @Override
    public synchronized void clear() {
        this.entries = CopyOnWriteIdentityMap.empty();
    }

    private Entry<K, V>[] entries() {
        return this.entries;
    }

    static <K, V> Entry<K, V>[] empty() {
        return emptyArray;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.entries().length;
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Entry<K, V>[] entryArray = this.entries();
        int n = 0;
        while (n < entryArray.length) {
            if (entryArray[n].key == object) {
                return entryArray[n].value;
            }
            ++n;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Entry<K, V>[] entryArray = this.entries();
        int n = 0;
        while (n < entryArray.length) {
            if (entryArray[n].key == object) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        Entry<K, V>[] entryArray = this.entries();
        int n = 0;
        while (n < entryArray.length) {
            if (entryArray[n].value == object) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new Snapshot<K, V>(this.entries()).entrySet();
    }

    @Override
    public Set<K> keySet() {
        return new Snapshot<K, V>(this.entries()).keySet();
    }

    @Override
    public Collection<V> values() {
        return new Snapshot<K, V>(this.entries()).values();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Entry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        final V value;

        Entry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return new StringBuffer().append(this.key).append("=").append(this.value).toString();
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.key) ^ System.identityHashCode(this.value);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.key == entry.getKey() && this.value == entry.getValue();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Snapshot<K, V> {
        volatile Entry<K, V>[] entries;

        Snapshot(Entry<K, V>[] entryArray) {
            this.entries = entryArray;
        }

        Entry<K, V>[] entries() {
            return this.entries;
        }

        synchronized void removeEntry(int n) {
            this.entries = CopyOnWriteIdentityMap.removeEntry(this.entries, n);
        }

        synchronized void clearEntries() {
            this.entries = CopyOnWriteIdentityMap.empty();
        }

        Set<Map.Entry<K, V>> entrySet() {
            return new EntrySet();
        }

        Set<K> keySet() {
            return new KeySet();
        }

        Collection<V> values() {
            return new ValueCollection();
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class EntryIterator
        extends SnapshotIterator<Map.Entry<K, V>> {
            EntryIterator() {
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.nextEntry();
            }
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class EntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return Snapshot.this.entries().length;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean remove(Object object) {
                if (object == null) {
                    throw new IllegalArgumentException();
                }
                Snapshot snapshot = Snapshot.this;
                synchronized (snapshot) {
                    int n = Snapshot.this.entries.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return false;
                        }
                        if (Snapshot.this.entries[n2].equals(object)) {
                            Snapshot.this.removeEntry(n2);
                            return true;
                        }
                        ++n2;
                    }
                }
            }

            @Override
            public void clear() {
                Snapshot.this.clearEntries();
            }
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class KeyIterator
        extends SnapshotIterator<K> {
            KeyIterator() {
            }

            @Override
            public K next() {
                return this.nextEntry().key;
            }
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class KeySet
        extends AbstractSet<K> {
            KeySet() {
            }

            @Override
            public Iterator<K> iterator() {
                return new KeyIterator();
            }

            @Override
            public int size() {
                return Snapshot.this.entries().length;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean remove(Object object) {
                if (object == null) {
                    throw new IllegalArgumentException();
                }
                Snapshot snapshot = Snapshot.this;
                synchronized (snapshot) {
                    int n = Snapshot.this.entries.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return false;
                        }
                        if (Snapshot.this.entries[n2].key == object) {
                            Snapshot.this.removeEntry(n2);
                            return true;
                        }
                        ++n2;
                    }
                }
            }

            @Override
            public void clear() {
                Snapshot.this.clearEntries();
            }
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private abstract class SnapshotIterator<E>
        implements Iterator<E> {
            private int length;
            private int cursor;

            SnapshotIterator() {
                this.length = Snapshot.this.entries().length;
                this.cursor = 0;
            }

            @Override
            public final boolean hasNext() {
                return this.cursor < this.length;
            }

            protected final Entry<K, V> nextEntry() {
                Entry<K, V>[] entryArray = Snapshot.this.entries();
                if (this.length != entryArray.length) {
                    throw new ConcurrentModificationException();
                }
                if (this.cursor == this.length) {
                    throw new NoSuchElementException();
                }
                return entryArray[this.cursor++];
            }

            @Override
            public final void remove() {
                if (this.length != Snapshot.this.entries().length) {
                    throw new ConcurrentModificationException();
                }
                if (this.cursor == 0) {
                    throw new IllegalStateException();
                }
                --this.cursor;
                Snapshot.this.removeEntry(this.cursor);
                this.length = Snapshot.this.entries().length;
            }
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class ValueCollection
        extends AbstractCollection<V> {
            ValueCollection() {
            }

            @Override
            public Iterator<V> iterator() {
                return new ValueIterator();
            }

            @Override
            public int size() {
                return Snapshot.this.entries().length;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean remove(Object object) {
                if (object == null) {
                    throw new IllegalArgumentException();
                }
                Snapshot snapshot = Snapshot.this;
                synchronized (snapshot) {
                    int n = Snapshot.this.entries.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return false;
                        }
                        if (Snapshot.this.entries[n2].value == object) {
                            Snapshot.this.removeEntry(n2);
                            return true;
                        }
                        ++n2;
                    }
                }
            }

            @Override
            public void clear() {
                Snapshot.this.clearEntries();
            }
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class ValueIterator
        extends SnapshotIterator<V> {
            ValueIterator() {
            }

            @Override
            public V next() {
                return this.nextEntry().value;
            }
        }
    }
}

