/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManager {
    static final boolean DEBUG = false;
    private EventThread<?, ?, ?> thread = null;
    private boolean closed = false;
    protected final String threadName;
    protected final ThreadGroup threadGroup;

    public EventManager() {
        this(null, null);
    }

    public EventManager(String string) {
        this(string, null);
    }

    public EventManager(String string, ThreadGroup threadGroup) {
        this.threadName = string;
        this.threadGroup = threadGroup;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (this.thread != null) {
            this.thread.close();
            this.thread = null;
        }
        this.closed = true;
    }

    synchronized <K, V, E> EventThread<K, V, E> getEventThread() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (this.thread == null) {
            this.thread = (EventThread)AccessController.doPrivileged(new PrivilegedAction<EventThread<K, V, E>>(){

                @Override
                public EventThread<K, V, E> run() {
                    EventThread eventThread = new EventThread(EventManager.this.threadGroup, EventManager.this.threadName);
                    return eventThread;
                }
            });
            this.thread.start();
        }
        EventThread<?, ?, ?> eventThread = this.thread;
        return eventThread;
    }

    static <K, V, E> void dispatchEvent(Set<Map.Entry<K, V>> set, EventDispatcher<K, V, E> eventDispatcher, int n, E e) {
        for (Map.Entry<K, V> entry : set) {
            K k = entry.getKey();
            V v = entry.getValue();
            try {
                eventDispatcher.dispatchEvent(k, v, n, e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EventThread<K, V, E>
    extends Thread {
        private static int nextThreadNumber;
        private Queued<K, V, E> head = null;
        private Queued<K, V, E> tail = null;
        private volatile boolean running = true;

        EventThread(ThreadGroup threadGroup, String string) {
            super(threadGroup, string == null ? EventThread.getNextName() : string);
            this.setDaemon(true);
        }

        private static synchronized String getNextName() {
            return new StringBuffer("EventManagerThread-").append(nextThreadNumber++).toString();
        }

        EventThread(String string) {
            this((ThreadGroup)null, string);
        }

        EventThread() {
            this((ThreadGroup)null, (String)null);
        }

        void close() {
            this.running = false;
            this.interrupt();
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Queued<K, V, E> queued;
                    if ((queued = this.getNextEvent()) == null) {
                        return;
                    }
                    EventManager.dispatchEvent(queued.listeners, queued.dispatcher, queued.action, queued.object);
                    queued = null;
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Error error) {
                throw error;
            }
        }

        synchronized void postEvent(Set<Map.Entry<K, V>> set, EventDispatcher<K, V, E> eventDispatcher, int n, E e) {
            if (!this.isAlive()) {
                throw new IllegalStateException();
            }
            Queued<K, V, E> queued = new Queued<K, V, E>(set, eventDispatcher, n, e);
            if (this.head == null) {
                this.head = queued;
                this.tail = queued;
            } else {
                this.tail.next = queued;
                this.tail = queued;
            }
            this.notify();
        }

        private synchronized Queued<K, V, E> getNextEvent() {
            while (this.running && this.head == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.running) {
                return null;
            }
            Queued<K, V, E> queued = this.head;
            this.head = queued.next;
            if (this.head == null) {
                this.tail = null;
            }
            return queued;
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Queued<K, V, E> {
            final Set<Map.Entry<K, V>> listeners;
            final EventDispatcher<K, V, E> dispatcher;
            final int action;
            final E object;
            Queued<K, V, E> next;

            Queued(Set<Map.Entry<K, V>> set, EventDispatcher<K, V, E> eventDispatcher, int n, E e) {
                this.listeners = set;
                this.dispatcher = eventDispatcher;
                this.action = n;
                this.object = e;
                this.next = null;
            }
        }
    }
}

