/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventListeners;
import org.eclipse.osgi.framework.eventmgr.EventManager;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerQueue<K, V, E> {
    protected final EventManager manager;
    private final Map<Set<Map.Entry<K, V>>, EventDispatcher<K, V, E>> queue;
    private boolean readOnly;

    public ListenerQueue(EventManager eventManager) {
        if (eventManager == null) {
            throw new IllegalArgumentException();
        }
        this.manager = eventManager;
        this.queue = new CopyOnWriteIdentityMap<Set<Map.Entry<K, V>>, EventDispatcher<K, V, E>>();
        this.readOnly = false;
    }

    public void queueListeners(EventListeners<K, V> eventListeners, EventDispatcher<K, V, E> eventDispatcher) {
        this.queueListeners(eventListeners.entrySet(), eventDispatcher);
    }

    public synchronized void queueListeners(Set<Map.Entry<K, V>> set, EventDispatcher<K, V, E> eventDispatcher) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        if (!set.isEmpty()) {
            this.queue.put(set, eventDispatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEventAsynchronous(int n, E e) {
        Object object = this;
        synchronized (object) {
            this.readOnly = true;
        }
        Object object2 = object = this.manager.getEventThread();
        synchronized (object2) {
            for (Map.Entry<Set<Map.Entry<K, V>>, EventDispatcher<K, V, E>> entry : this.queue.entrySet()) {
                ((EventManager.EventThread)object).postEvent(entry.getKey(), entry.getValue(), n, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEventSynchronous(int n, E e) {
        ListenerQueue object2 = this;
        synchronized (object2) {
            this.readOnly = true;
        }
        for (Map.Entry<Set<Map.Entry<K, V>>, EventDispatcher<K, V, E>> entry : this.queue.entrySet()) {
            EventManager.dispatchEvent(entry.getKey(), entry.getValue(), n, e);
        }
    }
}

