/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.File;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.internal.adaptor.ContextFinder;
import org.eclipse.osgi.event.BatchBundleListener;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistrationImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.eclipse.osgi.internal.serviceregistry.ServiceUse;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleContextImpl
implements BundleContext,
EventDispatcher<Object, Object, Object> {
    private static boolean SET_TCCL = "true".equals(FrameworkProperties.getProperty("eclipse.bundle.setTCCL", "true"));
    private volatile boolean valid;
    final BundleHost bundle;
    final Framework framework;
    private HashMap<ServiceRegistrationImpl<?>, ServiceUse<?>> servicesInUse;
    protected BundleActivator activator;
    private final Object contextLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BundleContextImpl(BundleHost bundleHost) {
        this.bundle = bundleHost;
        this.valid = true;
        this.framework = bundleHost.framework;
        Object object = this.contextLock;
        synchronized (object) {
            this.servicesInUse = null;
        }
        this.activator = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        this.valid = false;
        ServiceRegistry serviceRegistry = this.framework.getServiceRegistry();
        serviceRegistry.removeAllServiceListeners(this);
        this.framework.removeAllListeners(this);
        serviceRegistry.unregisterServices(this);
        serviceRegistry.releaseServicesInUse(this);
        Object object = this.contextLock;
        synchronized (object) {
            this.servicesInUse = null;
        }
    }

    @Override
    public String getProperty(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        return this.framework.getProperty(string);
    }

    @Override
    public Bundle getBundle() {
        this.checkValid();
        return this.getBundleImpl();
    }

    public AbstractBundle getBundleImpl() {
        return this.bundle;
    }

    @Override
    public Bundle installBundle(String string) throws BundleException {
        return this.installBundle(string, null);
    }

    @Override
    public Bundle installBundle(String string, InputStream inputStream) throws BundleException {
        this.checkValid();
        return this.framework.installBundle(string, inputStream, this);
    }

    @Override
    public Bundle getBundle(long l) {
        return this.framework.getBundle(this, l);
    }

    @Override
    public Bundle getBundle(String string) {
        return this.framework.getBundleByLocation(string);
    }

    public AbstractBundle getBundleByLocation(String string) {
        return this.framework.getBundleByLocation(string);
    }

    @Override
    public Bundle[] getBundles() {
        return this.framework.getBundles(this);
    }

    @Override
    public void addServiceListener(ServiceListener serviceListener, String string) throws InvalidSyntaxException {
        this.checkValid();
        if (serviceListener == null) {
            throw new IllegalArgumentException();
        }
        this.framework.getServiceRegistry().addServiceListener(this, serviceListener, string);
    }

    @Override
    public void addServiceListener(ServiceListener serviceListener) {
        block2: {
            try {
                this.addServiceListener(serviceListener, null);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                if (!Debug.DEBUG_GENERAL) break block2;
                Debug.println(new StringBuffer("InvalidSyntaxException w/ null filter").append(invalidSyntaxException.getMessage()).toString());
                Debug.printStackTrace(invalidSyntaxException);
            }
        }
    }

    @Override
    public void removeServiceListener(ServiceListener serviceListener) {
        this.checkValid();
        if (serviceListener == null) {
            throw new IllegalArgumentException();
        }
        this.framework.getServiceRegistry().removeServiceListener(this, serviceListener);
    }

    @Override
    public void addBundleListener(BundleListener bundleListener) {
        this.checkValid();
        if (bundleListener == null) {
            throw new IllegalArgumentException();
        }
        if (Debug.DEBUG_EVENTS) {
            String string = new StringBuffer(String.valueOf(bundleListener.getClass().getName())).append("@").append(Integer.toHexString(System.identityHashCode(bundleListener))).toString();
            Debug.println(new StringBuffer("addBundleListener[").append(this.bundle).append("](").append(string).append(")").toString());
        }
        this.framework.addBundleListener(bundleListener, this);
    }

    @Override
    public void removeBundleListener(BundleListener bundleListener) {
        this.checkValid();
        if (bundleListener == null) {
            throw new IllegalArgumentException();
        }
        if (Debug.DEBUG_EVENTS) {
            String string = new StringBuffer(String.valueOf(bundleListener.getClass().getName())).append("@").append(Integer.toHexString(System.identityHashCode(bundleListener))).toString();
            Debug.println(new StringBuffer("removeBundleListener[").append(this.bundle).append("](").append(string).append(")").toString());
        }
        this.framework.removeBundleListener(bundleListener, this);
    }

    @Override
    public void addFrameworkListener(FrameworkListener frameworkListener) {
        this.checkValid();
        if (frameworkListener == null) {
            throw new IllegalArgumentException();
        }
        if (Debug.DEBUG_EVENTS) {
            String string = new StringBuffer(String.valueOf(frameworkListener.getClass().getName())).append("@").append(Integer.toHexString(System.identityHashCode(frameworkListener))).toString();
            Debug.println(new StringBuffer("addFrameworkListener[").append(this.bundle).append("](").append(string).append(")").toString());
        }
        this.framework.addFrameworkListener(frameworkListener, this);
    }

    @Override
    public void removeFrameworkListener(FrameworkListener frameworkListener) {
        this.checkValid();
        if (frameworkListener == null) {
            throw new IllegalArgumentException();
        }
        if (Debug.DEBUG_EVENTS) {
            String string = new StringBuffer(String.valueOf(frameworkListener.getClass().getName())).append("@").append(Integer.toHexString(System.identityHashCode(frameworkListener))).toString();
            Debug.println(new StringBuffer("removeFrameworkListener[").append(this.bundle).append("](").append(string).append(")").toString());
        }
        this.framework.removeFrameworkListener(frameworkListener, this);
    }

    @Override
    public ServiceRegistration<?> registerService(String[] stringArray, Object object, Dictionary<String, ?> dictionary) {
        this.checkValid();
        return this.framework.getServiceRegistry().registerService(this, stringArray, object, dictionary);
    }

    @Override
    public ServiceRegistration<?> registerService(String string, Object object, Dictionary<String, ?> dictionary) {
        String[] stringArray = new String[]{string};
        return this.registerService(stringArray, object, dictionary);
    }

    @Override
    public ServiceReference<?>[] getServiceReferences(String string, String string2) throws InvalidSyntaxException {
        this.checkValid();
        return this.framework.getServiceRegistry().getServiceReferences(this, string, string2, false);
    }

    @Override
    public ServiceReference<?>[] getAllServiceReferences(String string, String string2) throws InvalidSyntaxException {
        this.checkValid();
        return this.framework.getServiceRegistry().getServiceReferences(this, string, string2, true);
    }

    @Override
    public ServiceReference<?> getServiceReference(String string) {
        this.checkValid();
        return this.framework.getServiceRegistry().getServiceReference(this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S> S getService(ServiceReference<S> serviceReference) {
        this.checkValid();
        if (serviceReference == null) {
            throw new NullPointerException("A null service reference is not allowed.");
        }
        Object object = this.contextLock;
        synchronized (object) {
            if (this.servicesInUse == null) {
                this.servicesInUse = new HashMap(10);
            }
        }
        object = this.framework.getServiceRegistry().getService(this, (ServiceReferenceImpl)serviceReference);
        return (S)object;
    }

    @Override
    public boolean ungetService(ServiceReference<?> serviceReference) {
        this.checkValid();
        return this.framework.getServiceRegistry().ungetService(this, (ServiceReferenceImpl)serviceReference);
    }

    @Override
    public File getDataFile(String string) {
        this.checkValid();
        return this.framework.getDataFile(this.bundle, string);
    }

    protected void start() throws BundleException {
        this.activator = this.bundle.loadBundleActivator();
        if (this.activator != null) {
            try {
                this.startActivator(this.activator);
            }
            catch (BundleException bundleException) {
                this.activator = null;
                throw bundleException;
            }
        }
    }

    protected void startActivator(final BundleActivator bundleActivator) throws BundleException {
        if (Profile.STARTUP) {
            Profile.logEnter("BundleContextImpl.startActivator()", null);
        }
        try {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        if (bundleActivator != null) {
                            if (Profile.STARTUP) {
                                Profile.logTime("BundleContextImpl.startActivator()", new StringBuffer("calling ").append(BundleContextImpl.this.bundle.getLocation()).append(" bundle activator").toString());
                            }
                            Object object = BundleContextImpl.this.setContextFinder();
                            try {
                                bundleActivator.start(BundleContextImpl.this);
                            }
                            finally {
                                if (object != Boolean.FALSE) {
                                    Thread.currentThread().setContextClassLoader((ClassLoader)object);
                                }
                            }
                            if (Profile.STARTUP) {
                                Profile.logTime("BundleContextImpl.startActivator()", new StringBuffer("returned from ").append(BundleContextImpl.this.bundle.getLocation()).append(" bundle activator").toString());
                            }
                        }
                        return null;
                    }
                });
            }
            catch (Throwable throwable) {
                Exception exception;
                if (throwable instanceof PrivilegedActionException) {
                    exception = ((PrivilegedActionException)throwable).getException();
                }
                if (Debug.DEBUG_GENERAL) {
                    Debug.printStackTrace(exception);
                }
                String string = null;
                string = bundleActivator.getClass().getName();
                throw new BundleException(NLS.bind(Msg.BUNDLE_ACTIVATOR_EXCEPTION, new Object[]{string, "start", this.bundle.getSymbolicName() == null ? new StringBuffer().append(this.bundle.getBundleId()).toString() : this.bundle.getSymbolicName()}), 5, exception);
            }
        }
        finally {
            if (Profile.STARTUP) {
                Profile.logExit("BundleContextImpl.startActivator()");
            }
        }
    }

    Object setContextFinder() {
        ContextFinder contextFinder;
        if (!SET_TCCL) {
            return Boolean.FALSE;
        }
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        if (classLoader != (contextFinder = this.framework.getContextFinder())) {
            thread.setContextClassLoader(this.framework.getContextFinder());
            return classLoader;
        }
        return Boolean.FALSE;
    }

    protected void stop() throws BundleException {
        try {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        if (BundleContextImpl.this.activator != null) {
                            Object object = BundleContextImpl.this.setContextFinder();
                            try {
                                BundleContextImpl.this.activator.stop(BundleContextImpl.this);
                            }
                            finally {
                                if (object != Boolean.FALSE) {
                                    Thread.currentThread().setContextClassLoader((ClassLoader)object);
                                }
                            }
                        }
                        return null;
                    }
                });
            }
            catch (Throwable throwable) {
                Exception exception;
                if (throwable instanceof PrivilegedActionException) {
                    exception = ((PrivilegedActionException)throwable).getException();
                }
                if (Debug.DEBUG_GENERAL) {
                    Debug.printStackTrace(exception);
                }
                String string = this.activator == null ? "" : this.activator.getClass().getName();
                throw new BundleException(NLS.bind(Msg.BUNDLE_ACTIVATOR_EXCEPTION, new Object[]{string, "stop", this.bundle.getSymbolicName() == null ? new StringBuffer().append(this.bundle.getBundleId()).toString() : this.bundle.getSymbolicName()}), 5, exception);
            }
        }
        finally {
            this.activator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ServiceRegistrationImpl<?>, ServiceUse<?>> getServicesInUseMap() {
        Object object = this.contextLock;
        synchronized (object) {
            return this.servicesInUse;
        }
    }

    @Override
    public void dispatchEvent(Object object, Object object2, int n, Object object3) {
        block23: {
            BundleHost bundleHost = this.bundle;
            Object object4 = this.setContextFinder();
            try {
                try {
                    if (!this.isValid()) break block23;
                    switch (n) {
                        case 1: 
                        case 2: {
                            Object object5;
                            BundleListener bundleListener = (BundleListener)object2;
                            if (Debug.DEBUG_EVENTS) {
                                object5 = new StringBuffer(String.valueOf(bundleListener.getClass().getName())).append("@").append(Integer.toHexString(System.identityHashCode(bundleListener))).toString();
                                Debug.println(new StringBuffer("dispatchBundleEvent[").append(bundleHost).append("](").append((String)object5).append(")").toString());
                            }
                            object5 = (BundleEvent)object3;
                            switch (((BundleEvent)object5).getType()) {
                                case -2147483647: {
                                    if (bundleListener instanceof BatchBundleListener) {
                                        ((BatchBundleListener)bundleListener).batchBegin();
                                        break;
                                    }
                                    break block23;
                                }
                                case -2147483648: {
                                    if (bundleListener instanceof BatchBundleListener) {
                                        ((BatchBundleListener)bundleListener).batchEnd();
                                        break;
                                    }
                                    break block23;
                                }
                                default: {
                                    bundleListener.bundleChanged((BundleEvent)object3);
                                    break;
                                }
                            }
                            break;
                        }
                        case 3: {
                            ServiceEvent serviceEvent = (ServiceEvent)object3;
                            ServiceListener serviceListener = (ServiceListener)object2;
                            if (Debug.DEBUG_EVENTS) {
                                String string = new StringBuffer(String.valueOf(serviceListener.getClass().getName())).append("@").append(Integer.toHexString(System.identityHashCode(serviceListener))).toString();
                                Debug.println(new StringBuffer("dispatchServiceEvent[").append(bundleHost).append("](").append(string).append(")").toString());
                            }
                            serviceListener.serviceChanged(serviceEvent);
                            break;
                        }
                        case 4: {
                            FrameworkListener frameworkListener = (FrameworkListener)object2;
                            if (Debug.DEBUG_EVENTS) {
                                String string = new StringBuffer(String.valueOf(frameworkListener.getClass().getName())).append("@").append(Integer.toHexString(System.identityHashCode(frameworkListener))).toString();
                                Debug.println(new StringBuffer("dispatchFrameworkEvent[").append(bundleHost).append("](").append(string).append(")").toString());
                            }
                            frameworkListener.frameworkEvent((FrameworkEvent)object3);
                            break;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                }
                catch (Throwable throwable) {
                    FrameworkEvent frameworkEvent;
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println(new StringBuffer("Exception in bottom level event dispatcher: ").append(throwable.getMessage()).toString());
                        Debug.printStackTrace(throwable);
                    }
                    this.framework.adaptor.handleRuntimeError(throwable);
                    if (n != 4 || (frameworkEvent = (FrameworkEvent)object3).getType() != 2) {
                        this.framework.publishFrameworkEvent(2, bundleHost, throwable);
                    }
                    if (object4 != Boolean.FALSE) {
                        Thread.currentThread().setContextClassLoader((ClassLoader)object4);
                    }
                }
            }
            finally {
                if (object4 != Boolean.FALSE) {
                    Thread.currentThread().setContextClassLoader((ClassLoader)object4);
                }
            }
        }
    }

    @Override
    public Filter createFilter(String string) throws InvalidSyntaxException {
        this.checkValid();
        return FilterImpl.newInstance(string);
    }

    public void checkValid() {
        if (!this.isValid()) {
            throw new IllegalStateException(Msg.BUNDLE_CONTEXT_INVALID_EXCEPTION);
        }
    }

    protected boolean isValid() {
        return this.valid;
    }

    public Framework getFramework() {
        return this.framework;
    }

    @Override
    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S s, Dictionary<String, ?> dictionary) {
        ServiceRegistration<?> serviceRegistration = this.registerService(clazz.getName(), s, dictionary);
        return serviceRegistration;
    }

    @Override
    public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
        ServiceReference<?> serviceReference = this.getServiceReference(clazz.getName());
        return serviceReference;
    }

    @Override
    public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String string) throws InvalidSyntaxException {
        ServiceReference<?>[] serviceReferenceArray = this.getServiceReferences(clazz.getName(), string);
        if (serviceReferenceArray == null) {
            List list = Collections.EMPTY_LIST;
            return list;
        }
        ArrayList<ServiceReference<S>> arrayList = new ArrayList<ServiceReference<S>>(serviceReferenceArray.length);
        ServiceReference<?>[] serviceReferenceArray2 = serviceReferenceArray;
        int n = serviceReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference<?> serviceReference = serviceReferenceArray2[n2];
            arrayList.add(serviceReference);
            ++n2;
        }
        return arrayList;
    }
}

