/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.util.KeyedHashSet;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BundleRepository {
    private List<AbstractBundle> bundlesByInstallOrder;
    private KeyedHashSet bundlesById;
    private Map<String, AbstractBundle[]> bundlesBySymbolicName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleRepository(int n) {
        BundleRepository bundleRepository = this;
        synchronized (bundleRepository) {
            this.bundlesByInstallOrder = new ArrayList<AbstractBundle>(n);
            this.bundlesById = new KeyedHashSet(n, true);
            this.bundlesBySymbolicName = new HashMap<String, AbstractBundle[]>(n);
        }
    }

    public synchronized List<AbstractBundle> getBundles() {
        return this.bundlesByInstallOrder;
    }

    public synchronized AbstractBundle getBundle(long l) {
        Long l2 = new Long(l);
        return (AbstractBundle)this.bundlesById.getByKey(l2);
    }

    public synchronized AbstractBundle[] getBundles(String string) {
        if ("system.bundle".equals(string)) {
            string = Constants.getInternalSymbolicName();
        }
        return this.bundlesBySymbolicName.get(string);
    }

    public synchronized AbstractBundle getBundle(String string, Version version) {
        AbstractBundle[] abstractBundleArray = this.getBundles(string);
        if (abstractBundleArray != null && abstractBundleArray.length > 0) {
            int n = 0;
            while (n < abstractBundleArray.length) {
                if (abstractBundleArray[n].getVersion().equals(version)) {
                    return abstractBundleArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public synchronized void add(AbstractBundle abstractBundle) {
        this.bundlesByInstallOrder.add(abstractBundle);
        this.bundlesById.add(abstractBundle);
        this.addSymbolicName(abstractBundle);
    }

    private void addSymbolicName(AbstractBundle abstractBundle) {
        String string = abstractBundle.getSymbolicName();
        if (string == null) {
            return;
        }
        AbstractBundle[] abstractBundleArray = this.bundlesBySymbolicName.get(string);
        if (abstractBundleArray == null) {
            abstractBundleArray = new AbstractBundle[]{abstractBundle};
            this.bundlesBySymbolicName.put(string, abstractBundleArray);
            return;
        }
        ArrayList<AbstractBundle> arrayList = new ArrayList<AbstractBundle>(abstractBundleArray.length + 1);
        Version version = abstractBundle.getVersion();
        boolean bl = false;
        int n = 0;
        while (n < abstractBundleArray.length) {
            AbstractBundle abstractBundle2 = abstractBundleArray[n];
            Version version2 = abstractBundle2.getVersion();
            if (!bl && version.compareTo(version2) >= 0) {
                bl = true;
                arrayList.add(abstractBundle);
            }
            arrayList.add(abstractBundle2);
            ++n;
        }
        if (!bl) {
            arrayList.add(abstractBundle);
        }
        abstractBundleArray = new AbstractBundle[arrayList.size()];
        arrayList.toArray(abstractBundleArray);
        this.bundlesBySymbolicName.put(string, abstractBundleArray);
    }

    public synchronized boolean remove(AbstractBundle abstractBundle) {
        boolean bl = this.bundlesById.remove(abstractBundle);
        if (!bl) {
            return false;
        }
        this.bundlesByInstallOrder.remove(abstractBundle);
        String string = abstractBundle.getSymbolicName();
        if (string == null) {
            return true;
        }
        this.removeSymbolicName(string, abstractBundle);
        return true;
    }

    private void removeSymbolicName(String string, AbstractBundle abstractBundle) {
        AbstractBundle[] abstractBundleArray = this.bundlesBySymbolicName.get(string);
        if (abstractBundleArray == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < abstractBundleArray.length) {
            if (abstractBundle == abstractBundleArray[n2]) {
                ++n;
                abstractBundleArray[n2] = null;
            }
            ++n2;
        }
        if (n > 0) {
            if (abstractBundleArray.length - n <= 0) {
                this.bundlesBySymbolicName.remove(string);
            } else {
                AbstractBundle[] abstractBundleArray2 = new AbstractBundle[abstractBundleArray.length - n];
                int n3 = 0;
                int n4 = 0;
                while (n4 < abstractBundleArray.length) {
                    if (abstractBundleArray[n4] != null) {
                        abstractBundleArray2[n3] = abstractBundleArray[n4];
                        ++n3;
                    }
                    ++n4;
                }
                this.bundlesBySymbolicName.put(string, abstractBundleArray2);
            }
        }
    }

    public synchronized void update(String string, AbstractBundle abstractBundle) {
        if (string != null) {
            if (!string.equals(abstractBundle.getSymbolicName())) {
                this.removeSymbolicName(string, abstractBundle);
                this.addSymbolicName(abstractBundle);
            }
        } else {
            this.addSymbolicName(abstractBundle);
        }
    }

    public synchronized void removeAllBundles() {
        this.bundlesByInstallOrder.clear();
        this.bundlesById = new KeyedHashSet();
        this.bundlesBySymbolicName.clear();
    }
}

