/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.framework.internal.core.ConsoleManager;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquinoxLauncher
implements org.osgi.framework.launch.Framework {
    private volatile Framework framework;
    private volatile Bundle systemBundle;
    private final Map<String, String> configuration;
    private volatile ConsoleManager consoleMgr = null;

    public EquinoxLauncher(Map<String, String> map) {
        this.configuration = map;
    }

    @Override
    public void init() {
        this.checkAdminPermission("execute");
        if (System.getSecurityManager() == null) {
            this.internalInit();
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    EquinoxLauncher.this.internalInit();
                    return null;
                }
            });
        }
    }

    synchronized Framework internalInit() {
        if ((this.getState() & 0x38) != 0) {
            return this.framework;
        }
        if (System.getSecurityManager() != null && this.configuration.get("org.osgi.framework.security") != null) {
            throw new SecurityException("Cannot specify the \"org.osgi.framework.security\" configuration property when a security manager is already installed.");
        }
        Framework framework = this.framework;
        if (framework != null) {
            framework.close();
            this.framework = null;
            this.systemBundle = null;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            FrameworkProperties.setProperties(this.configuration);
            FrameworkProperties.initializeProperties();
            this.setEquinoxProperties(this.configuration);
            framework = new Framework(new BaseAdaptor(new String[0]));
            this.consoleMgr = ConsoleManager.startConsole(framework);
            framework.launch();
            this.framework = framework;
            this.systemBundle = framework.systemBundle;
        }
        finally {
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            if (classLoader2 != classLoader) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        return framework;
    }

    private void setEquinoxProperties(Map<String, String> map) {
        String string;
        String string2;
        String string3 = string2 = map == null ? null : map.get("osgi.framework.activeThreadType");
        if (string2 == null) {
            if (FrameworkProperties.getProperty("osgi.framework.activeThreadType") == null) {
                FrameworkProperties.setProperty("osgi.framework.activeThreadType", "normal");
            }
        } else {
            FrameworkProperties.setProperty("osgi.framework.activeThreadType", string2);
        }
        if (FrameworkProperties.getProperty(Constants.OSGI_COMPATIBILITY_BOOTDELEGATION) == null) {
            FrameworkProperties.setProperty(Constants.OSGI_COMPATIBILITY_BOOTDELEGATION, "false");
        }
        if (FrameworkProperties.getProperty("osgi.support.multipleHosts") == null) {
            FrameworkProperties.setProperty("osgi.support.multipleHosts", "true");
        }
        String string4 = string = map == null ? null : map.get("org.osgi.framework.windowsystem");
        if (string == null && (string = FrameworkProperties.getProperty("osgi.ws")) != null) {
            FrameworkProperties.setProperty("org.osgi.framework.windowsystem", string);
        }
        if (map == null) {
            return;
        }
        String string5 = map.get("org.osgi.framework.storage.clean");
        if ("onFirstInit".equals(string5)) {
            map.remove("org.osgi.framework.storage.clean");
            FrameworkProperties.setProperty("osgi.clean", Boolean.TRUE.toString());
        }
    }

    @Override
    public FrameworkEvent waitForStop(long l) throws InterruptedException {
        Framework framework = this.framework;
        if (framework == null) {
            return new FrameworkEvent(64, this, null);
        }
        return framework.waitForStop(l);
    }

    @Override
    public Enumeration<URL> findEntries(String string, String string2, boolean bl) {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.findEntries(string, string2, bl);
    }

    @Override
    public BundleContext getBundleContext() {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.getBundleContext();
    }

    @Override
    public long getBundleId() {
        return 0L;
    }

    @Override
    public URL getEntry(String string) {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.getEntry(string);
    }

    @Override
    public Enumeration<String> getEntryPaths(String string) {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.getEntryPaths(string);
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.getHeaders();
    }

    @Override
    public Dictionary<String, String> getHeaders(String string) {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.getHeaders(string);
    }

    @Override
    public long getLastModified() {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return System.currentTimeMillis();
        }
        return bundle.getLastModified();
    }

    @Override
    public String getLocation() {
        return "System Bundle";
    }

    @Override
    public ServiceReference<?>[] getRegisteredServices() {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.getRegisteredServices();
    }

    @Override
    public URL getResource(String string) {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.getResource(string);
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.getResources(string);
    }

    @Override
    public ServiceReference<?>[] getServicesInUse() {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.getServicesInUse();
    }

    @Override
    public int getState() {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return 2;
        }
        return bundle.getState();
    }

    @Override
    public String getSymbolicName() {
        return "org.eclipse.osgi";
    }

    @Override
    public boolean hasPermission(Object object) {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return false;
        }
        return bundle.hasPermission(object);
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.loadClass(string);
    }

    @Override
    public void start(int n) throws BundleException {
        this.start();
    }

    @Override
    public void start() throws BundleException {
        this.checkAdminPermission("execute");
        if (System.getSecurityManager() == null) {
            this.internalStart();
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() {
                        EquinoxLauncher.this.internalStart();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (BundleException)privilegedActionException.getException();
            }
        }
    }

    private void checkAdminPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this, string));
        }
    }

    void internalStart() {
        if (this.getState() == 32) {
            return;
        }
        Framework framework = this.internalInit();
        int n = 1;
        try {
            n = Integer.parseInt(this.configuration.get("org.osgi.framework.startlevel.beginning"));
        }
        catch (Throwable throwable) {}
        framework.startLevelManager.doSetStartLevel(n, new FrameworkListener[0]);
    }

    @Override
    public void stop(int n) throws BundleException {
        this.stop();
    }

    @Override
    public void stop() throws BundleException {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return;
        }
        ConsoleManager consoleManager = this.consoleMgr;
        if (consoleManager != null) {
            consoleManager.stopConsole();
            this.consoleMgr = null;
        }
        bundle.stop();
    }

    @Override
    public void uninstall() throws BundleException {
        throw new BundleException(Msg.BUNDLE_SYSTEMBUNDLE_UNINSTALL_EXCEPTION, 2);
    }

    @Override
    public void update() throws BundleException {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return;
        }
        bundle.update();
    }

    @Override
    public void update(InputStream inputStream) throws BundleException {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        this.update();
    }

    @Override
    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int n) {
        Bundle bundle = this.systemBundle;
        if (bundle != null) {
            return bundle.getSignerCertificates(n);
        }
        Map map = Collections.EMPTY_MAP;
        return map;
    }

    @Override
    public Version getVersion() {
        Bundle bundle = this.systemBundle;
        if (bundle != null) {
            return bundle.getVersion();
        }
        return Version.emptyVersion;
    }

    @Override
    public <A> A adapt(Class<A> clazz) {
        Bundle bundle = this.systemBundle;
        if (bundle != null) {
            return bundle.adapt(clazz);
        }
        return null;
    }

    @Override
    public int compareTo(Bundle bundle) {
        Bundle bundle2 = this.systemBundle;
        if (bundle2 != null) {
            return bundle2.compareTo(bundle);
        }
        throw new IllegalStateException();
    }

    @Override
    public File getDataFile(String string) {
        Bundle bundle = this.systemBundle;
        if (bundle != null) {
            return bundle.getDataFile(string);
        }
        return null;
    }
}

