/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.BundleLoaderProxy;
import org.eclipse.osgi.internal.loader.PackageSource;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;

public class ExportedPackageImpl
implements ExportedPackage {
    private final ExportPackageDescription exportedPackage;
    private final BundleLoaderProxy supplier;

    public ExportedPackageImpl(ExportPackageDescription exportPackageDescription, BundleLoaderProxy bundleLoaderProxy) {
        this.exportedPackage = exportPackageDescription;
        this.supplier = bundleLoaderProxy;
    }

    public String getName() {
        return this.exportedPackage.getName();
    }

    public Bundle getExportingBundle() {
        if (this.supplier.isStale()) {
            return null;
        }
        return this.supplier.getBundleHost();
    }

    AbstractBundle getBundle() {
        return this.supplier.getBundleHost();
    }

    public Bundle[] getImportingBundles() {
        if (this.supplier.isStale()) {
            return null;
        }
        AbstractBundle abstractBundle = (AbstractBundle)this.getExportingBundle();
        if (abstractBundle == null) {
            return null;
        }
        AbstractBundle[] abstractBundleArray = abstractBundle.framework.getAllBundles();
        ArrayList<AbstractBundle> arrayList = new ArrayList<AbstractBundle>(10);
        PackageSource packageSource = this.supplier.createPackageSource(this.exportedPackage, false);
        int n = 0;
        while (n < abstractBundleArray.length) {
            BundleLoader bundleLoader;
            if (abstractBundleArray[n] instanceof BundleHost && (bundleLoader = ((BundleHost)abstractBundleArray[n]).getBundleLoader()) != null && bundleLoader.getBundle() != this.supplier.getBundle()) {
                PackageSource packageSource2 = bundleLoader.getPackageSource(this.getName());
                if (packageSource != null && packageSource.hasCommonSource(packageSource2)) {
                    arrayList.add(abstractBundleArray[n]);
                }
            }
            ++n;
        }
        return arrayList.toArray(new Bundle[arrayList.size()]);
    }

    public String getSpecificationVersion() {
        return this.exportedPackage.getVersion().toString();
    }

    public Version getVersion() {
        return this.exportedPackage.getVersion();
    }

    public boolean isRemovalPending() {
        BundleDescription bundleDescription = this.exportedPackage.getExporter();
        if (bundleDescription != null) {
            return bundleDescription.isRemovalPending();
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getName());
        stringBuffer.append("; ").append("version");
        stringBuffer.append("=\"").append(this.exportedPackage.getVersion().toString()).append("\"");
        return stringBuffer.toString();
    }
}

