/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.console.ConsoleSession;
import org.eclipse.osgi.framework.internal.core.ConsoleMsg;
import org.eclipse.osgi.framework.internal.core.FrameworkCommandInterpreter;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Util;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkConsole
implements Runnable {
    private final BufferedReader in;
    private final PrintWriter out;
    private final BundleContext context;
    private final ServiceTracker<CommandProvider, CommandProvider> cptracker;
    private final ConsoleSession consoleSession;
    private final boolean isSystemInOut;
    static final String defaultEncoding = "iso8859-1";
    static final String encoding = FrameworkProperties.getProperty("osgi.console.encoding", FrameworkProperties.getProperty("file.encoding", "iso8859-1"));
    private static final boolean blockOnready = FrameworkProperties.getProperty("osgi.dev") != null || FrameworkProperties.getProperty("osgi.console.blockOnReady") != null;
    volatile boolean shutdown = false;

    public FrameworkConsole(BundleContext bundleContext, ConsoleSession consoleSession, boolean bl, ServiceTracker<CommandProvider, CommandProvider> serviceTracker) {
        this.context = bundleContext;
        this.cptracker = serviceTracker;
        this.isSystemInOut = bl;
        this.consoleSession = consoleSession;
        this.in = FrameworkConsole.createBufferedReader(consoleSession.getInput());
        this.out = FrameworkConsole.createPrintWriter(consoleSession.getOutput());
    }

    static BufferedReader createBufferedReader(InputStream inputStream) {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        }
        return bufferedReader;
    }

    static PrintWriter createPrintWriter(OutputStream outputStream) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream, encoding)), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream)), true);
        }
        return printWriter;
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    @Override
    public void run() {
        try {
            this.runConsole();
        }
        finally {
            this.shutdown();
        }
    }

    private void runConsole() {
        String string = new StringBuffer("\r\n").append(ConsoleMsg.CONSOLE_PROMPT).toString();
        while (!this.shutdown) {
            String string2;
            block8: {
                this.out.print(string);
                this.out.flush();
                string2 = null;
                try {
                    if (blockOnready && this.isSystemInOut) {
                        try {
                            while (!this.in.ready()) {
                                Thread.sleep(300L);
                            }
                            string2 = this.in.readLine();
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        string2 = this.in.readLine();
                    }
                }
                catch (IOException iOException) {
                    if (this.shutdown) break block8;
                    iOException.printStackTrace(this.out);
                }
            }
            if (string2 == null) break;
            if (this.shutdown) continue;
            this.docommand(string2);
        }
    }

    protected void docommand(String string) {
        FrameworkCommandInterpreter frameworkCommandInterpreter;
        String string2;
        if (string != null && string.length() > 0 && (string2 = (frameworkCommandInterpreter = new FrameworkCommandInterpreter(string, this.getServices(), this)).nextArgument()) != null) {
            frameworkCommandInterpreter.execute(string2);
        }
    }

    public String getInput() {
        String string;
        try {
            string = this.in.readLine();
            System.out.println(new StringBuffer("<").append(string).append(">").toString());
        }
        catch (IOException iOException) {
            string = "";
        }
        return string;
    }

    public CommandProvider[] getServices() {
        Object[] objectArray = this.cptracker.getServiceReferences();
        if (objectArray == null) {
            return new CommandProvider[0];
        }
        Util.dsort(objectArray, 0, objectArray.length);
        CommandProvider[] commandProviderArray = new CommandProvider[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            commandProviderArray[n] = (CommandProvider)this.context.getService(objectArray[n]);
            ++n;
        }
        return commandProviderArray;
    }

    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.consoleSession.close();
    }
}

