/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tokenizer {
    protected char[] value;
    protected int max;
    protected int cursor;

    public Tokenizer(String string) {
        this.value = string.toCharArray();
        this.max = this.value.length;
        this.cursor = 0;
    }

    private void skipWhiteSpace() {
        char[] cArray = this.value;
        int n = this.cursor;
        while (n < this.max) {
            char c = cArray[n];
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r') break;
            ++n;
        }
        this.cursor = n;
    }

    public String getToken(String string) {
        int n;
        int n2;
        this.skipWhiteSpace();
        char[] cArray = this.value;
        int n3 = n2 = this.cursor;
        while (n2 < this.max) {
            n = cArray[n2];
            if (string.indexOf(n) != -1) break;
            ++n2;
        }
        this.cursor = n2;
        n = n2 - n3;
        if (n > 0) {
            this.skipWhiteSpace();
            while (n > 0 && (cArray[n3 + n - 1] == ' ' || cArray[n3 + n - 1] == '\t')) {
                --n;
            }
            return new String(cArray, n3, n);
        }
        return null;
    }

    public String getEscapedToken(String string) {
        char[] cArray = this.value;
        int n = this.cursor;
        if (n >= this.max) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n < this.max) {
            char c = cArray[n];
            if (c == '\\') {
                if (++n == this.max) break;
                c = cArray[n];
            } else if (string.indexOf(c) != -1) break;
            stringBuffer.append(c);
            ++n;
        }
        this.cursor = n;
        return stringBuffer.toString();
    }

    public List<String> getEscapedTokens(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.getEscapedToken(string);
        while (string2 != null) {
            arrayList.add(string2);
            this.getChar();
            string2 = this.getEscapedToken(string);
        }
        return arrayList;
    }

    public String getString(String string, String string2) {
        this.skipWhiteSpace();
        char[] cArray = this.value;
        int n = this.cursor;
        if (n < this.max) {
            if (cArray[n] == '\"') {
                StringBuffer stringBuffer = new StringBuffer();
                char c = '\u0000';
                int n2 = ++n;
                while (n < this.max) {
                    c = cArray[n];
                    if (c == '\\') {
                        if (++n == this.max) break;
                        c = cArray[n];
                        if (string2 != null && string2.indexOf(c) != -1) {
                            stringBuffer.append('\\');
                        }
                    } else if (c == '\"') break;
                    stringBuffer.append(c);
                    ++n;
                }
                int n3 = n - n2;
                if (c == '\"') {
                    ++n;
                }
                this.cursor = n;
                if (n3 > 0) {
                    this.skipWhiteSpace();
                    return stringBuffer.toString();
                }
            } else {
                return this.getToken(string);
            }
        }
        return null;
    }

    public String getString(String string) {
        return this.getString(string, null);
    }

    public char getChar() {
        int n = this.cursor;
        if (n < this.max) {
            this.cursor = n + 1;
            return this.value[n];
        }
        return '\u0000';
    }

    public boolean hasMoreTokens() {
        return this.cursor < this.max;
    }
}

