/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.protocol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.eclipse.osgi.framework.internal.protocol.NullURLStreamHandlerService;
import org.eclipse.osgi.framework.internal.protocol.StreamHandlerFactory;
import org.eclipse.osgi.framework.internal.protocol.URLStreamHandlerSetter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLStreamHandlerProxy
extends URLStreamHandler
implements ServiceTrackerCustomizer<URLStreamHandlerService, ServiceReference<URLStreamHandlerService>> {
    protected URLStreamHandlerService realHandlerService;
    protected URLStreamHandlerSetter urlSetter;
    protected ServiceTracker<URLStreamHandlerService, ServiceReference<URLStreamHandlerService>> urlStreamHandlerServiceTracker;
    protected BundleContext context;
    protected ServiceReference<URLStreamHandlerService> urlStreamServiceReference;
    protected String protocol;
    protected int ranking = Integer.MIN_VALUE;

    public URLStreamHandlerProxy(String string, ServiceReference<URLStreamHandlerService> serviceReference, BundleContext bundleContext) {
        this.context = bundleContext;
        this.protocol = string;
        this.urlSetter = new URLStreamHandlerSetter(this);
        this.setNewHandler(serviceReference, this.getRank(serviceReference));
        this.urlStreamHandlerServiceTracker = new ServiceTracker<URLStreamHandlerService, ServiceReference<URLStreamHandlerService>>(bundleContext, "org.osgi.service.url.URLStreamHandlerService", this);
        StreamHandlerFactory.secureAction.open(this.urlStreamHandlerServiceTracker);
    }

    private void setNewHandler(ServiceReference<URLStreamHandlerService> serviceReference, int n) {
        if (this.urlStreamServiceReference != null) {
            this.context.ungetService(this.urlStreamServiceReference);
        }
        this.urlStreamServiceReference = serviceReference;
        this.ranking = n;
        this.realHandlerService = serviceReference == null ? new NullURLStreamHandlerService() : StreamHandlerFactory.secureAction.getService(serviceReference, this.context);
    }

    @Override
    protected boolean equals(URL uRL, URL uRL2) {
        return this.realHandlerService.equals(uRL, uRL2);
    }

    @Override
    protected int getDefaultPort() {
        return this.realHandlerService.getDefaultPort();
    }

    @Override
    protected InetAddress getHostAddress(URL uRL) {
        return this.realHandlerService.getHostAddress(uRL);
    }

    @Override
    protected int hashCode(URL uRL) {
        return this.realHandlerService.hashCode(uRL);
    }

    @Override
    protected boolean hostsEqual(URL uRL, URL uRL2) {
        return this.realHandlerService.hostsEqual(uRL, uRL2);
    }

    @Override
    protected URLConnection openConnection(URL uRL) throws IOException {
        return this.realHandlerService.openConnection(uRL);
    }

    @Override
    protected void parseURL(URL uRL, String string, int n, int n2) {
        this.realHandlerService.parseURL(this.urlSetter, uRL, string, n, n2);
    }

    @Override
    protected boolean sameFile(URL uRL, URL uRL2) {
        return this.realHandlerService.sameFile(uRL, uRL2);
    }

    @Override
    protected String toExternalForm(URL uRL) {
        return this.realHandlerService.toExternalForm(uRL);
    }

    @Override
    public void setURL(URL uRL, String string, String string2, int n, String string3, String string4, String string5, String string6, String string7) {
        super.setURL(uRL, string, string2, n, string3, string4, string5, string6, string7);
    }

    @Override
    public void setURL(URL uRL, String string, String string2, int n, String string3, String string4) {
        super.setURL(uRL, string, string2, n, null, null, string3, null, string4);
    }

    @Override
    public ServiceReference<URLStreamHandlerService> addingService(ServiceReference<URLStreamHandlerService> serviceReference) {
        Object object = serviceReference.getProperty("url.handler.protocol");
        if (!(object instanceof String[])) {
            return null;
        }
        String[] stringArray = (String[])object;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(this.protocol)) {
                int n2 = this.getRank(serviceReference);
                if (n2 > this.ranking || this.urlStreamServiceReference == null) {
                    this.setNewHandler(serviceReference, n2);
                }
                return serviceReference;
            }
            ++n;
        }
        return null;
    }

    @Override
    public void modifiedService(ServiceReference<URLStreamHandlerService> serviceReference, ServiceReference<URLStreamHandlerService> serviceReference2) {
        int n = this.getRank(serviceReference);
        if (serviceReference == this.urlStreamServiceReference) {
            ServiceReference<URLStreamHandlerService> serviceReference3;
            if (n < this.ranking && (serviceReference3 = this.urlStreamHandlerServiceTracker.getServiceReference()) != this.urlStreamServiceReference && serviceReference3 != null) {
                this.setNewHandler(serviceReference3, (Integer)serviceReference3.getProperty("service.ranking"));
            }
        } else if (n > this.ranking) {
            this.setNewHandler(serviceReference, n);
        }
    }

    @Override
    public void removedService(ServiceReference<URLStreamHandlerService> serviceReference, ServiceReference<URLStreamHandlerService> serviceReference2) {
        if (serviceReference != this.urlStreamServiceReference) {
            return;
        }
        ServiceReference<URLStreamHandlerService> serviceReference3 = this.urlStreamHandlerServiceTracker.getServiceReference();
        this.setNewHandler(serviceReference3, this.getRank(serviceReference3));
    }

    private int getRank(ServiceReference<?> serviceReference) {
        if (serviceReference == null) {
            return Integer.MIN_VALUE;
        }
        Object object = serviceReference.getProperty("service.ranking");
        return object instanceof Integer ? (Integer)object : 0;
    }
}

