/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.util.ManifestElement;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DevClassPathHelper {
    private static final String FILE_PROTOCOL = "file";
    private static final boolean inDevelopmentMode;
    private static final File devLocation;
    private static String[] devDefaultClasspath;
    private static Dictionary<String, String> devProperties;
    private static long lastModified;
    static /* synthetic */ Class class$0;

    static {
        devProperties = null;
        lastModified = 0L;
        String string = FrameworkProperties.getProperty("osgi.dev");
        File file = null;
        boolean bl = false;
        if (string != null) {
            try {
                bl = true;
                URL uRL = new URL(string);
                if (FILE_PROTOCOL.equals(uRL.getProtocol())) {
                    file = new File(uRL.getFile());
                    lastModified = file.lastModified();
                }
                try {
                    DevClassPathHelper.load(uRL.openStream());
                    bl = true;
                }
                catch (IOException iOException) {}
            }
            catch (MalformedURLException malformedURLException) {
                devDefaultClasspath = DevClassPathHelper.getArrayFromList(string);
            }
        }
        inDevelopmentMode = bl;
        devLocation = file;
    }

    private static void updateDevProperties() {
        if (devLocation == null) {
            return;
        }
        if (devLocation.lastModified() == lastModified) {
            return;
        }
        try {
            DevClassPathHelper.load(new FileInputStream(devLocation));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        lastModified = devLocation.lastModified();
    }

    private static String[] getDevClassPath(String string, Dictionary<String, String> dictionary, String[] stringArray) {
        String string2;
        String[] stringArray2 = null;
        if (string != null && dictionary != null && (string2 = dictionary.get(string)) != null) {
            stringArray2 = DevClassPathHelper.getArrayFromList(string2);
        }
        if (stringArray2 == null) {
            stringArray2 = stringArray;
        }
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getDevClassPath(String string, Dictionary<String, String> dictionary) {
        if (dictionary == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.internal.baseadaptor.DevClassPathHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            synchronized (clazz) {
                DevClassPathHelper.updateDevProperties();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return DevClassPathHelper.getDevClassPath(string, devProperties, devDefaultClasspath);
            }
        }
        return DevClassPathHelper.getDevClassPath(string, dictionary, DevClassPathHelper.getArrayFromList(dictionary.get("*")));
    }

    public static String[] getDevClassPath(String string) {
        return DevClassPathHelper.getDevClassPath(string, null);
    }

    public static String[] getArrayFromList(String string) {
        return ManifestElement.getArrayFromList(string, ",");
    }

    public static boolean inDevelopmentMode() {
        return inDevelopmentMode;
    }

    private static void load(InputStream inputStream) {
        Properties properties;
        Properties properties2;
        block15: {
            properties2 = new Properties();
            try {
                try {
                    properties2.load(inputStream);
                }
                catch (IOException iOException) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if ((devProperties = (properties = properties2)) != null) {
            devDefaultClasspath = DevClassPathHelper.getArrayFromList(devProperties.get("*"));
        }
    }
}

