/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.profile;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.internal.profile.ProfileLogger;

public class DefaultProfileLogger
implements ProfileLogger {
    protected static final String DEFAULTPROFILE_PROP = "osgi.defaultprofile.";
    protected static final String PROP_FILENAME = "osgi.defaultprofile.logfilename";
    protected static final String PROP_LOGSYNCHRONOUSLY = "osgi.defaultprofile.logsynchronously";
    protected static final String PROP_BUFFERSIZE = "osgi.defaultprofile.buffersize";
    protected static final String DEFAULTPROFILE_OPTION = "org.eclipse.osgi/defaultprofile/";
    protected static final String OPTION_FILENAME = "org.eclipse.osgi/defaultprofile/logfilename";
    protected static final String OPTION_LOGSYNCHRONOUSLY = "org.eclipse.osgi/defaultprofile/logsynchronously";
    protected static final String OPTION_BUFFERSIZE = "org.eclipse.osgi/defaultprofile/buffersize";
    protected boolean logSynchronously = false;
    protected long startTime = 0L;
    protected static final int DEFAULT_BUFFER_SIZE = 256;
    protected TimeEntry[] timeLogEntries = null;
    protected int timeEntriesIndex = 0;
    protected StringBuffer timelog = null;
    protected long launchTime = -1L;
    protected int bufferSize = 256;
    protected String logFileName = null;
    protected File logFile = null;
    private StringBuffer entryReport = new StringBuffer(120);
    private StringBuffer padsb = new StringBuffer(16);
    protected int indent;
    protected int timePaddingLength;
    protected Stack<AccumPerfScope> scopeStack;
    protected Map<String, AccumPerfData> scopeToAccumPerfDataMap;

    public DefaultProfileLogger() {
        this.initProps();
        int n = this.getBufferSize();
        this.timeLogEntries = new TimeEntry[n];
        this.timelog = new StringBuffer(4096);
        int n2 = 0;
        while (n2 < n) {
            this.timeLogEntries[n2] = this.timeEntryFactory();
            ++n2;
        }
        this.timeEntriesIndex = 0;
        this.launchTime = this.getLaunchTime();
        this.startTime = this.launchTime == -1L ? this.getMainStartTime() : this.launchTime;
        long l = this.getTimerFrequency();
        this.timePaddingLength = 3;
        while (l > 9L) {
            l /= 10L;
            ++this.timePaddingLength;
        }
        this.logInitMessages();
    }

    protected void logInitMessages() {
        int n = 0;
        if (this.launchTime != -1L) {
            this.logTime(0, "DefaultProfileLogger.init()", "launch time initialized", null);
            this.timeLogEntries[n++].time = this.launchTime;
        }
        this.logTime(0, "DefaultProfileLogger.init()", "start time initialized", null);
        this.timeLogEntries[n++].time = this.getMainStartTime();
    }

    protected long getLaunchTime() {
        String string = FrameworkProperties.getProperty("launch.startMillis");
        if (string != null) {
            return Long.parseLong(string);
        }
        return -1L;
    }

    protected long getMainStartTime() {
        String string = FrameworkProperties.getProperty("eclipse.startTime");
        if (string != null) {
            return Long.parseLong(string);
        }
        return System.currentTimeMillis();
    }

    public void initProps() {
        String string;
        int n;
        FrameworkDebugOptions frameworkDebugOptions = null;
        if (FrameworkProperties.getProperty("osgi.debug") != null && (frameworkDebugOptions = FrameworkDebugOptions.getDefault()) != null) {
            this.logFileName = frameworkDebugOptions.getOption(OPTION_FILENAME);
            this.logSynchronously = frameworkDebugOptions.getBooleanOption(OPTION_LOGSYNCHRONOUSLY, false);
            n = frameworkDebugOptions.getIntegerOption(OPTION_BUFFERSIZE, 0);
            if (n > 0) {
                this.bufferSize = n;
            }
        }
        if ((string = FrameworkProperties.getProperty(PROP_FILENAME)) != null) {
            this.logFileName = string;
            if (frameworkDebugOptions != null) {
                frameworkDebugOptions.setOption(OPTION_FILENAME, this.logFileName);
            }
        }
        if ((string = FrameworkProperties.getProperty(PROP_LOGSYNCHRONOUSLY)) != null) {
            this.logSynchronously = Boolean.valueOf(string);
            if (frameworkDebugOptions != null) {
                frameworkDebugOptions.setOption(OPTION_LOGSYNCHRONOUSLY, new Boolean(this.logSynchronously).toString());
            }
        }
        if ((string = FrameworkProperties.getProperty(PROP_BUFFERSIZE)) != null) {
            try {
                n = Integer.parseInt(string);
                if (n > 0) {
                    this.bufferSize = n;
                    if (frameworkDebugOptions != null) {
                        frameworkDebugOptions.setOption(OPTION_BUFFERSIZE, Integer.toString(this.bufferSize));
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public synchronized void logTime(int n, String string, String string2, String string3) {
        if (this.timeEntriesIndex == this.timeLogEntries.length) {
            this.makeLog();
            this.logTime(0, "Profile.logTime()", "log entries rolled", null);
        }
        TimeEntry timeEntry = this.timeLogEntries[this.timeEntriesIndex++];
        timeEntry.time = this.getTime();
        timeEntry.id = string;
        timeEntry.msg = string2;
        timeEntry.flag = n;
        timeEntry.description = string3;
        if (this.logSynchronously) {
            System.out.print(this.getProfileLog().substring(2));
        }
    }

    public synchronized String getProfileLog() {
        String string = this.getProfileLogReport();
        this.writeToProfileLogFile(string);
        return string;
    }

    public synchronized void accumLogEnter(String string) {
        if (this.scopeStack == null) {
            this.scopeStack = new Stack();
        }
        if (this.scopeToAccumPerfDataMap == null) {
            this.scopeToAccumPerfDataMap = new TreeMap<String, AccumPerfData>();
        }
        this.scopeStack.push(new AccumPerfScope(string, this.getTime()));
    }

    public synchronized void accumLogExit(String string) {
        AccumPerfScope accumPerfScope;
        long l = this.getTime();
        if (this.scopeStack == null) {
            this.scopeStack = new Stack();
        }
        if (this.scopeToAccumPerfDataMap == null) {
            this.scopeToAccumPerfDataMap = new TreeMap<String, AccumPerfData>();
        }
        if ((accumPerfScope = this.scopeStack.pop()) == null) {
            System.err.println("ACCUM PERF ERROR: Scope stack empty: " + string);
        } else {
            AccumPerfData accumPerfData;
            if (!accumPerfScope.scope.equals(string)) {
                System.err.println("ACCUM PERF ERROR: Scope mismatch: then='" + accumPerfScope.scope + "', now='" + string + "'");
            }
            if ((accumPerfData = this.scopeToAccumPerfDataMap.get(string)) == null) {
                accumPerfData = new AccumPerfData(string);
                this.scopeToAccumPerfDataMap.put(string, accumPerfData);
            }
            accumPerfData.time += l - accumPerfScope.enter;
            ++accumPerfData.enters;
        }
    }

    protected long getTime() {
        return System.currentTimeMillis();
    }

    protected long getTimerFrequency() {
        return 1000L;
    }

    protected TimeEntry findCompareEntry(int n, String string, int n2) {
        if (n > 0) {
            --n;
        }
        int n3 = n;
        if (n2 != 1) {
            while (n >= 0) {
                TimeEntry timeEntry = this.timeLogEntries[n];
                if (timeEntry.id.equals(string)) {
                    switch (n2) {
                        case 0: {
                            return timeEntry;
                        }
                        case 2: {
                            if (timeEntry.flag != 1) break;
                            return timeEntry;
                        }
                    }
                }
                --n;
            }
        }
        return this.timeLogEntries[n3];
    }

    protected String entryReport(TimeEntry timeEntry, TimeEntry timeEntry2) {
        this.entryReport.setLength(0);
        if (timeEntry.flag == 1) {
            ++this.indent;
        }
        long l = this.getRelativeTime(this.getStartTime());
        this.entryReport.append('-');
        long l2 = this.getRelativeTime(timeEntry.time);
        long l3 = l2 - l;
        this.entryReport.append(this.pad(Long.toString(l3), this.timePaddingLength));
        this.entryReport.append(" :");
        l3 = timeEntry.time - timeEntry2.time;
        this.entryReport.append(this.pad(Long.toString(l3), this.timePaddingLength));
        this.entryReport.append(this.pad("", this.indent * 2));
        if (timeEntry.flag == 1) {
            this.entryReport.append(" >> ");
        } else if (timeEntry.flag == 2) {
            this.entryReport.append(" << ");
        } else if (timeEntry.flag == 0) {
            this.entryReport.append(" -- ");
        }
        this.entryReport.append(timeEntry.id);
        this.entryReport.append(" > ");
        this.entryReport.append(timeEntry.msg);
        if (timeEntry.description != null) {
            this.entryReport.append(" :: ");
            this.entryReport.append(timeEntry.description);
        }
        this.entryReport.append("\r\n");
        if (timeEntry.flag == 2) {
            --this.indent;
        }
        return this.entryReport.toString();
    }

    protected String accumEntryReport(AccumPerfData accumPerfData) {
        return "     " + accumPerfData.scope + ":enters=" + accumPerfData.enters + ";time=" + accumPerfData.time + ";\r\n";
    }

    protected void makeLog() {
        Object object;
        this.indent = 0;
        this.timelog.append("\r\n");
        int n = 0;
        while (n < this.timeEntriesIndex) {
            object = this.timeLogEntries[n];
            TimeEntry timeEntry = this.findCompareEntry(n, ((TimeEntry)object).id, ((TimeEntry)object).flag);
            this.timelog.append(this.entryReport((TimeEntry)object, timeEntry));
            ++n;
        }
        this.timeEntriesIndex = 0;
        if (this.scopeToAccumPerfDataMap == null || this.scopeToAccumPerfDataMap.isEmpty()) {
            return;
        }
        this.timelog.append("\r\n");
        this.timelog.append("Cumulative Log:\r\n");
        object = this.scopeToAccumPerfDataMap.values().iterator();
        while (object.hasNext()) {
            AccumPerfData accumPerfData = (AccumPerfData)object.next();
            this.timelog.append(this.accumEntryReport(accumPerfData));
        }
        this.scopeToAccumPerfDataMap.clear();
    }

    protected String pad(String string, int n) {
        this.padsb.setLength(0);
        int n2 = string.length();
        int n3 = n - n2;
        int n4 = 0;
        while (n4 < n3) {
            this.padsb.append(' ');
            ++n4;
        }
        this.padsb.append(string);
        return this.padsb.toString();
    }

    protected String getProfileLogReport() {
        if (this.timelog == null) {
            return "";
        }
        this.makeLog();
        String string = this.timelog.toString();
        this.timelog.setLength(0);
        return string;
    }

    protected void writeToProfileLogFile(String string) {
        block15: {
            File file = this.getProfileLogFile();
            if (file == null) {
                return;
            }
            OutputStreamWriter outputStreamWriter = null;
            try {
                try {
                    outputStreamWriter = new FileWriter(file.getAbsolutePath(), true);
                    outputStreamWriter.write(string);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if (outputStreamWriter != null) {
                        try {
                            outputStreamWriter.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected File getProfileLogFile() {
        if (this.logFile == null && this.logFileName != null && this.logFileName.length() > 0) {
            this.logFile = new File(this.logFileName);
        }
        return this.logFile;
    }

    protected long getStartTime() {
        return this.startTime;
    }

    protected long getRelativeTime(long l) {
        return l;
    }

    protected int getBufferSize() {
        if (this.bufferSize < 2) {
            return 256;
        }
        return this.bufferSize;
    }

    protected TimeEntry timeEntryFactory() {
        return new TimeEntry();
    }

    protected static class AccumPerfData {
        public String scope;
        public long time;
        public long enters;

        public AccumPerfData(String string) {
            this.scope = string;
        }
    }

    protected static class AccumPerfScope {
        public String scope;
        public long enter;

        public AccumPerfScope(String string, long l) {
            this.scope = string;
            this.enter = l;
        }
    }

    protected class TimeEntry {
        public long time;
        public String id;
        public String msg;
        public String description;
        public int flag;

        protected TimeEntry() {
        }
    }
}

