/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ComputeNodeOrder {
    private ComputeNodeOrder() {
    }

    public static Object[][] computeNodeOrder(Object[] objectArray, Object[][] objectArray2) {
        Object[][] objectArray3;
        Digraph digraph = new Digraph();
        int n = 0;
        while (n < objectArray.length) {
            digraph.addVertex(objectArray[n]);
            ++n;
        }
        n = 0;
        while (n < objectArray2.length) {
            digraph.addEdge(objectArray2[n][1], objectArray2[n][0]);
            ++n;
        }
        digraph.freeze();
        Digraph digraph2 = new Digraph();
        List<Object> list = digraph.idsByDFSFinishTime(false);
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            digraph2.addVertex(iterator.next());
        }
        int n2 = 0;
        while (n2 < objectArray2.length) {
            digraph2.addEdge(objectArray2[n2][0], objectArray2[n2][1]);
            ++n2;
        }
        digraph2.freeze();
        List<Object> list2 = digraph2.idsByDFSFinishTime(true);
        Object[] objectArray4 = new Object[list2.size()];
        list2.toArray(objectArray4);
        boolean bl = digraph2.containsCycles();
        if (bl) {
            List<Object[]> list3 = digraph2.nonTrivialComponents();
            objectArray3 = (Object[][])list3.toArray((T[])new Object[list3.size()][]);
        } else {
            objectArray3 = new Object[][]{};
        }
        int n3 = 0;
        while (n3 < objectArray4.length) {
            objectArray[n3] = objectArray4[n3];
            ++n3;
        }
        return objectArray3;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Digraph {
        private List<Vertex> vertexList = new ArrayList<Vertex>(100);
        private Map<Object, Vertex> vertexMap = new HashMap<Object, Vertex>(100);
        private int time;
        private boolean initialized = false;
        private boolean cycles = false;

        public void freeze() {
            if (!this.initialized) {
                this.initialized = true;
                this.DFS();
            }
        }

        public void addVertex(Object object) throws IllegalArgumentException {
            if (this.initialized) {
                throw new IllegalArgumentException();
            }
            Vertex vertex = new Vertex(object);
            Vertex vertex2 = this.vertexMap.put(object, vertex);
            if (vertex2 != null) {
                throw new IllegalArgumentException();
            }
            this.vertexList.add(vertex);
        }

        public void addEdge(Object object, Object object2) throws IllegalArgumentException {
            if (this.initialized) {
                throw new IllegalArgumentException();
            }
            Vertex vertex = this.vertexMap.get(object);
            Vertex vertex2 = this.vertexMap.get(object2);
            if (vertex == null || vertex2 == null) {
                return;
            }
            vertex.adjacent.add(vertex2);
        }

        public List<Object> idsByDFSFinishTime(boolean bl) {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            int n = this.vertexList.size();
            Object[] objectArray = new Object[n];
            for (Vertex vertex : this.vertexList) {
                int n2 = vertex.finishTime;
                if (bl) {
                    objectArray[n2 - 1] = vertex.id;
                    continue;
                }
                objectArray[n - n2] = vertex.id;
            }
            return Arrays.asList(objectArray);
        }

        public boolean containsCycles() {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            return this.cycles;
        }

        public List<Object[]> nonTrivialComponents() {
            if (!this.initialized) {
                throw new IllegalArgumentException();
            }
            HashMap<Object, ArrayList<Object>> hashMap = new HashMap<Object, ArrayList<Object>>();
            for (Vertex object : this.vertexList) {
                if (object.predecessor == null) continue;
                Object object2 = object;
                while (((Vertex)object2).predecessor != null) {
                    object2 = ((Vertex)object2).predecessor;
                }
                ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(object2);
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>(2);
                    arrayList.add(((Vertex)object2).id);
                    hashMap.put(object2, arrayList);
                }
                arrayList.add(object.id);
            }
            ArrayList arrayList = new ArrayList(hashMap.size());
            for (Object object2 : hashMap.values()) {
                if (object2.size() <= 1) continue;
                arrayList.add(object2.toArray());
            }
            return arrayList;
        }

        private void DFS() {
            Integer n = new Integer(1);
            Integer n2 = new Integer(4);
            this.time = 0;
            ArrayList<Object> arrayList = new ArrayList<Object>(Math.max(1, this.vertexList.size()));
            Object object = null;
            Object object2 = null;
            Iterator<Vertex> iterator = this.vertexList.iterator();
            int n3 = 1;
            block6: while (true) {
                switch (n3) {
                    case 1: {
                        if (!iterator.hasNext()) break block6;
                        Vertex vertex = iterator.next();
                        if (vertex.color == "white") {
                            arrayList.add(n);
                            object2 = vertex;
                            n3 = 2;
                            continue block6;
                        }
                        n3 = 1;
                        continue block6;
                    }
                    case 2: {
                        ((Vertex)object2).color = "grey";
                        object = ((Vertex)object2).adjacent.iterator();
                        n3 = 3;
                        continue block6;
                    }
                    case 3: {
                        Object object3;
                        if (object.hasNext()) {
                            object3 = (Vertex)object.next();
                            if (((Vertex)object3).color == "white") {
                                ((Vertex)object3).predecessor = object2;
                                arrayList.add(object);
                                arrayList.add(object2);
                                arrayList.add(n2);
                                object2 = object3;
                                n3 = 2;
                                continue block6;
                            }
                            if (((Vertex)object3).color == "grey") {
                                this.cycles = true;
                            }
                            n3 = 3;
                            continue block6;
                        }
                        ((Vertex)object2).color = "black";
                        ((Vertex)object2).finishTime = ++this.time;
                        n3 = (Integer)arrayList.remove(arrayList.size() - 1);
                        continue block6;
                    }
                    case 4: {
                        Object object3;
                        object2 = (Vertex)arrayList.remove(arrayList.size() - 1);
                        object = object3 = (Iterator)arrayList.remove(arrayList.size() - 1);
                        n3 = 3;
                    }
                    default: {
                        continue block6;
                    }
                }
                break;
            }
        }

        public static class Vertex {
            public static final String WHITE = "white";
            public static final String GREY = "grey";
            public static final String BLACK = "black";
            public String color = "white";
            public Vertex predecessor = null;
            public int finishTime;
            public Object id;
            public List<Vertex> adjacent = new ArrayList<Vertex>(3);

            public Vertex(Object object) {
                this.id = object;
            }
        }
    }
}

