/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportPackageSpecificationImpl
extends VersionConstraintImpl
implements ImportPackageSpecification {
    private String resolution = "static";
    private String symbolicName;
    private VersionRange bundleVersionRange;
    private Map<String, Object> attributes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getDirectives() {
        Object object = this.monitor;
        synchronized (object) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
            if (this.resolution != null) {
                hashMap.put("resolution", this.resolution);
            }
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getDirective(String string) {
        Object object = this.monitor;
        synchronized (object) {
            if (string.equals("resolution")) {
                return this.resolution;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setDirective(String string, Object object) {
        Object object2 = this.monitor;
        synchronized (object2) {
            if (string.equals("resolution")) {
                this.resolution = (String)object;
                return this.resolution;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirectives(Map<String, ?> map) {
        Object object = this.monitor;
        synchronized (object) {
            if (map == null) {
                return;
            }
            this.resolution = (String)map.get("resolution");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBundleSymbolicName() {
        Object object = this.monitor;
        synchronized (object) {
            if ("system.bundle".equals(this.symbolicName)) {
                StateImpl stateImpl = (StateImpl)this.getBundle().getContainingState();
                String string = stateImpl == null ? Constants.getInternalSymbolicName() : stateImpl.getSystemBundle();
                return string;
            }
            return this.symbolicName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionRange getBundleVersionRange() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.bundleVersionRange == null) {
                return VersionRange.emptyRange;
            }
            return this.bundleVersionRange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getAttributes() {
        Object object = this.monitor;
        synchronized (object) {
            return this.attributes;
        }
    }

    @Override
    public boolean isSatisfiedBy(BaseDescription baseDescription) {
        String[] stringArray;
        String string;
        Object object;
        if (!(baseDescription instanceof ExportPackageDescription)) {
            return false;
        }
        ExportPackageDescriptionImpl exportPackageDescriptionImpl = (ExportPackageDescriptionImpl)baseDescription;
        String[] stringArray2 = (String[])exportPackageDescriptionImpl.getDirective("x-friends");
        Boolean bl = (Boolean)exportPackageDescriptionImpl.getDirective("x-internal");
        if (bl.booleanValue() || stringArray2 != null) {
            boolean bl2;
            object = (StateImpl)this.getBundle().getContainingState();
            boolean bl3 = bl2 = object == null ? false : ((StateImpl)object).inStrictMode();
            if (bl2) {
                if (bl.booleanValue()) {
                    return false;
                }
                boolean bl4 = false;
                if (stringArray2 != null && this.getBundle().getSymbolicName() != null) {
                    int n = 0;
                    while (n < stringArray2.length) {
                        if (this.getBundle().getSymbolicName().equals(stringArray2[n])) {
                            bl4 = true;
                        }
                        ++n;
                    }
                }
                if (!bl4) {
                    return false;
                }
            }
        }
        if ((object = this.getBundleSymbolicName()) != null) {
            BundleDescription bundleDescription = exportPackageDescriptionImpl.getExporter();
            if (!((String)object).equals(bundleDescription.getSymbolicName())) {
                return false;
            }
            if (this.getBundleVersionRange() != null && !this.getBundleVersionRange().isIncluded(bundleDescription.getVersion())) {
                return false;
            }
        }
        if (!("*".equals(string = this.getName()) || string.endsWith(".*") && exportPackageDescriptionImpl.getName().startsWith(string.substring(0, string.length() - 1)) || exportPackageDescriptionImpl.getName().equals(string))) {
            return false;
        }
        if (this.getVersionRange() != null && !this.getVersionRange().isIncluded(exportPackageDescriptionImpl.getVersion())) {
            return false;
        }
        Map<String, Object> map = this.getAttributes();
        if (map != null) {
            Map<String, Object> map2 = exportPackageDescriptionImpl.getAttributes();
            if (map2 == null) {
                return false;
            }
            for (String string2 : map.keySet()) {
                Object object2 = map.get(string2);
                Object object3 = map2.get(string2);
                if (object3 != null && object2.equals(object3)) continue;
                return false;
            }
        }
        if ((stringArray = (String[])exportPackageDescriptionImpl.getDirective("mandatory")) != null) {
            int n = 0;
            while (n < stringArray.length) {
                if ("bundle-symbolic-name".equals(stringArray[n])) {
                    if (object == null) {
                        return false;
                    }
                } else if ("bundle-version".equals(stringArray[n])) {
                    if (this.bundleVersionRange == null) {
                        return false;
                    }
                } else if ("specification-version".equals(stringArray[n]) || "version".equals(stringArray[n])) {
                    if (this.getVersionRange() == null) {
                        return false;
                    }
                } else {
                    if (map == null) {
                        return false;
                    }
                    if (map.get(stringArray[n]) == null) {
                        return false;
                    }
                }
                ++n;
            }
        }
        if (((BundleDescriptionImpl)this.getBundle()).getEquinoxEE() < 0) {
            return true;
        }
        int n = (Integer)exportPackageDescriptionImpl.getDirective("x-equinox-ee");
        return n < 0 || n == ((BundleDescriptionImpl)this.getBundle()).getEquinoxEE();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBundleSymbolicName(String string) {
        Object object = this.monitor;
        synchronized (object) {
            this.symbolicName = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBundleVersionRange(VersionRange versionRange) {
        Object object = this.monitor;
        synchronized (object) {
            this.bundleVersionRange = versionRange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAttributes(Map<String, ?> map) {
        Object object = this.monitor;
        synchronized (object) {
            this.attributes = map;
        }
    }

    public String toString() {
        return new StringBuffer("Import-Package: ").append(this.getName()).append("; version=\"").append(this.getVersionRange()).append("\"").toString();
    }

    @Override
    protected Map<String, String> getInternalDirectives() {
        Map<String, Object> map = this.getDirectives();
        map.put("filter", this.createFilterDirective());
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createFilterDirective() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(&");
        Object object = this.monitor;
        synchronized (object) {
            ImportPackageSpecificationImpl.addFilterAttribute(stringBuffer, "osgi.wiring.package", this.getName(), false);
            VersionRange versionRange = this.getVersionRange();
            if (versionRange != null && versionRange != VersionRange.emptyRange) {
                ImportPackageSpecificationImpl.addFilterAttribute(stringBuffer, "version", versionRange);
            }
            if (this.symbolicName != null) {
                ImportPackageSpecificationImpl.addFilterAttribute(stringBuffer, "bundle-symbolic-name", this.symbolicName);
            }
            if (this.bundleVersionRange != null) {
                ImportPackageSpecificationImpl.addFilterAttribute(stringBuffer, "bundle-version", this.bundleVersionRange);
            }
            if (this.attributes != null) {
                ImportPackageSpecificationImpl.addFilterAttributes(stringBuffer, this.attributes);
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    protected Map<String, Object> getInteralAttributes() {
        return Collections.EMPTY_MAP;
    }

    @Override
    protected String getInternalNameSpace() {
        return "osgi.wiring.package";
    }
}

