/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.internal.baseadaptor.ArrayMap;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ComputeNodeOrder;
import org.eclipse.osgi.internal.resolver.ImportsHolder;
import org.eclipse.osgi.internal.resolver.RequiresHolder;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StateHelperImpl
implements StateHelper {
    private static final StateHelper instance = new StateHelperImpl();

    @Override
    public BundleDescription[] getDependentBundles(BundleDescription[] bundleDescriptionArray) {
        if (bundleDescriptionArray == null || bundleDescriptionArray.length == 0) {
            return new BundleDescription[0];
        }
        HashSet<BundleDescription> hashSet = new HashSet<BundleDescription>(bundleDescriptionArray.length);
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            if (bundleDescriptionArray[n].isResolved()) {
                this.addDependentBundles(bundleDescriptionArray[n], hashSet);
            }
            ++n;
        }
        return hashSet.toArray(new BundleDescription[hashSet.size()]);
    }

    private void addDependentBundles(BundleDescription bundleDescription, Set<BundleDescription> set) {
        if (set.contains(bundleDescription)) {
            return;
        }
        set.add(bundleDescription);
        BundleDescription[] bundleDescriptionArray = bundleDescription.getDependents();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            this.addDependentBundles(bundleDescriptionArray[n], set);
            ++n;
        }
    }

    @Override
    public BundleDescription[] getPrerequisites(BundleDescription[] bundleDescriptionArray) {
        if (bundleDescriptionArray == null || bundleDescriptionArray.length == 0) {
            return new BundleDescription[0];
        }
        HashSet<BundleDescription> hashSet = new HashSet<BundleDescription>(bundleDescriptionArray.length);
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            this.addPrerequisites(bundleDescriptionArray[n], hashSet);
            ++n;
        }
        return hashSet.toArray(new BundleDescription[hashSet.size()]);
    }

    private void addPrerequisites(BundleDescription bundleDescription, Set<BundleDescription> set) {
        if (set.contains(bundleDescription)) {
            return;
        }
        set.add(bundleDescription);
        List<BundleDescription> list = ((BundleDescriptionImpl)bundleDescription).getBundleDependencies();
        BundleDescription[] bundleDescriptionArray = list.toArray(new BundleDescription[list.size()]);
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            this.addPrerequisites(bundleDescriptionArray[n], set);
            ++n;
        }
    }

    private Map<String, List<ExportPackageDescription>> getExportedPackageMap(State state) {
        HashMap<String, List<ExportPackageDescription>> hashMap = new HashMap<String, List<ExportPackageDescription>>();
        BundleDescription[] bundleDescriptionArray = state.getBundles();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            ExportPackageDescription[] exportPackageDescriptionArray = bundleDescriptionArray[n].getExportPackages();
            int n2 = 0;
            while (n2 < exportPackageDescriptionArray.length) {
                ExportPackageDescription exportPackageDescription = exportPackageDescriptionArray[n2];
                ArrayList<ExportPackageDescription> arrayList = (ArrayList<ExportPackageDescription>)hashMap.get(exportPackageDescription.getName());
                if (arrayList == null) {
                    arrayList = new ArrayList<ExportPackageDescription>();
                    hashMap.put(exportPackageDescription.getName(), arrayList);
                }
                arrayList.add(exportPackageDescription);
                ++n2;
            }
            ++n;
        }
        return hashMap;
    }

    private Map<String, List<GenericDescription>> getGenericsMap(State state, boolean bl) {
        HashMap<String, List<GenericDescription>> hashMap = new HashMap<String, List<GenericDescription>>();
        BundleDescription[] bundleDescriptionArray = state.getBundles();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            if (!bl || bundleDescriptionArray[n].isResolved()) {
                GenericDescription[] genericDescriptionArray = bundleDescriptionArray[n].getGenericCapabilities();
                int n2 = 0;
                while (n2 < genericDescriptionArray.length) {
                    GenericDescription genericDescription = genericDescriptionArray[n2];
                    ArrayList<GenericDescription> arrayList = (ArrayList<GenericDescription>)hashMap.get(genericDescription.getName());
                    if (arrayList == null) {
                        arrayList = new ArrayList<GenericDescription>(1);
                        hashMap.put(genericDescription.getName(), arrayList);
                    }
                    arrayList.add(genericDescription);
                    ++n2;
                }
            }
            ++n;
        }
        return hashMap;
    }

    private VersionConstraint[] getUnsatisfiedLeaves(State state, BundleDescription[] bundleDescriptionArray, ResolverHook resolverHook) {
        Map<String, List<ExportPackageDescription>> map = this.getExportedPackageMap(state);
        Map<String, List<GenericDescription>> map2 = this.getGenericsMap(state, false);
        HashSet<VersionConstraint> hashSet = new HashSet<VersionConstraint>();
        ArrayList<BundleDescription> arrayList = new ArrayList<BundleDescription>(bundleDescriptionArray.length);
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            arrayList.add(bundleDescriptionArray[n]);
            ++n;
        }
        n = 0;
        while (n < arrayList.size()) {
            BundleDescription bundleDescription = (BundleDescription)arrayList.get(n);
            VersionConstraint[] versionConstraintArray = this.getUnsatisfiedConstraints(bundleDescription, resolverHook);
            int n2 = 0;
            while (n2 < versionConstraintArray.length) {
                List<GenericDescription> list;
                VersionConstraint versionConstraint = versionConstraintArray[n2];
                List<BaseDescription> list2 = null;
                if (versionConstraint instanceof BundleSpecification || versionConstraint instanceof HostSpecification) {
                    BaseDescription[] baseDescriptionArray = state.getBundles(versionConstraint.getName());
                    list2 = this.getPossibleCandidates(versionConstraint, baseDescriptionArray, versionConstraint instanceof HostSpecification ? "osgi.wiring.host" : null, resolverHook, false);
                } else if (versionConstraint instanceof ImportPackageSpecification) {
                    List<ExportPackageDescription> list3 = map.get(versionConstraint.getName());
                    if (list3 != null) {
                        list2 = this.getPossibleCandidates(versionConstraint, list3.toArray(new BaseDescription[list3.size()]), null, resolverHook, false);
                    }
                } else if (versionConstraint instanceof GenericSpecification && (list = map2.get(versionConstraint.getName())) != null) {
                    list2 = this.getPossibleCandidates(versionConstraint, list.toArray(new BaseDescription[list.size()]), null, resolverHook, false);
                }
                if (list2 == null || list2.isEmpty()) {
                    hashSet.add(versionConstraint);
                } else {
                    for (BaseDescription baseDescription : list2) {
                        if (baseDescription.getSupplier().isResolved() || arrayList.contains(baseDescription.getSupplier())) continue;
                        arrayList.add(baseDescription.getSupplier());
                        break;
                    }
                }
                ++n2;
            }
            ++n;
        }
        return hashSet.toArray(new VersionConstraint[hashSet.size()]);
    }

    @Override
    public VersionConstraint[] getUnsatisfiedLeaves(BundleDescription[] bundleDescriptionArray) {
        if (bundleDescriptionArray.length == 0) {
            return new VersionConstraint[0];
        }
        State state = bundleDescriptionArray[0].getContainingState();
        ResolverHook resolverHook = this.beginHook(state, Arrays.asList(bundleDescriptionArray));
        try {
            VersionConstraint[] versionConstraintArray = this.getUnsatisfiedLeaves(state, bundleDescriptionArray, resolverHook);
            return versionConstraintArray;
        }
        finally {
            if (resolverHook != null) {
                resolverHook.end();
            }
        }
    }

    private ResolverHook beginHook(State state, Collection<BundleRevision> collection) {
        if (!(state instanceof StateImpl)) {
            return null;
        }
        ResolverHookFactory resolverHookFactory = ((StateImpl)state).getResolverHookFactory();
        return resolverHookFactory == null ? null : resolverHookFactory.begin(collection);
    }

    @Override
    public VersionConstraint[] getUnsatisfiedConstraints(BundleDescription bundleDescription) {
        ResolverHook resolverHook = this.beginHook(bundleDescription.getContainingState(), Arrays.asList(bundleDescription));
        try {
            VersionConstraint[] versionConstraintArray = this.getUnsatisfiedConstraints(bundleDescription, resolverHook);
            return versionConstraintArray;
        }
        finally {
            if (resolverHook != null) {
                resolverHook.end();
            }
        }
    }

    private VersionConstraint[] getUnsatisfiedConstraints(BundleDescription bundleDescription, ResolverHook resolverHook) {
        State state = bundleDescription.getContainingState();
        if (state == null) {
            throw new IllegalStateException("Does not belong to a state");
        }
        ArrayList<VersionConstraint> arrayList = new ArrayList<VersionConstraint>();
        HostSpecification hostSpecification = bundleDescription.getHost();
        if (hostSpecification != null && !hostSpecification.isResolved() && !this.isBundleConstraintResolvable(hostSpecification, "osgi.wiring.host", resolverHook)) {
            arrayList.add(hostSpecification);
        }
        BundleSpecification[] bundleSpecificationArray = bundleDescription.getRequiredBundles();
        int n = 0;
        while (n < bundleSpecificationArray.length) {
            if (!bundleSpecificationArray[n].isResolved() && !this.isBundleConstraintResolvable(bundleSpecificationArray[n], null, resolverHook)) {
                arrayList.add(bundleSpecificationArray[n]);
            }
            ++n;
        }
        ImportPackageSpecification[] importPackageSpecificationArray = bundleDescription.getImportPackages();
        int n2 = 0;
        while (n2 < importPackageSpecificationArray.length) {
            if (!(importPackageSpecificationArray[n2].isResolved() || this.isResolvable(importPackageSpecificationArray[n2], resolverHook) || bundleDescription.isResolved() && !"optional".equals(importPackageSpecificationArray[n2].getDirective("resolution")))) {
                arrayList.add(importPackageSpecificationArray[n2]);
            }
            ++n2;
        }
        GenericSpecification[] genericSpecificationArray = bundleDescription.getGenericRequires();
        int n3 = 0;
        while (n3 < genericSpecificationArray.length) {
            if (!genericSpecificationArray[n3].isResolved() && !this.isResolvable(genericSpecificationArray[n3], resolverHook)) {
                arrayList.add(genericSpecificationArray[n3]);
            }
            ++n3;
        }
        NativeCodeSpecification nativeCodeSpecification = bundleDescription.getNativeCodeSpecification();
        if (nativeCodeSpecification != null && !nativeCodeSpecification.isResolved()) {
            arrayList.add(nativeCodeSpecification);
        }
        return arrayList.toArray(new VersionConstraint[arrayList.size()]);
    }

    private ArrayMap<BundleCapability, BaseDescription> asArrayMap(List<BaseDescription> list, String string) {
        ArrayList<BundleCapability> arrayList = new ArrayList<BundleCapability>(list.size());
        for (BaseDescription baseDescription : list) {
            arrayList.add(((BaseDescriptionImpl)baseDescription).getCapability(string));
        }
        return new ArrayMap<BundleCapability, BaseDescription>(arrayList, list);
    }

    private List<BaseDescription> getPossibleCandidates(VersionConstraint versionConstraint, BaseDescription[] baseDescriptionArray, String string, ResolverHook resolverHook, boolean bl) {
        ArrayList<BaseDescription> arrayList = new ArrayList<BaseDescription>();
        int n = 0;
        while (n < baseDescriptionArray.length) {
            if ((!bl || baseDescriptionArray[n].getSupplier().isResolved()) && versionConstraint.isSatisfiedBy(baseDescriptionArray[n])) {
                arrayList.add(baseDescriptionArray[n]);
            }
            ++n;
        }
        if (resolverHook != null) {
            resolverHook.filterMatches(versionConstraint.getRequirement(), this.asArrayMap(arrayList, string));
        }
        return arrayList;
    }

    @Override
    public boolean isResolvable(ImportPackageSpecification importPackageSpecification) {
        ResolverHook resolverHook = this.beginHook(importPackageSpecification.getBundle().getContainingState(), Arrays.asList(importPackageSpecification.getBundle()));
        try {
            boolean bl = this.isResolvable(importPackageSpecification, resolverHook);
            return bl;
        }
        finally {
            if (resolverHook != null) {
                resolverHook.end();
            }
        }
    }

    private boolean isResolvable(ImportPackageSpecification importPackageSpecification, ResolverHook resolverHook) {
        BaseDescription[] baseDescriptionArray = importPackageSpecification.getBundle().getContainingState().getExportedPackages();
        return this.getPossibleCandidates(importPackageSpecification, baseDescriptionArray, null, resolverHook, true).size() > 0;
    }

    private boolean isResolvable(GenericSpecification genericSpecification, ResolverHook resolverHook) {
        Map<String, List<GenericDescription>> map = this.getGenericsMap(genericSpecification.getBundle().getContainingState(), true);
        List<GenericDescription> list = map.get(genericSpecification.getName());
        if (list == null) {
            return false;
        }
        return this.getPossibleCandidates(genericSpecification, list.toArray(new BaseDescription[list.size()]), null, resolverHook, true).size() > 0;
    }

    @Override
    public boolean isResolvable(BundleSpecification bundleSpecification) {
        return this.isBundleConstraintResolvable(bundleSpecification, null);
    }

    @Override
    public boolean isResolvable(HostSpecification hostSpecification) {
        return this.isBundleConstraintResolvable(hostSpecification, "osgi.wiring.host");
    }

    private boolean isBundleConstraintResolvable(VersionConstraint versionConstraint, String string) {
        ResolverHook resolverHook = this.beginHook(versionConstraint.getBundle().getContainingState(), Arrays.asList(versionConstraint.getBundle()));
        try {
            boolean bl = this.isBundleConstraintResolvable(versionConstraint, string, resolverHook);
            return bl;
        }
        finally {
            if (resolverHook != null) {
                resolverHook.end();
            }
        }
    }

    private boolean isBundleConstraintResolvable(VersionConstraint versionConstraint, String string, ResolverHook resolverHook) {
        BaseDescription[] baseDescriptionArray = versionConstraint.getBundle().getContainingState().getBundles(versionConstraint.getName());
        return this.getPossibleCandidates(versionConstraint, baseDescriptionArray, string, resolverHook, true).size() > 0;
    }

    @Override
    public Object[][] sortBundles(BundleDescription[] bundleDescriptionArray) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(bundleDescriptionArray.length);
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            if (bundleDescriptionArray[n].isResolved()) {
                this.buildReferences(bundleDescriptionArray[n], arrayList);
            }
            ++n;
        }
        Object[][] objectArray = ComputeNodeOrder.computeNodeOrder(bundleDescriptionArray, (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]));
        if (objectArray.length == 0) {
            return objectArray;
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            int n3 = 0;
            while (n3 < objectArray[n2].length) {
                BundleDescription bundleDescription;
                BundleDescription bundleDescription2 = (BundleDescription)objectArray[n2][n3];
                if (bundleDescription2.getHost() != null && (bundleDescription = (BundleDescription)bundleDescription2.getHost().getSupplier()) != null) {
                    this.fixFragmentOrder(bundleDescription, bundleDescription2, bundleDescriptionArray);
                }
                ++n3;
            }
            ++n2;
        }
        return objectArray;
    }

    private void fixFragmentOrder(BundleDescription bundleDescription, BundleDescription bundleDescription2, BundleDescription[] bundleDescriptionArray) {
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < bundleDescriptionArray.length && (n == -1 || n2 == -1)) {
            if (bundleDescriptionArray[n3] == bundleDescription) {
                n = n3;
            } else if (bundleDescriptionArray[n3] == bundleDescription2) {
                n2 = n3;
            }
            ++n3;
        }
        if (n2 > -1 && n2 < n) {
            n3 = n2;
            while (n3 < n) {
                bundleDescriptionArray[n3] = bundleDescriptionArray[n3 + 1];
                ++n3;
            }
            bundleDescriptionArray[n] = bundleDescription2;
        }
    }

    private void buildReferences(BundleDescription bundleDescription, List<Object[]> list) {
        HostSpecification hostSpecification = bundleDescription.getHost();
        if (hostSpecification != null) {
            if (hostSpecification.getHosts() != null) {
                BundleDescription[] bundleDescriptionArray = hostSpecification.getHosts();
                int n = 0;
                while (n < bundleDescriptionArray.length) {
                    if (bundleDescriptionArray[n] != bundleDescription) {
                        list.add(new Object[]{bundleDescription, bundleDescriptionArray[n]});
                    }
                    ++n;
                }
            }
        } else {
            this.buildReferences(bundleDescription, ((BundleDescriptionImpl)bundleDescription).getBundleDependencies(), list);
        }
    }

    private void buildReferences(BundleDescription bundleDescription, List<BundleDescription> list, List<Object[]> list2) {
        Iterator<BundleDescription> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addReference(bundleDescription, iterator.next(), list2);
        }
    }

    private void addReference(BundleDescription bundleDescription, BundleDescription bundleDescription2, List<Object[]> list) {
        if (bundleDescription == bundleDescription2 || bundleDescription2 == null) {
            return;
        }
        BundleDescription[] bundleDescriptionArray = bundleDescription2.getFragments();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            ExportPackageDescription[] exportPackageDescriptionArray;
            if (bundleDescriptionArray[n].isResolved() && (exportPackageDescriptionArray = bundleDescriptionArray[n].getExportPackages()).length > 0) {
                list.add(new Object[]{bundleDescription, bundleDescriptionArray[n]});
            }
            ++n;
        }
        list.add(new Object[]{bundleDescription, bundleDescription2});
    }

    @Override
    public ExportPackageDescription[] getVisiblePackages(BundleDescription bundleDescription) {
        return this.getVisiblePackages(bundleDescription, 0);
    }

    @Override
    public ExportPackageDescription[] getVisiblePackages(BundleDescription bundleDescription, int n) {
        Object object;
        Object object2;
        StateImpl stateImpl = (StateImpl)bundleDescription.getContainingState();
        boolean bl = false;
        if (stateImpl != null) {
            bl = stateImpl.inStrictMode();
        }
        BundleDescription bundleDescription2 = bundleDescription.getHost() == null ? bundleDescription : bundleDescription.getHost().getSupplier();
        ArrayList<ExportPackageDescription> arrayList = new ArrayList<ExportPackageDescription>();
        HashSet<ExportPackageDescription> hashSet = new HashSet<ExportPackageDescription>();
        HashSet<String> hashSet2 = new HashSet<String>();
        ImportsHolder importsHolder = new ImportsHolder(bundleDescription, n);
        int n2 = 0;
        while (n2 < importsHolder.getSize()) {
            object2 = importsHolder.getSupplier(n2);
            if (object2 != null && object2.getExporter() != bundleDescription2) {
                if (!this.isSystemExport((ExportPackageDescription)object2, n) && !hashSet.contains(object2)) {
                    arrayList.add((ExportPackageDescription)object2);
                    hashSet.add((ExportPackageDescription)object2);
                }
                BundleSpecification[] bundleSpecificationArray = object2.getExporter().getRequiredBundles();
                object = new HashSet<BundleDescription>();
                object.add(bundleDescription);
                HashSet<String> hashSet3 = new HashSet<String>(1);
                hashSet3.add(importsHolder.getName(n2));
                int n3 = 0;
                while (n3 < bundleSpecificationArray.length) {
                    BundleDescription bundleDescription3 = (BundleDescription)bundleSpecificationArray[n3].getSupplier();
                    if (bundleDescription3 != null) {
                        this.getPackages(bundleDescription3, bundleDescription.getSymbolicName(), hashSet2, arrayList, hashSet, (Set<BundleDescription>)object, bl, hashSet3, n);
                    }
                    ++n3;
                }
                hashSet2.add(importsHolder.getName(n2));
            }
            ++n2;
        }
        RequiresHolder requiresHolder = new RequiresHolder(bundleDescription, n);
        object2 = new HashSet(requiresHolder.getSize());
        object2.add(bundleDescription);
        int n4 = 0;
        while (n4 < requiresHolder.getSize()) {
            object = requiresHolder.getSupplier(n4);
            if (object != null) {
                this.getPackages((BundleDescription)object, bundleDescription.getSymbolicName(), hashSet2, arrayList, hashSet, (Set<BundleDescription>)object2, bl, null, n);
            }
            ++n4;
        }
        return arrayList.toArray(new ExportPackageDescription[arrayList.size()]);
    }

    private void getPackages(BundleDescription bundleDescription, String string, Set<String> hashSet, List<ExportPackageDescription> list, Set<ExportPackageDescription> set, Set<BundleDescription> set2, boolean bl, Set<String> set3, int n) {
        if (set2.contains(bundleDescription)) {
            return;
        }
        set2.add(bundleDescription);
        ExportPackageDescription[] exportPackageDescriptionArray = bundleDescription.getSubstitutedExports();
        ExportPackageDescription[] exportPackageDescriptionArray2 = bundleDescription.getResolvedImports();
        HashSet<String> hashSet2 = null;
        int n2 = 0;
        while (n2 < exportPackageDescriptionArray.length) {
            if (set3 == null || set3.contains(exportPackageDescriptionArray[n2].getName())) {
                int n3 = 0;
                while (n3 < exportPackageDescriptionArray2.length) {
                    if (exportPackageDescriptionArray[n2].getName().equals(exportPackageDescriptionArray2[n3].getName()) && !set.contains(exportPackageDescriptionArray2[n3])) {
                        if (hashSet2 == null) {
                            hashSet2 = new HashSet<String>(1);
                        } else {
                            hashSet2.clear();
                        }
                        hashSet2.add(exportPackageDescriptionArray[n2].getName());
                        this.getPackages(exportPackageDescriptionArray2[n3].getSupplier(), string, hashSet, list, set, new HashSet<BundleDescription>(0), bl, hashSet2, n);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        hashSet = exportPackageDescriptionArray.length == 0 ? hashSet : new HashSet<String>(hashSet);
        n2 = 0;
        while (n2 < exportPackageDescriptionArray.length) {
            hashSet.add(exportPackageDescriptionArray[n2].getName());
            ++n2;
        }
        ExportPackageDescription[] exportPackageDescriptionArray3 = bundleDescription.getSelectedExports();
        HashSet<String> hashSet3 = new HashSet<String>(exportPackageDescriptionArray3.length);
        int n4 = 0;
        while (n4 < exportPackageDescriptionArray3.length) {
            if (!(set3 != null && !set3.contains(exportPackageDescriptionArray3[n4].getName()) || this.isSystemExport(exportPackageDescriptionArray3[n4], n) || !this.isFriend(string, exportPackageDescriptionArray3[n4], bl) || hashSet.contains(exportPackageDescriptionArray3[n4].getName()) || set.contains(exportPackageDescriptionArray3[n4]) || hashSet3.contains(exportPackageDescriptionArray3[n4].getName()))) {
                list.add(exportPackageDescriptionArray3[n4]);
                set.add(exportPackageDescriptionArray3[n4]);
                hashSet3.add(exportPackageDescriptionArray3[n4].getName());
            }
            ++n4;
        }
        RequiresHolder requiresHolder = new RequiresHolder(bundleDescription, n);
        int n5 = 0;
        while (n5 < requiresHolder.getSize()) {
            if (requiresHolder.getSupplier(n5) != null) {
                if (requiresHolder.isExported(n5)) {
                    this.getPackages(requiresHolder.getSupplier(n5), string, hashSet, list, set, set2, bl, set3, n);
                } else if (hashSet3.size() > 0) {
                    HashSet<BundleDescription> hashSet4 = new HashSet<BundleDescription>();
                    this.getPackages(requiresHolder.getSupplier(n5), string, hashSet, list, set, hashSet4, bl, hashSet3, n);
                }
            }
            ++n5;
        }
    }

    private boolean isSystemExport(ExportPackageDescription exportPackageDescription, int n) {
        if ((n & 1) != 0) {
            return false;
        }
        return (Integer)exportPackageDescription.getDirective("x-equinox-ee") >= 0;
    }

    private boolean isFriend(String string, ExportPackageDescription exportPackageDescription, boolean bl) {
        if (!bl) {
            return true;
        }
        String[] stringArray = (String[])exportPackageDescription.getDirective("x-friends");
        if (stringArray == null) {
            return true;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public int getAccessCode(BundleDescription bundleDescription, ExportPackageDescription exportPackageDescription) {
        if (((Boolean)exportPackageDescription.getDirective("x-internal")).booleanValue()) {
            return 2;
        }
        if (!this.isFriend(bundleDescription.getSymbolicName(), exportPackageDescription, true)) {
            return 2;
        }
        return 1;
    }

    public static StateHelper getInstance() {
        return instance;
    }
}

