/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Collections;
import java.util.Map;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class VersionConstraintImpl
implements VersionConstraint {
    protected final Object monitor = new Object();
    private String name;
    private VersionRange versionRange;
    private BundleDescription bundle;
    private BaseDescription supplier;
    private static final Version MAX_VERSION = new Version(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);

    VersionConstraintImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        Object object = this.monitor;
        synchronized (object) {
            if ("system.bundle".equals(this.name)) {
                StateImpl stateImpl = (StateImpl)this.getBundle().getContainingState();
                String string = stateImpl == null ? Constants.getInternalSymbolicName() : stateImpl.getSystemBundle();
                return string;
            }
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionRange getVersionRange() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.versionRange == null) {
                return VersionRange.emptyRange;
            }
            return this.versionRange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleDescription getBundle() {
        Object object = this.monitor;
        synchronized (object) {
            return this.bundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isResolved() {
        Object object = this.monitor;
        synchronized (object) {
            return this.supplier != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseDescription getSupplier() {
        Object object = this.monitor;
        synchronized (object) {
            return this.supplier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSatisfiedBy(BaseDescription baseDescription) {
        Object object = this.monitor;
        synchronized (object) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setName(String string) {
        Object object = this.monitor;
        synchronized (object) {
            this.name = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setVersionRange(VersionRange versionRange) {
        Object object = this.monitor;
        synchronized (object) {
            this.versionRange = versionRange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBundle(BundleDescription bundleDescription) {
        Object object = this.monitor;
        synchronized (object) {
            this.bundle = bundleDescription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSupplier(BaseDescription baseDescription) {
        Object object = this.monitor;
        synchronized (object) {
            this.supplier = baseDescription;
        }
    }

    protected abstract String getInternalNameSpace();

    protected abstract Map<String, String> getInternalDirectives();

    protected abstract Map<String, Object> getInteralAttributes();

    @Override
    public BundleRequirement getRequirement() {
        String string = this.getInternalNameSpace();
        if (string == null) {
            return null;
        }
        return new BundleRequirementImpl(string);
    }

    static StringBuffer addFilterAttributes(StringBuffer stringBuffer, Map<String, ?> map) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            VersionConstraintImpl.addFilterAttribute(stringBuffer, entry.getKey(), entry.getValue());
        }
        return stringBuffer;
    }

    static StringBuffer addFilterAttribute(StringBuffer stringBuffer, String string, Object object) {
        return VersionConstraintImpl.addFilterAttribute(stringBuffer, string, object, true);
    }

    static StringBuffer addFilterAttribute(StringBuffer stringBuffer, String string, Object object, boolean bl) {
        if (object instanceof VersionRange) {
            VersionRange versionRange = (VersionRange)object;
            if (versionRange.getIncludeMinimum()) {
                stringBuffer.append('(').append(string).append(">=").append(VersionConstraintImpl.escapeValue(versionRange.getMinimum(), bl)).append(')');
            } else {
                stringBuffer.append("(!(").append(string).append("<=").append(VersionConstraintImpl.escapeValue(versionRange.getMinimum(), bl)).append("))");
            }
            if (!MAX_VERSION.equals(versionRange.getMaximum()) || !versionRange.getIncludeMaximum()) {
                if (versionRange.getIncludeMaximum()) {
                    stringBuffer.append('(').append(string).append("<=").append(VersionConstraintImpl.escapeValue(versionRange.getMaximum(), bl)).append(')');
                } else {
                    stringBuffer.append("(!(").append(string).append(">=").append(VersionConstraintImpl.escapeValue(versionRange.getMaximum(), bl)).append("))");
                }
            }
        } else {
            stringBuffer.append('(').append(string).append('=').append(VersionConstraintImpl.escapeValue(object, bl)).append(')');
        }
        return stringBuffer;
    }

    private static String escapeValue(Object object, boolean bl) {
        String string = object.toString();
        boolean bl2 = false;
        int n = string.length();
        int n2 = n << 1;
        char[] cArray = new char[n2];
        string.getChars(0, n, cArray, n);
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            char c = cArray[n4];
            switch (c) {
                case '*': {
                    if (!bl) break;
                }
                case '(': 
                case ')': 
                case '\\': {
                    cArray[n3] = 92;
                    ++n3;
                    bl2 = true;
                }
            }
            cArray[n3] = c;
            ++n3;
            ++n4;
        }
        return bl2 ? new String(cArray, 0, n3) : string;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BundleRequirementImpl
    implements BundleRequirement {
        private final String namespace;

        public BundleRequirementImpl(String string) {
            this.namespace = string;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public Map<String, String> getDirectives() {
            return Collections.unmodifiableMap(VersionConstraintImpl.this.getInternalDirectives());
        }

        @Override
        public Map<String, Object> getAttributes() {
            return Collections.unmodifiableMap(VersionConstraintImpl.this.getInteralAttributes());
        }

        @Override
        public BundleRevision getRevision() {
            return VersionConstraintImpl.this.getBundle();
        }

        @Override
        public boolean matches(BundleCapability bundleCapability) {
            return VersionConstraintImpl.this.isSatisfiedBy(((BaseDescriptionImpl.BaseCapability)bundleCapability).getBaseDescription());
        }

        public int hashCode() {
            return System.identityHashCode(VersionConstraintImpl.this);
        }

        private VersionConstraintImpl getVersionConstraint() {
            return VersionConstraintImpl.this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof BundleRequirementImpl)) {
                return false;
            }
            return ((BundleRequirementImpl)object).getVersionConstraint() == VersionConstraintImpl.this;
        }

        public String toString() {
            return new StringBuffer(String.valueOf(this.getNamespace())).append(BaseDescriptionImpl.toString(this.getAttributes(), false)).toString();
        }
    }
}

