/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.service.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.osgi.internal.signedcontent.SignedBundleHook;
import org.eclipse.osgi.internal.signedcontent.SignedContentMessages;
import org.eclipse.osgi.service.security.TrustEngine;
import org.eclipse.osgi.util.NLS;

public class KeyStoreTrustEngine
extends TrustEngine {
    private KeyStore keyStore;
    private final String type;
    private final String path;
    private final char[] password;
    private final String name;

    public KeyStoreTrustEngine(String string, String string2, char[] cArray, String string3) {
        this.path = string;
        this.type = string2;
        this.password = cArray;
        this.name = string3;
    }

    private String getType() {
        return this.type;
    }

    private String getPath() {
        return this.path;
    }

    private char[] getPassword() {
        return this.password;
    }

    private synchronized KeyStore getKeyStore() throws IOException, GeneralSecurityException {
        if (this.keyStore == null) {
            this.keyStore = KeyStore.getInstance(this.getType());
            InputStream inputStream = this.getInputStream();
            try {
                this.loadStore(this.keyStore, inputStream);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (this.keyStore == null) {
            throw new KeyStoreException(NLS.bind(SignedContentMessages.Default_Trust_Keystore_Load_Failed, this.getPath()));
        }
        return this.keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Certificate findTrustAnchor(Certificate[] certificateArray) throws IOException {
        if (certificateArray == null || certificateArray.length == 0) {
            throw new IllegalArgumentException("Certificate chain is required");
        }
        try {
            Object object = null;
            KeyStore keyStore = this.getKeyStore();
            int n = 0;
            while (n < certificateArray.length) {
                Object object2;
                if (certificateArray[n] instanceof X509Certificate) {
                    if (n == certificateArray.length - 1) {
                        object2 = (X509Certificate)certificateArray[n];
                        if (!((X509Certificate)object2).getSubjectDN().equals(((X509Certificate)object2).getIssuerDN())) return this.findAlternativeRoot((X509Certificate)object2, keyStore);
                        ((Certificate)object2).verify(((Certificate)object2).getPublicKey());
                        object = object2;
                    } else {
                        object2 = (X509Certificate)certificateArray[n + 1];
                        certificateArray[n].verify(((Certificate)object2).getPublicKey());
                    }
                }
                object2 = keyStore;
                synchronized (object2) {
                    String string;
                    String string2 = string = object == null ? null : keyStore.getCertificateAlias((Certificate)object);
                    if (string != null) {
                        return keyStore.getCertificate(string);
                    }
                    if (object != certificateArray[n] && (string = keyStore.getCertificateAlias(certificateArray[n])) != null) {
                        return keyStore.getCertificate(string);
                    }
                    if (certificateArray.length > 1 && n == certificateArray.length - 1 && certificateArray[n - 1] instanceof X509Certificate) {
                        return this.findAlternativeRoot((X509Certificate)certificateArray[n - 1], keyStore);
                    }
                }
                ++n;
            }
            return null;
        }
        catch (KeyStoreException keyStoreException) {
            throw (IOException)new IOException(keyStoreException.getMessage()).initCause(keyStoreException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            SignedBundleHook.log(generalSecurityException.getMessage(), 2, generalSecurityException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate findAlternativeRoot(X509Certificate x509Certificate, KeyStore keyStore) throws InvalidKeyException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, CertificateException {
        KeyStore keyStore2 = keyStore;
        synchronized (keyStore2) {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                Certificate certificate = keyStore.getCertificate(enumeration.nextElement());
                if (!(certificate instanceof X509Certificate) || !((X509Certificate)certificate).getSubjectDN().equals(x509Certificate.getIssuerDN())) continue;
                x509Certificate.verify(certificate.getPublicKey());
                return certificate;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doAddTrustAnchor(Certificate certificate, String string) throws IOException, GeneralSecurityException {
        if (this.isReadOnly()) {
            throw new IOException(SignedContentMessages.Default_Trust_Read_Only);
        }
        if (certificate == null) {
            throw new IllegalArgumentException("Certificate must be specified");
        }
        try {
            KeyStore keyStore;
            KeyStore keyStore2 = keyStore = this.getKeyStore();
            synchronized (keyStore2) {
                String string2 = keyStore.getCertificateAlias(certificate);
                if (string2 != null) {
                    throw new CertificateException(SignedContentMessages.Default_Trust_Existing_Cert);
                }
                Certificate certificate2 = keyStore.getCertificate(string);
                if (certificate2 != null) {
                    throw new CertificateException(SignedContentMessages.Default_Trust_Existing_Alias);
                }
                keyStore.setCertificateEntry(string, certificate);
                OutputStream outputStream = this.getOutputStream();
                try {
                    this.saveStore(keyStore, outputStream);
                }
                finally {
                    this.safeClose(outputStream);
                }
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw (CertificateException)new CertificateException(keyStoreException.getMessage()).initCause(keyStoreException);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRemoveTrustAnchor(Certificate certificate) throws IOException, GeneralSecurityException {
        if (this.isReadOnly()) {
            throw new IOException(SignedContentMessages.Default_Trust_Read_Only);
        }
        if (certificate == null) {
            throw new IllegalArgumentException("Certificate must be specified");
        }
        try {
            KeyStore keyStore;
            KeyStore keyStore2 = keyStore = this.getKeyStore();
            synchronized (keyStore2) {
                String string = keyStore.getCertificateAlias(certificate);
                if (string == null) {
                    throw new CertificateException(SignedContentMessages.Default_Trust_Cert_Not_Found);
                }
                this.removeTrustAnchor(string);
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw (CertificateException)new CertificateException(keyStoreException.getMessage()).initCause(keyStoreException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRemoveTrustAnchor(String string) throws IOException, GeneralSecurityException {
        if (string == null) {
            throw new IllegalArgumentException("Alias must be specified");
        }
        try {
            KeyStore keyStore;
            KeyStore keyStore2 = keyStore = this.getKeyStore();
            synchronized (keyStore2) {
                Certificate certificate = keyStore.getCertificate(string);
                if (certificate == null) {
                    throw new CertificateException(SignedContentMessages.Default_Trust_Cert_Not_Found);
                }
                keyStore.deleteEntry(string);
                OutputStream outputStream = this.getOutputStream();
                try {
                    this.saveStore(keyStore, outputStream);
                }
                finally {
                    this.safeClose(outputStream);
                }
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw (CertificateException)new CertificateException(keyStoreException.getMessage()).initCause(keyStoreException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Certificate getTrustAnchor(String string) throws IOException, GeneralSecurityException {
        if (string == null) {
            throw new IllegalArgumentException("Alias must be specified");
        }
        try {
            KeyStore keyStore;
            KeyStore keyStore2 = keyStore = this.getKeyStore();
            synchronized (keyStore2) {
                return keyStore.getCertificate(string);
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw (CertificateException)new CertificateException(keyStoreException.getMessage()).initCause(keyStoreException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAliases() throws IOException, GeneralSecurityException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            KeyStore keyStore;
            KeyStore keyStore2 = keyStore = this.getKeyStore();
            synchronized (keyStore2) {
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    if (!keyStore.isCertificateEntry(string)) continue;
                    arrayList.add(string);
                }
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw (CertificateException)new CertificateException(keyStoreException.getMessage()).initCause(keyStoreException);
        }
        return arrayList.toArray(new String[0]);
    }

    private void loadStore(KeyStore keyStore, InputStream inputStream) throws IOException, GeneralSecurityException {
        keyStore.load(inputStream, this.getPassword());
    }

    private void saveStore(KeyStore keyStore, OutputStream outputStream) throws IOException, GeneralSecurityException {
        keyStore.store(outputStream, this.getPassword());
    }

    private void safeClose(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    private InputStream getInputStream() throws IOException {
        return new FileInputStream(new File(this.getPath()));
    }

    private OutputStream getOutputStream() throws IOException {
        File file = new File(this.getPath());
        if (!file.exists()) {
            file.createNewFile();
        }
        return new FileOutputStream(file);
    }

    public boolean isReadOnly() {
        return this.getPassword() == null || !new File(this.path).canWrite();
    }

    public String getName() {
        return this.name;
    }
}

