/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.internal.signedcontent.DigestedInputStream;
import org.eclipse.osgi.internal.signedcontent.SignedBundleFile;
import org.eclipse.osgi.internal.signedcontent.SignedContentMessages;
import org.eclipse.osgi.signedcontent.InvalidContentException;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentEntry;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignedContentImpl
implements SignedContent {
    static final SignerInfo[] EMPTY_SIGNERINFO = new SignerInfo[0];
    volatile SignedBundleFile content;
    private final Map<String, Object> contentMDResults;
    private final SignerInfo[] signerInfos;
    private Map<SignerInfo, Object[]> tsaSignerInfos;
    private volatile boolean checkedValid = false;

    public SignedContentImpl(SignerInfo[] signerInfoArray, Map<String, Object> map) {
        this.signerInfos = signerInfoArray == null ? EMPTY_SIGNERINFO : signerInfoArray;
        this.contentMDResults = map;
    }

    @Override
    public SignedContentEntry[] getSignedEntries() {
        if (this.contentMDResults == null) {
            return new SignedContentEntry[0];
        }
        ArrayList<SignedContentEntryImpl> arrayList = new ArrayList<SignedContentEntryImpl>(this.contentMDResults.size());
        for (Map.Entry<String, Object> entry : this.contentMDResults.entrySet()) {
            String string = entry.getKey();
            Object[] objectArray = (Object[])entry.getValue();
            arrayList.add(new SignedContentEntryImpl(string, (SignerInfo[])objectArray[0]));
        }
        return arrayList.toArray(new SignedContentEntry[arrayList.size()]);
    }

    @Override
    public SignedContentEntry getSignedEntry(String string) {
        if (this.contentMDResults == null) {
            return null;
        }
        Object[] objectArray = (Object[])this.contentMDResults.get(string);
        return objectArray == null ? null : new SignedContentEntryImpl(string, (SignerInfo[])objectArray[0]);
    }

    @Override
    public SignerInfo[] getSignerInfos() {
        return this.signerInfos;
    }

    @Override
    public Date getSigningTime(SignerInfo signerInfo) {
        if (this.tsaSignerInfos == null) {
            return null;
        }
        Object[] objectArray = this.tsaSignerInfos.get(signerInfo);
        return objectArray == null ? null : (Date)objectArray[1];
    }

    @Override
    public SignerInfo getTSASignerInfo(SignerInfo signerInfo) {
        if (this.tsaSignerInfos == null) {
            return null;
        }
        Object[] objectArray = this.tsaSignerInfos.get(signerInfo);
        return objectArray == null ? null : (SignerInfo)objectArray[0];
    }

    @Override
    public boolean isSigned() {
        return this.signerInfos.length > 0;
    }

    @Override
    public void checkValidity(SignerInfo signerInfo) throws CertificateExpiredException, CertificateNotYetValidException {
        Date date = this.getSigningTime(signerInfo);
        if (this.checkedValid) {
            return;
        }
        Certificate[] certificateArray = signerInfo.getCertificateChain();
        int n = 0;
        while (n < certificateArray.length) {
            if (certificateArray[n] instanceof X509Certificate) {
                if (date == null) {
                    ((X509Certificate)certificateArray[n]).checkValidity();
                } else {
                    ((X509Certificate)certificateArray[n]).checkValidity(date);
                }
            }
            ++n;
        }
        this.checkedValid = true;
    }

    void setContent(SignedBundleFile signedBundleFile) {
        this.content = signedBundleFile;
    }

    void setTSASignerInfos(Map<SignerInfo, Object[]> map) {
        this.tsaSignerInfos = map;
    }

    void addTSASignerInfo(SignerInfo signerInfo, SignerInfo signerInfo2, Date date) {
        if (!this.containsInfo(signerInfo)) {
            throw new IllegalArgumentException("The baseInfo is not found");
        }
        if (this.tsaSignerInfos == null) {
            this.tsaSignerInfos = new HashMap<SignerInfo, Object[]>(this.signerInfos.length);
        }
        this.tsaSignerInfos.put(signerInfo, new Object[]{signerInfo2, date});
    }

    Map<String, Object> getContentMDResults() {
        return this.contentMDResults;
    }

    private boolean containsInfo(SignerInfo signerInfo) {
        int n = 0;
        while (n < this.signerInfos.length) {
            if (signerInfo == this.signerInfos[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    InputStream getDigestInputStream(BundleEntry bundleEntry) throws IOException {
        if (this.contentMDResults == null) {
            return bundleEntry.getInputStream();
        }
        Object[] objectArray = (Object[])this.contentMDResults.get(bundleEntry.getName());
        if (objectArray == null) {
            return null;
        }
        return new DigestedInputStream(bundleEntry, this.content, (SignerInfo[])objectArray[0], (byte[][])objectArray[1], bundleEntry.getSize());
    }

    public class SignedContentEntryImpl
    implements SignedContentEntry {
        private final String entryName;
        private final SignerInfo[] entrySigners;

        public SignedContentEntryImpl(String string, SignerInfo[] signerInfoArray) {
            this.entryName = string;
            this.entrySigners = signerInfoArray == null ? EMPTY_SIGNERINFO : signerInfoArray;
        }

        public String getName() {
            return this.entryName;
        }

        public SignerInfo[] getSignerInfos() {
            return this.entrySigners;
        }

        public boolean isSigned() {
            return this.entrySigners.length > 0;
        }

        public void verify() throws IOException, InvalidContentException {
            SignedBundleFile signedBundleFile = SignedContentImpl.this.content;
            if (signedBundleFile == null) {
                throw new InvalidContentException("The content was not set", null);
            }
            BundleEntry bundleEntry = null;
            SecurityException securityException = null;
            try {
                bundleEntry = ((BundleFile)signedBundleFile).getEntry(this.entryName);
            }
            catch (SecurityException securityException2) {
                securityException = securityException2;
            }
            if (bundleEntry == null) {
                throw new InvalidContentException(NLS.bind(SignedContentMessages.file_is_removed_from_jar, this.entryName, ((BundleFile)signedBundleFile).getBaseFile().toString()), securityException);
            }
            bundleEntry.getBytes();
        }
    }
}

