/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.service.resolver;

import org.osgi.framework.Version;

public class VersionRange {
    private static final Version versionMax = new Version(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final VersionRange emptyRange = new VersionRange(null);
    private final Version minVersion;
    private final boolean includeMin;
    private final Version maxVersion;
    private final boolean includeMax;

    public VersionRange(Version version, boolean bl, Version version2, boolean bl2) {
        this.minVersion = version == null ? Version.emptyVersion : version;
        this.includeMin = bl;
        this.maxVersion = version2 == null ? versionMax : version2;
        this.includeMax = bl2;
    }

    public VersionRange(String string) {
        if (string == null || string.length() == 0) {
            this.minVersion = Version.emptyVersion;
            this.includeMin = true;
            this.maxVersion = versionMax;
            this.includeMax = true;
            return;
        }
        if ((string = string.trim()).charAt(0) == '[' || string.charAt(0) == '(') {
            int n = string.indexOf(44);
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            char c = string.charAt(string.length() - 1);
            if (c != ']' && c != ')') {
                throw new IllegalArgumentException();
            }
            this.minVersion = Version.parseVersion(string.substring(1, n).trim());
            this.includeMin = string.charAt(0) == '[';
            this.maxVersion = Version.parseVersion(string.substring(n + 1, string.length() - 1).trim());
            this.includeMax = c == ']';
        } else {
            this.minVersion = Version.parseVersion(string.trim());
            this.includeMin = true;
            this.maxVersion = versionMax;
            this.includeMax = true;
        }
    }

    public Version getMinimum() {
        return this.minVersion;
    }

    public boolean getIncludeMinimum() {
        return this.includeMin;
    }

    public Version getMaximum() {
        return this.maxVersion;
    }

    public boolean getIncludeMaximum() {
        return this.includeMax;
    }

    public boolean isIncluded(Version version) {
        int n;
        if (version == null) {
            version = Version.emptyVersion;
        }
        int n2 = this.includeMin ? 0 : 1;
        int n3 = n = this.includeMax ? 0 : -1;
        return version.compareTo(this.minVersion) >= n2 && version.compareTo(this.maxVersion) <= n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof VersionRange)) {
            return false;
        }
        VersionRange versionRange = (VersionRange)object;
        return this.minVersion.equals(versionRange.getMinimum()) && this.includeMin == versionRange.includeMin && this.maxVersion.equals(versionRange.getMaximum()) && this.includeMax == versionRange.includeMax;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.maxVersion.hashCode();
        n = 31 * n + this.minVersion.hashCode();
        n = 31 * n + (this.includeMax ? 1231 : 1237);
        n = 31 * n + (this.includeMin ? 1231 : 1237);
        return n;
    }

    public String toString() {
        if (versionMax.equals(this.maxVersion)) {
            return this.minVersion.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.includeMin ? (char)'[' : '(');
        stringBuffer.append(this.minVersion);
        stringBuffer.append(',');
        stringBuffer.append(this.maxVersion);
        stringBuffer.append(this.includeMax ? (char)']' : ')');
        return stringBuffer.toString();
    }
}

