/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.CapabilityPermissionCollection;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.SignerProperty;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CapabilityPermission
extends BasicPermission {
    static final long serialVersionUID = -7662148639076511574L;
    public static final String REQUIRE = "require";
    public static final String PROVIDE = "provide";
    private static final int ACTION_REQUIRE = 1;
    private static final int ACTION_PROVIDE = 2;
    private static final int ACTION_ALL = 3;
    static final int ACTION_NONE = 0;
    transient int action_mask;
    private volatile String actions = null;
    final transient Map<String, Object> attributes;
    final transient Bundle bundle;
    transient Filter filter;
    private volatile transient Map<String, Object> properties;

    public CapabilityPermission(String string, String string2) {
        this(string, CapabilityPermission.parseActions(string2));
        if (this.filter != null && (this.action_mask & 3) != 1) {
            throw new IllegalArgumentException("invalid action string for filter expression");
        }
    }

    public CapabilityPermission(String string, Map<String, ?> map, Bundle bundle, String string2) {
        super(string);
        this.setTransients(string, CapabilityPermission.parseActions(string2));
        if (map == null) {
            throw new IllegalArgumentException("attributes must not be null");
        }
        if (bundle == null) {
            throw new IllegalArgumentException("bundle must not be null");
        }
        this.attributes = new HashMap(map);
        this.bundle = bundle;
        if ((this.action_mask & 3) != 1) {
            throw new IllegalArgumentException("invalid action string");
        }
    }

    CapabilityPermission(String string, int n) {
        super(string);
        this.setTransients(string, n);
        this.attributes = null;
        this.bundle = null;
    }

    private void setTransients(String string, int n) {
        if (n == 0 || (n & 3) != n) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = n;
        this.filter = CapabilityPermission.parseFilter(string);
    }

    /*
     * Unable to fully structure code
     */
    private static int parseActions(String var0) {
        var1_1 = false;
        var2_2 = 0;
        if (var0 == null) {
            return var2_2;
        }
        var3_3 = var0.toCharArray();
        var4_4 = var3_3.length - 1;
        if (var4_4 >= 0) ** GOTO lbl33
        return var2_2;
        {
            --var4_4;
            do {
                if (var4_4 != -1 && ((var5_5 = var3_3[var4_4]) == ' ' || var5_5 == '\r' || var5_5 == '\n' || var5_5 == '\f' || var5_5 == '\t')) continue block4;
                if (!(var4_4 < 6 || var3_3[var4_4 - 6] != 'r' && var3_3[var4_4 - 6] != 'R' || var3_3[var4_4 - 5] != 'e' && var3_3[var4_4 - 5] != 'E' || var3_3[var4_4 - 4] != 'q' && var3_3[var4_4 - 4] != 'Q' || var3_3[var4_4 - 3] != 'u' && var3_3[var4_4 - 3] != 'U' || var3_3[var4_4 - 2] != 'i' && var3_3[var4_4 - 2] != 'I' || var3_3[var4_4 - 1] != 'r' && var3_3[var4_4 - 1] != 'R' || var3_3[var4_4] != 'e' && var3_3[var4_4] != 'E')) {
                    var6_6 = 7;
                    var2_2 |= 1;
                } else if (!(var4_4 < 6 || var3_3[var4_4 - 6] != 'p' && var3_3[var4_4 - 6] != 'P' || var3_3[var4_4 - 5] != 'r' && var3_3[var4_4 - 5] != 'R' || var3_3[var4_4 - 4] != 'o' && var3_3[var4_4 - 4] != 'O' || var3_3[var4_4 - 3] != 'v' && var3_3[var4_4 - 3] != 'V' || var3_3[var4_4 - 2] != 'i' && var3_3[var4_4 - 2] != 'I' || var3_3[var4_4 - 1] != 'd' && var3_3[var4_4 - 1] != 'D' || var3_3[var4_4] != 'e' && var3_3[var4_4] != 'E')) {
                    var6_6 = 7;
                    var2_2 |= 2;
                } else {
                    throw new IllegalArgumentException(new StringBuffer("invalid permission: ").append(var0).toString());
                }
                var1_1 = false;
                while (var4_4 >= var6_6 && !var1_1) {
                    switch (var3_3[var4_4 - var6_6]) {
                        case ',': {
                            var1_1 = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(new StringBuffer("invalid permission: ").append(var0).toString());
                        }
                    }
                    --var4_4;
                }
                var4_4 -= var6_6;
lbl33:
                // 2 sources

            } while (var4_4 != -1);
        }
        if (var1_1) {
            throw new IllegalArgumentException(new StringBuffer("invalid permission: ").append(var0).toString());
        }
        return var2_2;
    }

    private static Filter parseFilter(String string) {
        if ((string = string.trim()).charAt(0) != '(') {
            return null;
        }
        try {
            return FrameworkUtil.createFilter(string);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid filter");
            illegalArgumentException.initCause(invalidSyntaxException);
            throw illegalArgumentException;
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof CapabilityPermission)) {
            return false;
        }
        CapabilityPermission capabilityPermission = (CapabilityPermission)permission;
        if (this.bundle != null) {
            return false;
        }
        if (capabilityPermission.filter != null) {
            return false;
        }
        return this.implies0(capabilityPermission, 0);
    }

    boolean implies0(CapabilityPermission capabilityPermission, int n) {
        int n2 = capabilityPermission.action_mask;
        if (((n |= this.action_mask) & n2) != n2) {
            return false;
        }
        Filter filter = this.filter;
        if (filter == null) {
            return super.implies(capabilityPermission);
        }
        return filter.matches(capabilityPermission.getProperties());
    }

    @Override
    public String getActions() {
        String string = this.actions;
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n = this.action_mask;
            if ((n & 1) == 1) {
                stringBuffer.append(REQUIRE);
                bl = true;
            }
            if ((n & 2) == 2) {
                if (bl) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(PROVIDE);
            }
            this.actions = string = stringBuffer.toString();
        }
        return string;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new CapabilityPermissionCollection();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CapabilityPermission)) {
            return false;
        }
        CapabilityPermission capabilityPermission = (CapabilityPermission)object;
        return this.action_mask == capabilityPermission.action_mask && this.getName().equals(capabilityPermission.getName()) && (this.attributes == capabilityPermission.attributes || this.attributes != null && this.attributes.equals(capabilityPermission.attributes)) && (this.bundle == capabilityPermission.bundle || this.bundle != null && this.bundle.equals(capabilityPermission.bundle));
    }

    @Override
    public int hashCode() {
        int n = 527 + this.getName().hashCode();
        n = 31 * n + this.getActions().hashCode();
        if (this.attributes != null) {
            n = 31 * n + this.attributes.hashCode();
        }
        if (this.bundle != null) {
            n = 31 * n + this.bundle.hashCode();
        }
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.bundle != null) {
            throw new NotSerializableException("cannot serialize");
        }
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setTransients(this.getName(), CapabilityPermission.parseActions(this.actions));
    }

    private Map<String, Object> getProperties() {
        Map<String, Object> map = this.properties;
        if (map != null) {
            return map;
        }
        final HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
        hashMap.put("capability.namespace", this.getName());
        if (this.bundle == null) {
            this.properties = hashMap;
            return this.properties;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SignerProperty signerProperty;
                hashMap.put("id", new Long(CapabilityPermission.this.bundle.getBundleId()));
                hashMap.put("location", CapabilityPermission.this.bundle.getLocation());
                String string = CapabilityPermission.this.bundle.getSymbolicName();
                if (string != null) {
                    hashMap.put("name", string);
                }
                if ((signerProperty = new SignerProperty(CapabilityPermission.this.bundle)).isBundleSigned()) {
                    hashMap.put("signer", signerProperty);
                }
                return null;
            }
        });
        this.properties = new Properties(hashMap, this.attributes);
        return this.properties;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Properties
    extends AbstractMap<String, Object> {
        private final Map<String, Object> properties;
        private final Map<String, Object> attributes;
        private volatile transient Set<Map.Entry<String, Object>> entries;

        Properties(Map<String, Object> map, Map<String, Object> map2) {
            this.properties = map;
            this.attributes = map2;
            this.entries = null;
        }

        @Override
        public Object get(Object object) {
            if (!(object instanceof String)) {
                return null;
            }
            String string = (String)object;
            if (string.charAt(0) == '@') {
                return this.attributes.get(string.substring(1));
            }
            Object object2 = this.properties.get(string);
            if (object2 != null) {
                return object2;
            }
            return this.attributes.get(string);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            if (this.entries != null) {
                return this.entries;
            }
            HashSet<Map.Entry<String, Object>> hashSet = new HashSet<Map.Entry<String, Object>>(this.attributes.size() + this.properties.size());
            hashSet.addAll(this.attributes.entrySet());
            hashSet.addAll(this.properties.entrySet());
            this.entries = Collections.unmodifiableSet(hashSet);
            return this.entries;
        }
    }
}

